/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import org.apache.openjpa.lib.util.SimpleRegex;
import org.junit.Assert;
import org.junit.Test;

public class TestSimpleRegex {
    private boolean matchExpr(String target, String expr, boolean caseInsens) {
        SimpleRegex re = new SimpleRegex(expr, caseInsens);
        return re.matches(target);
    }

    @Test
    public void testWildcards() {
        Assert.assertTrue((boolean)this.matchExpr("Hello", "Hello", false));
        Assert.assertFalse((boolean)this.matchExpr("Hello", "Bye", false));
        Assert.assertFalse((boolean)this.matchExpr("Hello", "ByeBye", false));
        Assert.assertFalse((boolean)this.matchExpr("Hello", "Hellooo", false));
        Assert.assertFalse((boolean)this.matchExpr("Hello", "HHello", false));
        Assert.assertTrue((boolean)this.matchExpr("Hello", "H.llo", false));
        Assert.assertTrue((boolean)this.matchExpr("Hello", "Hell.*", false));
        Assert.assertTrue((boolean)this.matchExpr("Yo Hello", ".*ello", false));
        Assert.assertTrue((boolean)this.matchExpr("Hello", ".*ello", false));
        Assert.assertTrue((boolean)this.matchExpr("Hello", ".*ell.*", false));
        Assert.assertTrue((boolean)this.matchExpr("Hellow", ".*ell.*", false));
        Assert.assertTrue((boolean)this.matchExpr("Hello", "Hel.*lo", false));
        Assert.assertTrue((boolean)this.matchExpr("HelYolo", "Hel.*lo", false));
        Assert.assertTrue((boolean)this.matchExpr("Hello", "H.*lo", false));
        Assert.assertFalse((boolean)this.matchExpr("Hellowe", "H.*lo", false));
        Assert.assertTrue((boolean)this.matchExpr("Hello", "h.*lo", true));
        Assert.assertFalse((boolean)this.matchExpr("Hello", "h.*lo", false));
        Assert.assertTrue((boolean)this.matchExpr("The quick brown fox jumped over the lazy dog", "The .*brown.*dog", false));
        Assert.assertTrue((boolean)this.matchExpr("The quick brown fox jumped over the lazy dog", "The .*br.wn.*d.g", false));
        Assert.assertTrue((boolean)this.matchExpr("the quick BRown fox jumped over the lazy dog", "The .*br.wn.*d.g", true));
        Assert.assertFalse((boolean)this.matchExpr("The quick brown fox jumped over the lazy dog", "The .*brown.*dogg", false));
        Assert.assertFalse((boolean)this.matchExpr("The quick brown fox jumped over the lazy dog", "TThe .*brown.*dogg", false));
        Assert.assertFalse((boolean)this.matchExpr("Yo Hellow", ".*ello", false));
        Assert.assertFalse((boolean)this.matchExpr("Hellow", ".*YoHello", false));
    }
}

