/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.testlocalizer.LocalizerTestHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLocalizer {
    private Localizer _locals = null;

    @Before
    public void setUp() {
        this._locals = Localizer.forPackage(LocalizerTestHelper.class);
    }

    @Test
    public void testForClass() {
        TestLocalizer.assertEqualsMSg(Locale.getDefault().equals(Locale.GERMANY) ? "value1_de" : "value1", this._locals.get("test.local1"));
    }

    @Test
    public void testForLocale() {
        Localizer locl = Localizer.forPackage(LocalizerTestHelper.class, (Locale)Locale.GERMANY);
        TestLocalizer.assertEqualsMSg("value1_de", locl.get("test.local1"));
    }

    @Test
    public void testFallbackLocale() {
        Localizer locl = Localizer.forPackage(LocalizerTestHelper.class, (Locale)Locale.FRANCE);
        TestLocalizer.assertEqualsMSg(Locale.getDefault().equals(Locale.GERMANY) ? "value1_de" : "value1", locl.get("test.local1"));
    }

    @Test
    public void testTopLevel() {
        Localizer system = Localizer.forPackage(null);
        TestLocalizer.assertEqualsMSg("systemvalue1", system.get("test.systemlocal"));
    }

    @Test
    public void testMessageFormat() {
        String suffix = Locale.getDefault().equals(Locale.GERMANY) ? "_de" : "";
        TestLocalizer.assertEqualsMSg("value2" + suffix + " x sep y", this._locals.get("test.local2", (Object[])new String[]{"x", "y"}));
        TestLocalizer.assertEqualsMSg("value2" + suffix + " x sep {1}", this._locals.get("test.local2", (Object)"x"));
    }

    @Test
    public void testMissingBundle() {
        Localizer missing = Localizer.forPackage(String.class);
        TestLocalizer.assertEqualsMSg("localized message key: foo.bar", missing.get("foo.bar"));
        TestLocalizer.assertEqualsMSg("localized message key: foo.bar; substitutions: [baz, 1]", missing.get("foo.bar", (Object)"baz", (Object)1));
        try {
            missing.getFatal("foo.bar");
            Assert.fail((String)"No exception for fatal get on missing bundle.");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    @Test
    public void testMissingKey() {
        TestLocalizer.assertEqualsMSg("localized message key: foo.bar", this._locals.get("foo.bar"));
        TestLocalizer.assertEqualsMSg("localized message key: foo.bar; substitutions: [baz, 1]", this._locals.get("foo.bar", (Object)"baz", (Object)1));
        try {
            this._locals.getFatal("foo.bar");
            Assert.fail((String)"No exception for fatal get on missing key.");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public static void assertEqualsMSg(String s, Localizer.Message m) {
        Assert.assertEquals((Object)s, (Object)m.getMessage());
    }
}

