/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.util.concurrent.TimeUnit;
import org.apache.openjpa.lib.util.StringUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class StringUtilTest {
    @Test
    public void testStringSplit() {
        String val = " a b c \n d \n  \n";
        String[] jsplit = val.split(" ");
        String[] split1 = StringUtil.split((String)val, (String)" ", (int)0);
        String[] split2 = StringUtil.split((String)val, (String)" ", (int)30);
        String[] split3 = StringUtil.split((String)val, (String)" ", (int)3);
        Assert.assertEquals((long)3L, (long)split3.length);
        Assert.assertEquals((Object)"", (Object)split3[0]);
        Assert.assertEquals((Object)"a", (Object)split3[1]);
        Assert.assertEquals((Object)"b c \n d \n  \n", (Object)split3[2]);
    }

    @Test
    public void testStringSplitEnding() {
        String val = "a%B%C%";
        String[] jsplit = val.split("%");
        Object[] ssplit = StringUtil.split((String)val, (String)"%", (int)Integer.MAX_VALUE);
        Assert.assertEquals((long)4L, (long)ssplit.length);
        Assert.assertArrayEquals((Object[])ssplit, (Object[])new String[]{"a", "B", "C", ""});
    }

    @Test
    public void testStringSplitFatTokenEnding() {
        String val = "a-.-B-.-C-.-";
        String[] jsplit = val.split("-.-");
        Object[] ssplit = StringUtil.split((String)val, (String)"-.-", (int)Integer.MAX_VALUE);
        Assert.assertEquals((long)4L, (long)ssplit.length);
        Assert.assertArrayEquals((Object[])ssplit, (Object[])new String[]{"a", "B", "C", ""});
    }

    @Test
    public void testTrimToNull() {
        Assert.assertNull((Object)StringUtil.trimToNull(null));
        Assert.assertNull((Object)StringUtil.trimToNull((String)" "));
        Assert.assertNull((Object)StringUtil.trimToNull((String)"   "));
        Assert.assertNull((Object)StringUtil.trimToNull((String)"   \n  "));
        Assert.assertEquals((Object)"A", (Object)StringUtil.trimToNull((String)"  A"));
        Assert.assertEquals((Object)"A", (Object)StringUtil.trimToNull((String)"A  "));
        Assert.assertEquals((Object)"A", (Object)StringUtil.trimToNull((String)"  A  "));
        Assert.assertEquals((Object)"A", (Object)StringUtil.trimToNull((String)"  A  \n  "));
    }

    @Test
    public void testStringCapitalize() {
        Assert.assertNull((Object)StringUtil.capitalize(null));
        Assert.assertEquals((Object)"", (Object)StringUtil.capitalize((String)""));
        Assert.assertEquals((Object)" ", (Object)StringUtil.capitalize((String)" "));
        Assert.assertEquals((Object)"Ahoi", (Object)StringUtil.capitalize((String)"ahoi"));
        Assert.assertEquals((Object)"Ahoi", (Object)StringUtil.capitalize((String)"Ahoi"));
        Assert.assertEquals((Object)" ahoi", (Object)StringUtil.capitalize((String)" ahoi"));
        Assert.assertEquals((Object)"\u00d6hoi", (Object)StringUtil.capitalize((String)"\u00f6hoi"));
        Assert.assertEquals((Object)"\u00dfhoi", (Object)StringUtil.capitalize((String)"\u00dfhoi"));
    }

    @Test
    public void testStringEndsWith() {
        Assert.assertFalse((boolean)StringUtil.endsWithIgnoreCase(null, (String)"bla"));
        Assert.assertFalse((boolean)StringUtil.endsWithIgnoreCase((String)"bla", null));
        Assert.assertTrue((boolean)StringUtil.endsWithIgnoreCase(null, null));
        Assert.assertTrue((boolean)StringUtil.endsWithIgnoreCase(null, null));
        Assert.assertTrue((boolean)StringUtil.endsWithIgnoreCase((String)"I have a cAt", (String)"Cat"));
        Assert.assertFalse((boolean)StringUtil.endsWithIgnoreCase((String)"at", (String)"Cat"));
        Assert.assertTrue((boolean)StringUtil.endsWithIgnoreCase((String)"at", (String)""));
    }

    @Test
    public void testStringParse() {
        try {
            StringUtil.parse(null, null);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)((Byte)StringUtil.parse(null, Byte.TYPE)).byteValue());
        Assert.assertEquals((long)0L, (long)((Character)StringUtil.parse(null, Character.TYPE)).charValue());
        Assert.assertEquals((double)0.0, (double)((Double)StringUtil.parse(null, Double.TYPE)), (double)0.0);
        Assert.assertEquals((float)0.0f, (float)((Float)StringUtil.parse(null, Float.TYPE)).floatValue(), (float)0.0f);
        Assert.assertEquals((long)0L, (long)((Integer)StringUtil.parse(null, Integer.TYPE)).intValue());
        Assert.assertEquals((long)0L, (long)((Long)StringUtil.parse(null, Long.TYPE)));
        Assert.assertEquals((long)0L, (long)((Short)StringUtil.parse(null, Short.TYPE)).shortValue());
        Assert.assertEquals((Object)false, (Object)StringUtil.parse(null, Boolean.TYPE));
        try {
            StringUtil.parse(null, Void.TYPE);
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertNull((Object)StringUtil.parse(null, Character.class));
        Assert.assertNull((Object)StringUtil.parse(null, Double.class));
        Assert.assertNull((Object)StringUtil.parse(null, Float.class));
        Assert.assertNull((Object)StringUtil.parse(null, Integer.class));
        Assert.assertNull((Object)StringUtil.parse(null, Long.class));
        Assert.assertNull((Object)StringUtil.parse(null, Short.class));
        Assert.assertNull((Object)StringUtil.parse(null, Boolean.class));
        try {
            StringUtil.parse(null, char[].class);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)67L, (long)((Character)StringUtil.parse((String)"C", Character.TYPE)).charValue());
        Assert.assertEquals((double)35.2345, (double)((Double)StringUtil.parse((String)"35.2345", Double.TYPE)), (double)1.0E-6);
        Assert.assertEquals((double)35.2345, (double)((Float)StringUtil.parse((String)"35.2345", Float.TYPE)).floatValue(), (double)1.0E-6);
        Assert.assertEquals((long)42L, (long)((Integer)StringUtil.parse((String)"42", Integer.TYPE)).intValue());
        Assert.assertEquals((long)42L, (long)((Long)StringUtil.parse((String)"42", Long.TYPE)));
        Assert.assertEquals((long)42L, (long)((Short)StringUtil.parse((String)"42", Short.TYPE)).shortValue());
        Assert.assertEquals((Object)true, (Object)StringUtil.parse((String)"true", Boolean.TYPE));
        Assert.assertEquals((Object)true, (Object)StringUtil.parse((String)"TRUE", Boolean.TYPE));
        Assert.assertEquals((Object)false, (Object)StringUtil.parse((String)"false", Boolean.TYPE));
        Assert.assertEquals((Object)false, (Object)StringUtil.parse((String)"FALSE", Boolean.TYPE));
        Assert.assertEquals((Object)false, (Object)StringUtil.parse((String)"bla", Boolean.TYPE));
        Assert.assertEquals((long)67L, (long)((Character)StringUtil.parse((String)"C", Character.class)).charValue());
        Assert.assertEquals((double)35.2345, (double)((Double)StringUtil.parse((String)"35.2345", Double.class)), (double)1.0E-6);
        Assert.assertEquals((double)35.2345, (double)((Float)StringUtil.parse((String)"35.2345", Float.class)).floatValue(), (double)1.0E-6);
        Assert.assertEquals((long)42L, (long)((Integer)StringUtil.parse((String)"42", Integer.class)).intValue());
        Assert.assertEquals((long)42L, (long)((Long)StringUtil.parse((String)"42", Long.class)));
        Assert.assertEquals((long)42L, (long)((Short)StringUtil.parse((String)"42", Short.class)).shortValue());
        Assert.assertEquals((Object)true, (Object)StringUtil.parse((String)"true", Boolean.class));
        Assert.assertEquals((Object)true, (Object)StringUtil.parse((String)"TRUE", Boolean.class));
        Assert.assertEquals((Object)false, (Object)StringUtil.parse((String)"false", Boolean.class));
        Assert.assertEquals((Object)false, (Object)StringUtil.parse((String)"FALSE", Boolean.class));
        Assert.assertEquals((Object)false, (Object)StringUtil.parse((String)"bla", Boolean.class));
        try {
            StringUtil.parse(null, StringUtilTest.class);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testStringJoin() {
        Assert.assertEquals((Object)"AAA,BBB,CCC", (Object)StringUtil.join((Object[])new String[]{"AAA", "BBB", "CCC"}, (String)","));
        Assert.assertEquals((Object)"AAA", (Object)StringUtil.join((Object[])new String[]{"AAA"}, (String)","));
        Assert.assertEquals((Object)"AAAnullBBBnullCCC", (Object)StringUtil.join((Object[])new String[]{"AAA", "BBB", "CCC"}, null));
        Assert.assertEquals((Object)"", (Object)StringUtil.join((Object[])new String[0], (String)","));
        Assert.assertNull((Object)StringUtil.join(null, null));
        Assert.assertNull((Object)StringUtil.join(null, (String)","));
    }

    @Test
    @Ignore(value="only needed for manual performance tests")
    public void stringSplitPerformanceTest() {
        String val = "  asdfsfsfsfafasdf  basdfasf cs d efdfdfdfdfdfdfdf ghai asdf asdflkj  l\u00f6kajdf lk\u00f6lkasdflk jkl\u00f6 adfk \n adslsfl \t adsfsfd";
        long start = System.nanoTime();
        for (int i = 1; i < 10000000; ++i) {
            StringUtil.split((String)val, (String)"sd", (int)0);
        }
        long stop = System.nanoTime();
        System.out.println("took: " + TimeUnit.NANOSECONDS.toMillis(stop - start));
    }

    @Test
    @Ignore(value="only needed for manual performance tests")
    public void testStringsReplacePerformance() {
        String val = "This is my fnx test suite for fnx replacement to fnx=fnx";
        long start = System.nanoTime();
        for (int i = 1; i < 10000000; ++i) {
            StringUtil.replace((String)val, (String)"fnx", (String)"weirdo function");
        }
        long stop = System.nanoTime();
        System.out.println("took: " + TimeUnit.NANOSECONDS.toMillis(stop - start));
    }

    @Test
    @Ignore(value="only needed for manual performance tests")
    public void testStringJoinPerformance() {
        Object[] vals = new String[]{"A", "BDS", "DSD", "XYZ", "HOHOHO", "AND", "SOMETHING", "ELSE"};
        long start = System.nanoTime();
        for (int i = 1; i < 10000000; ++i) {
            StringUtil.join((Object[])vals, (String)"-.-");
        }
        long stop = System.nanoTime();
        System.out.println("took: " + TimeUnit.NANOSECONDS.toMillis(stop - start));
    }
}

