/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.util.concurrent.TimeUnit;
import org.apache.openjpa.lib.util.ClassUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ClassUtilTest {
    private static final MyInnerClass INSTANCE = new MyInnerClass(){};

    @Test
    public void testToClass() {
        Assert.assertEquals(this.getClass(), (Object)this.toClass("org.apache.openjpa.lib.util.ClassUtilTest"));
        Assert.assertEquals(new ClassUtilTest[0].getClass(), (Object)this.toClass("org.apache.openjpa.lib.util.ClassUtilTest[]"));
        Assert.assertEquals(Integer.class, (Object)this.toClass("java.lang.Integer"));
        Assert.assertEquals(Byte.TYPE, (Object)this.toClass("byte"));
        Assert.assertEquals(Character.TYPE, (Object)this.toClass("char"));
        Assert.assertEquals(Double.TYPE, (Object)this.toClass("double"));
        Assert.assertEquals(Float.TYPE, (Object)this.toClass("float"));
        Assert.assertEquals(Integer.TYPE, (Object)this.toClass("int"));
        Assert.assertEquals(Long.TYPE, (Object)this.toClass("long"));
        Assert.assertEquals(Short.TYPE, (Object)this.toClass("short"));
        Assert.assertEquals(Boolean.TYPE, (Object)this.toClass("boolean"));
        Assert.assertEquals(Void.TYPE, (Object)this.toClass("void"));
        Assert.assertEquals(new float[0].getClass(), (Object)this.toClass("float[]"));
        Assert.assertEquals(new float[0][0].getClass(), (Object)this.toClass("float[][]"));
        Assert.assertEquals(new long[0][0][0].getClass(), (Object)this.toClass("long[][][]"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonExistingClass() {
        this.toClass("does.not.Exist");
    }

    private Class toClass(String clazz) {
        return ClassUtil.toClass((String)clazz, (boolean)false, (ClassLoader)this.getClass().getClassLoader());
    }

    @Test
    public void testGetClassName() {
        Assert.assertEquals((Object)"ClassUtilTest", (Object)ClassUtil.getClassName(ClassUtilTest.class));
        Assert.assertEquals((Object)"ClassUtilTest$MyInnerClass", (Object)ClassUtil.getClassName(MyInnerClass.class));
        Assert.assertEquals((Object)"ClassUtilTest$1", (Object)ClassUtil.getClassName(INSTANCE.getClass()));
        Assert.assertEquals((Object)"byte", (Object)ClassUtil.getClassName(Byte.TYPE));
        Assert.assertEquals((Object)"char", (Object)ClassUtil.getClassName(Character.TYPE));
        Assert.assertEquals((Object)"double", (Object)ClassUtil.getClassName(Double.TYPE));
        Assert.assertEquals((Object)"float", (Object)ClassUtil.getClassName(Float.TYPE));
        Assert.assertEquals((Object)"int", (Object)ClassUtil.getClassName(Integer.TYPE));
        Assert.assertEquals((Object)"long", (Object)ClassUtil.getClassName(Long.TYPE));
        Assert.assertEquals((Object)"short", (Object)ClassUtil.getClassName(Short.TYPE));
        Assert.assertEquals((Object)"boolean", (Object)ClassUtil.getClassName(Boolean.TYPE));
        Assert.assertEquals((Object)"void", (Object)ClassUtil.getClassName(Void.TYPE));
        Assert.assertEquals((Object)"long[]", (Object)ClassUtil.getClassName(long[].class));
        Assert.assertEquals((Object)"long[][]", (Object)ClassUtil.getClassName(long[][].class));
        Assert.assertEquals((Object)"float[][][]", (Object)ClassUtil.getClassName(float[][][].class));
        Assert.assertEquals((Object)"ClassUtilTest[]", (Object)ClassUtil.getClassName(ClassUtilTest[].class));
        Assert.assertEquals((Object)"ClassUtilTest$MyInnerClass[]", (Object)ClassUtil.getClassName(MyInnerClass[].class));
        Assert.assertEquals((Object)"ClassUtilTest$MyInnerClass[][]", (Object)ClassUtil.getClassName(MyInnerClass[][].class));
    }

    @Test
    @Ignore(value="only needed for manual performance tests")
    public void testGetClassNamePerformance() {
        long start = System.nanoTime();
        for (int i = 1; i < 10000000; ++i) {
            ClassUtil.getClassName(MyInnerClass.class);
        }
        long stop = System.nanoTime();
        System.out.println("took: " + TimeUnit.NANOSECONDS.toMillis(stop - start));
    }

    @Test
    public void testGetPackageName() {
        Assert.assertEquals((Object)"org.apache.openjpa.lib.util", (Object)ClassUtil.getPackageName(ClassUtilTest.class));
        Assert.assertEquals((Object)"org.apache.openjpa.lib.util", (Object)ClassUtil.getPackageName(MyInnerClass.class));
        Assert.assertEquals((Object)"org.apache.openjpa.lib.util", (Object)ClassUtil.getPackageName(MyInnerClass[].class));
        Assert.assertEquals((Object)"org.apache.openjpa.lib.util", (Object)ClassUtil.getPackageName(INSTANCE.getClass()));
        Assert.assertEquals((Object)"", (Object)ClassUtil.getPackageName(Long.TYPE));
        Assert.assertEquals((Object)"", (Object)ClassUtil.getPackageName(long[].class));
    }

    private static abstract class MyInnerClass {
        private MyInnerClass() {
        }
    }
}

