/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.rop;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.openjpa.lib.rop.ListResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.test.AbstractTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ResultListTest
extends AbstractTestCase {
    private ResultList[] _lists = null;
    protected boolean subListSupported = false;

    public ResultListTest() {
        this(false);
    }

    public ResultListTest(boolean supportSubList) {
        this.subListSupported = supportSubList;
    }

    protected abstract ResultList getResultList(ResultObjectProvider var1);

    protected ResultObjectProvider[] getResultObjectProviders(List list) {
        return new ResultObjectProvider[]{new ListResultObjectProvider(list)};
    }

    @Before
    public void setUp() {
        ArrayList<String> results = new ArrayList<String>(100);
        for (int i = 0; i < 100; ++i) {
            results.add(String.valueOf(i));
        }
        ResultObjectProvider[] rops = this.getResultObjectProviders(results);
        this._lists = new ResultList[rops.length];
        for (int i = 0; i < this._lists.length; ++i) {
            this._lists[i] = this.getResultList(rops[i]);
        }
    }

    @Test
    public void testIterator() {
        for (ResultList list : this._lists) {
            Iterator itr = list.iterator();
            int count = 0;
            while (itr.hasNext()) {
                Assert.assertEquals((Object)String.valueOf(count), itr.next());
                ++count;
            }
            Assert.assertEquals((long)100L, (long)count);
            try {
                itr.next();
                Assert.fail((String)"After last.");
            }
            catch (IndexOutOfBoundsException | NoSuchElementException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testIteratorModification() {
        for (ResultList list : this._lists) {
            try {
                Iterator itr = list.iterator();
                itr.next();
                itr.remove();
                Assert.fail((String)"Allowed modification.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testListIteratorForward() {
        for (ResultList list : this._lists) {
            ListIterator itr = list.listIterator();
            int count = 0;
            while (itr.hasNext()) {
                Assert.assertEquals((long)count, (long)itr.nextIndex());
                Assert.assertEquals((Object)String.valueOf(count), itr.next());
                ++count;
            }
            Assert.assertEquals((long)100L, (long)count);
            try {
                itr.next();
                Assert.fail((String)"After last.");
            }
            catch (IndexOutOfBoundsException | NoSuchElementException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testListIteratorIndex() {
        for (ResultList list : this._lists) {
            ListIterator itr = list.listIterator(50);
            int count = 50;
            while (itr.hasNext()) {
                Assert.assertEquals((long)count, (long)itr.nextIndex());
                Assert.assertEquals((Object)String.valueOf(count), itr.next());
                ++count;
            }
            Assert.assertEquals((long)100L, (long)count);
            try {
                itr.next();
                Assert.fail((String)"After last.");
            }
            catch (IndexOutOfBoundsException | NoSuchElementException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testListIteratorReverse() {
        for (ResultList list : this._lists) {
            ListIterator itr = list.listIterator(100);
            int count = 99;
            while (itr.hasPrevious()) {
                Assert.assertEquals((long)count, (long)itr.previousIndex());
                Assert.assertEquals((Object)String.valueOf(count), itr.previous());
                --count;
            }
            Assert.assertEquals((long)-1L, (long)count);
            try {
                itr.previous();
                Assert.fail((String)"Before first.");
            }
            catch (IndexOutOfBoundsException | NoSuchElementException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testListIteratorModification() {
        for (ResultList list : this._lists) {
            try {
                ListIterator itr = list.listIterator();
                itr.next();
                itr.set("foo");
                Assert.fail((String)"Allowed modification.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testMultipleIterations() {
        this.testListIteratorIndex();
        this.testListIteratorForward();
        this.testListIteratorReverse();
    }

    @Test
    public void testContains() {
        for (ResultList list : this._lists) {
            Assert.assertTrue((boolean)list.contains((Object)"0"));
            Assert.assertTrue((boolean)list.contains((Object)"50"));
            Assert.assertTrue((boolean)list.contains((Object)"99"));
            Assert.assertFalse((boolean)list.contains((Object)"-1"));
            Assert.assertFalse((boolean)list.contains((Object)"100"));
            Assert.assertFalse((boolean)list.contains(null));
            Assert.assertTrue((boolean)list.containsAll(Arrays.asList("0", "50", "99")));
            Assert.assertFalse((boolean)list.containsAll(Arrays.asList("0", "-1", "99")));
        }
    }

    @Test
    public void testModification() {
        for (ResultList list : this._lists) {
            try {
                list.add((Object)"foo");
                Assert.fail((String)"Allowed modification.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                list.remove((Object)"1");
                Assert.fail((String)"Allowed modification.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            try {
                list.set(0, (Object)"foo");
                Assert.fail((String)"Allowed modification.");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGetBegin() {
        for (ResultList list : this._lists) {
            for (int j = 0; j < 10; ++j) {
                Assert.assertEquals((Object)String.valueOf(j), (Object)list.get(j));
            }
            try {
                list.get(-1);
                Assert.fail((String)"Before begin.");
            }
            catch (IndexOutOfBoundsException | NoSuchElementException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGetMiddle() {
        for (ResultList list : this._lists) {
            for (int j = 50; j < 60; ++j) {
                Assert.assertEquals((Object)String.valueOf(j), (Object)list.get(j));
            }
        }
    }

    @Test
    public void testGetEnd() {
        for (ResultList list : this._lists) {
            for (int j = 90; j < 100; ++j) {
                Assert.assertEquals((Object)String.valueOf(j), (Object)list.get(j));
            }
            try {
                list.get(100);
                Assert.fail((String)"Past end.");
            }
            catch (IndexOutOfBoundsException | NoSuchElementException runtimeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGetReverse() {
        for (ResultList list : this._lists) {
            for (int j = 99; j > -1; --j) {
                Assert.assertEquals((Object)String.valueOf(j), (Object)list.get(j));
            }
        }
    }

    @Test
    public void testMultipleGet() {
        this.testGetMiddle();
        this.testGetBegin();
        this.testGetEnd();
        for (ResultList list : this._lists) {
            list.size();
        }
        this.testListIteratorForward();
        this.testGetMiddle();
        this.testGetBegin();
        this.testGetEnd();
    }

    @Test
    public void testSize() {
        for (ResultList list : this._lists) {
            Assert.assertTrue((list.size() == 100 || list.size() == Integer.MAX_VALUE ? 1 : 0) != 0);
        }
    }

    @Test
    public void testEmpty() {
        ResultObjectProvider[] rops;
        for (ResultObjectProvider rop : rops = this.getResultObjectProviders(Collections.EMPTY_LIST)) {
            ResultList list = this.getResultList(rop);
            Assert.assertEquals((long)0L, (long)list.size());
            Assert.assertTrue((boolean)list.isEmpty());
        }
    }

    @Test
    public void testSubList() {
        ResultObjectProvider[] rops;
        for (ResultObjectProvider rop : rops = this.getResultObjectProviders(Collections.EMPTY_LIST)) {
            ResultList list = this.getResultList(rop);
            try {
                List subList = list.subList(0, 0);
                if (this.subListSupported) continue;
                Assert.fail((String)"Should not support subList.");
            }
            catch (UnsupportedOperationException e) {
                if (!this.subListSupported) continue;
                Assert.fail((String)"Should support subList.");
            }
        }
    }
}

