/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.graph;

import java.util.Collection;
import java.util.Iterator;
import org.apache.openjpa.lib.graph.Edge;
import org.apache.openjpa.lib.graph.Graph;
import org.apache.openjpa.lib.test.AbstractTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestGraph
extends AbstractTestCase {
    private Graph _graph = new Graph();
    private Object _node1 = new Object();
    private Object _node2 = new Object();
    private Object _node3 = new Object();
    private Edge _edge1 = new Edge(this._node1, this._node2, true);
    private Edge _edge2 = new Edge(this._node2, this._node3, true);
    private Edge _edge3 = new Edge(this._node1, this._node3, false);
    private Edge _edge4 = new Edge(this._node2, this._node2, false);

    @Before
    public void setUp() {
        this._graph.addNode(this._node1);
        this._graph.addNode(this._node2);
        this._graph.addNode(this._node3);
        this._graph.addEdge(this._edge1);
        this._graph.addEdge(this._edge2);
        this._graph.addEdge(this._edge3);
        this._graph.addEdge(this._edge4);
    }

    @Test
    public void testAddRetrieve() {
        Assert.assertEquals((long)3L, (long)this._graph.getNodes().size());
        Assert.assertEquals((long)4L, (long)this._graph.getEdges().size());
        Collection edges = this._graph.getEdgesFrom(this._node1);
        Assert.assertEquals((long)2L, (long)edges.size());
        Iterator itr = edges.iterator();
        Edge edge0 = (Edge)itr.next();
        Edge edge1 = (Edge)itr.next();
        Assert.assertTrue((edge0 == this._edge1 && edge1 == this._edge3 || edge0 == this._edge3 && edge1 == this._edge1 ? 1 : 0) != 0);
        edges = this._graph.getEdgesTo(this._node1);
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertEquals((Object)this._edge3, edges.iterator().next());
        edges = this._graph.getEdges(this._node1, this._node3);
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertEquals((Object)this._edge3, edges.iterator().next());
        edges = this._graph.getEdges(this._node3, this._node1);
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertEquals((Object)this._edge3, edges.iterator().next());
        edges = this._graph.getEdgesFrom(this._node2);
        Assert.assertEquals((long)2L, (long)edges.size());
        itr = edges.iterator();
        edge0 = (Edge)itr.next();
        edge1 = (Edge)itr.next();
        Assert.assertTrue((edge0 == this._edge2 && edge1 == this._edge4 || edge0 == this._edge4 && edge1 == this._edge2 ? 1 : 0) != 0);
        edges = this._graph.getEdgesTo(this._node2);
        Assert.assertEquals((long)2L, (long)edges.size());
        itr = edges.iterator();
        edge0 = (Edge)itr.next();
        edge1 = (Edge)itr.next();
        Assert.assertTrue((edge0 == this._edge1 && edge1 == this._edge4 || edge0 == this._edge4 && edge1 == this._edge1 ? 1 : 0) != 0);
        edges = this._graph.getEdges(this._node2, this._node2);
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertEquals((Object)this._edge4, edges.iterator().next());
        edges = this._graph.getEdgesFrom(this._node3);
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertEquals((Object)this._edge3, edges.iterator().next());
    }

    @Test
    public void testRemoveEdges() {
        Assert.assertTrue((boolean)this._graph.removeEdge(this._edge2));
        Collection edges = this._graph.getEdgesFrom(this._node2);
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertEquals((Object)this._edge4, edges.iterator().next());
        Assert.assertTrue((boolean)this._graph.removeEdge(this._edge3));
        edges = this._graph.getEdgesFrom(this._node1);
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertEquals((Object)this._edge1, edges.iterator().next());
        edges = this._graph.getEdgesTo(this._node1);
        Assert.assertEquals((long)0L, (long)edges.size());
        edges = this._graph.getEdgesTo(this._node3);
        Assert.assertEquals((long)0L, (long)edges.size());
        edges = this._graph.getEdgesFrom(this._node3);
        Assert.assertEquals((long)0L, (long)edges.size());
    }

    @Test
    public void testRemoveNodes() {
        Assert.assertTrue((boolean)this._graph.removeNode(this._node3));
        Collection edges = this._graph.getEdges();
        Assert.assertEquals((long)2L, (long)edges.size());
        Iterator itr = edges.iterator();
        Edge edge0 = (Edge)itr.next();
        Edge edge1 = (Edge)itr.next();
        Assert.assertTrue((edge0 == this._edge1 && edge1 == this._edge4 || edge0 == this._edge4 && edge1 == this._edge1 ? 1 : 0) != 0);
        edges = this._graph.getEdgesFrom(this._node1);
        Assert.assertEquals((long)1L, (long)edges.size());
        Assert.assertEquals((Object)this._edge1, edges.iterator().next());
        edges = this._graph.getEdgesTo(this._node1);
        Assert.assertEquals((long)0L, (long)edges.size());
    }
}

