/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openjpa.lib.graph.DepthFirstAnalysis;
import org.apache.openjpa.lib.graph.Edge;
import org.apache.openjpa.lib.graph.Graph;
import org.apache.openjpa.lib.test.AbstractTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDepthFirstAnalysis
extends AbstractTestCase {
    private DepthFirstAnalysis _dfa = null;

    @Before
    public void setUp() {
        this.setUpGraph1();
    }

    public void setUpGraph1() {
        Graph graph = new Graph();
        Object node1 = new Object();
        Object node2 = new Object();
        Object node3 = new Object();
        Object node4 = new Object();
        graph.addNode(node1);
        graph.addNode(node2);
        graph.addNode(node3);
        graph.addNode(node4);
        graph.addEdge(new Edge(node1, node2, true));
        graph.addEdge(new Edge(node2, node3, true));
        graph.addEdge(new Edge(node3, node1, true));
        graph.addEdge(new Edge(node3, node4, true));
        graph.addEdge(new Edge(node2, node2, true));
        this._dfa = new DepthFirstAnalysis(graph);
    }

    public void setUpGraph2() {
        Graph graph = new Graph();
        Integer node1 = 1;
        Integer node2 = 2;
        Integer node3 = 3;
        Integer node4 = 4;
        Integer node5 = 5;
        graph.addNode((Object)node2);
        graph.addNode((Object)node5);
        graph.addNode((Object)node4);
        graph.addNode((Object)node3);
        graph.addNode((Object)node1);
        graph.addEdge(new Edge((Object)node5, (Object)node4, true));
        graph.addEdge(new Edge((Object)node4, (Object)node3, true));
        graph.addEdge(new Edge((Object)node3, (Object)node3, true));
        graph.addEdge(new Edge((Object)node3, (Object)node2, true));
        graph.addEdge(new Edge((Object)node2, (Object)node5, true));
        graph.addEdge(new Edge((Object)node2, (Object)node4, true));
        graph.addEdge(new Edge((Object)node1, (Object)node4, true));
        this._dfa = new DepthFirstAnalysis(graph);
    }

    @Test
    public void testNodeSorting() {
        List nodes = this._dfa.getSortedNodes();
        Assert.assertEquals((long)4L, (long)nodes.size());
        int time = 0;
        for (Object o : nodes) {
            Object node = o;
            Assert.assertTrue((time <= this._dfa.getFinishedTime(node) ? 1 : 0) != 0);
            time = this._dfa.getFinishedTime(node);
        }
    }

    @Test
    public void testEdgeTyping() {
        Collection edges = this._dfa.getEdges(2);
        Assert.assertEquals((long)2L, (long)edges.size());
        Iterator itr = edges.iterator();
        Edge edge0 = (Edge)itr.next();
        Edge edge1 = (Edge)itr.next();
        Assert.assertTrue((edge0.getTo().equals(edge0.getFrom()) || edge1.getTo().equals(edge1.getFrom()) ? 1 : 0) != 0);
    }

    @Test
    public void testBackEdges() {
        this.setUpGraph2();
        Collection edges = this._dfa.getEdges(2);
        Assert.assertEquals((long)2L, (long)edges.size());
        Iterator itr = edges.iterator();
        Edge edge0 = (Edge)itr.next();
        Edge edge1 = (Edge)itr.next();
        if (edge0.getTo().equals(edge0.getFrom())) {
            Assert.assertTrue((edge0.getCycle() != null && edge0.getCycle().size() == 1 ? 1 : 0) != 0);
            List cycle = edge1.getCycle();
            Assert.assertTrue((cycle != null && cycle.size() == 4 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Edge)cycle.get(0)).getFrom().equals(((Edge)cycle.get(3)).getTo()));
        } else if (edge1.getTo().equals(edge1.getFrom())) {
            Assert.assertTrue((edge1.getCycle() != null && edge1.getCycle().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((edge1 == edge1.getCycle() ? 1 : 0) != 0);
            List cycle = edge0.getCycle();
            Assert.assertTrue((cycle != null && cycle.size() == 4 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Edge)cycle.get(0)).getFrom().equals(((Edge)cycle.get(3)).getTo()));
        } else {
            Assert.assertFalse((boolean)true);
        }
    }

    @Test
    public void testForwardEdges() {
        this.setUpGraph2();
        Collection edges = this._dfa.getEdges(3);
        Assert.assertEquals((long)2L, (long)edges.size());
        Iterator itr = edges.iterator();
        Edge edge0 = (Edge)itr.next();
        Edge edge1 = (Edge)itr.next();
        if (edge0.getCycle() == null) {
            List cycle = edge1.getCycle();
            Assert.assertTrue((cycle != null && cycle.size() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Edge)cycle.get(0)).getFrom().equals(((Edge)cycle.get(2)).getTo()));
        } else if (edge1.getCycle() == null) {
            List cycle = edge0.getCycle();
            Assert.assertTrue((cycle != null && cycle.size() == 3 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Edge)cycle.get(0)).getFrom().equals(((Edge)cycle.get(2)).getTo()));
        } else {
            Assert.assertFalse((boolean)true);
        }
    }
}

