/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf.test;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationImpl;
import org.apache.openjpa.lib.conf.ObjectValue;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.conf.StringValue;
import org.apache.openjpa.lib.conf.test.ConfigurationTestProductDerivation;
import org.apache.openjpa.lib.test.AbstractTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationImpl
extends AbstractTestCase {
    private ConfigurationTest _conf = new ConfigurationTest();

    @Before
    public void setUp() {
        System.setProperty("openjpatest.properties", "test.properties");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        System.setProperty("openjpatest.properties", "");
    }

    @Test
    public void testGlobals() {
        System.setProperty("openjpa.sysKey", "sysvalue");
        Assert.assertNull((Object)this._conf.getTestKey());
        Assert.assertNull((Object)this._conf.getSysKey());
        Assert.assertNull((Object)this._conf.getPluginKey());
        Assert.assertNull((Object)this._conf.getObjectKey());
        Assert.assertTrue((boolean)this._conf.loadGlobals());
        Assert.assertEquals((Object)"testvalue", (Object)this._conf.getTestKey());
        Assert.assertEquals((Object)"sysvalue", (Object)this._conf.getSysKey());
        Assert.assertNull((Object)this._conf.getPluginKey());
        Assert.assertNull((Object)this._conf.getObjectKey());
        this._conf.setTestKey(null);
        this._conf.setSysKey(null);
        System.setProperty("openjpatest.properties", "foo.properties");
        try {
            Assert.assertTrue((!this._conf.loadGlobals() ? 1 : 0) != 0);
            Assert.fail((String)"Should have thrown exception for missing resource.");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        System.setProperty("openjpatest.properties", "test.properties");
        System.setProperty("openjpa.pluginKey", "java.lang.Object");
        Assert.assertTrue((boolean)this._conf.loadGlobals());
        Assert.assertEquals((Object)"testvalue", (Object)this._conf.getTestKey());
        Assert.assertEquals((Object)"sysvalue", (Object)this._conf.getSysKey());
        Assert.assertEquals((Object)"java.lang.Object", (Object)this._conf.getPluginKey());
        Assert.assertNotNull((Object)this._conf.getPluginKeyInstance());
        Assert.assertNull((Object)this._conf.getObjectKey());
    }

    @Test
    public void testToProperties() {
        Assert.assertTrue((boolean)this._conf.loadGlobals());
        Assert.assertEquals((Object)"testvalue", (Object)this._conf.getTestKey());
        Map props = this._conf.toProperties(false);
        Assert.assertEquals((Object)"testvalue", props.get("openjpa.testKey"));
        Assert.assertFalse((boolean)props.containsKey("openjpa.objectKey"));
        this._conf.setTestKey("foo");
        this._conf.setPluginKey(new Object());
        this._conf.setObjectKey(new Object());
        props = this._conf.toProperties(false);
        Assert.assertEquals((Object)"foo", props.get("openjpa.testKey"));
        Assert.assertEquals((Object)"java.lang.Object", props.get("openjpa.pluginKey"));
        Assert.assertFalse((boolean)props.containsKey("openjpa.objectKey"));
    }

    @Test
    public void testPropertiesCaching() {
        this._conf.setTestKey("val");
        this._conf.setPluginKey("java.lang.Object");
        Map props1 = this._conf.toProperties(false);
        Map props2 = this._conf.toProperties(false);
        this._conf.setObjectKey(new Object());
        Assert.assertNotNull((Object)this._conf.getPluginKeyInstance());
        Map props3 = this._conf.toProperties(false);
        this._conf.setTestKey("changed");
        Map props4 = this._conf.toProperties(false);
        this._conf.setPluginKey(1);
        Map props5 = this._conf.toProperties(false);
        Assert.assertEquals((Object)props1, (Object)props2);
        Assert.assertEquals((Object)props1, (Object)props3);
        this.assertNotEquals(props1, props4);
        this.assertNotEquals(props4, props5);
    }

    @Test
    public void testEquals() {
        ConfigurationTest conf = new ConfigurationTest();
        conf.setTestKey(this._conf.getTestKey());
        conf.setSysKey(this._conf.getSysKey());
        conf.setPluginKey(this._conf.getPluginKey());
        conf.setObjectKey(this._conf.getObjectKey());
        Assert.assertEquals((Object)((Object)this._conf), (Object)((Object)conf));
        conf.setTestKey("newval");
        Assert.assertTrue((!this._conf.equals((Object)conf) ? 1 : 0) != 0);
        conf.setTestKey(this._conf.getTestKey());
        Assert.assertEquals((Object)((Object)this._conf), (Object)((Object)conf));
        conf.setObjectKey(new Object());
        Assert.assertEquals((Object)((Object)this._conf), (Object)((Object)conf));
        conf.setPluginKey(new StringBuffer());
        Assert.assertTrue((!this._conf.equals((Object)conf) ? 1 : 0) != 0);
    }

    @Test
    public void testBeanAccessors() throws Exception {
        PropertyDescriptor[] pds;
        for (PropertyDescriptor pd : pds = this._conf.getPropertyDescriptors()) {
            Assert.assertNotNull((Object)pd.getShortDescription());
            Assert.assertNotNull((Object)pd.getDisplayName());
            Assert.assertNotNull((Object)pd.getWriteMethod());
            Assert.assertNotNull((Object)pd.getReadMethod());
            pd.getReadMethod().invoke((Object)this._conf, (Object[])null);
            Method setter = pd.getWriteMethod();
            Method getter = pd.getReadMethod();
            Class<?> param = pd.getReadMethod().getReturnType();
            Object setVal = null;
            if (param == Integer.TYPE) {
                setVal = TestConfigurationImpl.randomInt();
            } else if (param == Long.TYPE) {
                setVal = TestConfigurationImpl.randomLong();
            } else if (param == String.class) {
                setVal = TestConfigurationImpl.randomString();
            } else {
                if (param != Boolean.TYPE) continue;
                setVal = (Boolean)getter.invoke((Object)this._conf, (Object[])null) == false;
            }
            setter.invoke((Object)this._conf, setVal);
            Assert.assertEquals((Object)setVal, (Object)getter.invoke((Object)this._conf, (Object[])null));
        }
    }

    @Test
    public void testFreezing() {
        Assert.assertTrue((!this._conf.isReadOnly() ? 1 : 0) != 0);
        this._conf.setReadOnly(2);
        Assert.assertTrue((boolean)this._conf.isReadOnly());
        try {
            this._conf.setTestKey("bar");
            Assert.fail((String)"Allowed set on read only configuration.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            Properties p = new Properties();
            p.put("x", "y");
            this._conf.fromProperties(p);
            Assert.fail((String)"Allowed fromMap on read only configuration.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSerialization() throws Exception {
        Assert.assertTrue((boolean)this._conf.loadGlobals());
        this._conf.setTestKey("testvalue");
        this._conf.setSysKey("sysvalue");
        this._conf.setObjectKey(new Object());
        this._conf.setPluginKey(new Object());
        ConfigurationTest copy = (ConfigurationTest)((Object)TestConfigurationImpl.roundtrip((Object)this._conf, true));
        Assert.assertEquals((Object)"testvalue", (Object)copy.getTestKey());
        Assert.assertEquals((Object)"sysvalue", (Object)copy.getSysKey());
        Assert.assertNull((Object)copy.getObjectKey());
        Assert.assertEquals((Object)"java.lang.Object", (Object)copy.getPluginKey());
        Assert.assertNotNull((Object)copy.getPluginKeyInstance());
        copy.setTestKey("testvalue2");
        copy.setSysKey("sysvalue2");
        copy.setPluginKey(new StringBuffer());
        ConfigurationTest copy2 = (ConfigurationTest)((Object)TestConfigurationImpl.roundtrip((Object)copy, true));
        Assert.assertEquals((Object)"testvalue2", (Object)copy2.getTestKey());
        Assert.assertEquals((Object)"sysvalue2", (Object)copy2.getSysKey());
        Assert.assertNull((Object)copy2.getObjectKey());
        Assert.assertEquals((Object)"java.lang.StringBuffer", (Object)copy2.getPluginKey());
        Assert.assertEquals((Object)"", (Object)copy2.getPluginKeyInstance().toString());
    }

    @Test
    public void testProductDerivationCloseCallback() {
        ConfigurationTestProductDerivation.closed = false;
        this._conf.close();
        Assert.assertTrue((boolean)ConfigurationTestProductDerivation.closed);
    }

    private static class ConfigurationTest
    extends ConfigurationImpl {
        private final StringValue _testKey = this.addString("testKey");
        private final StringValue _sysKey = this.addString("sysKey");
        private final PluginValue _pluginKey;
        private final ObjectValue _objectKey;

        public ConfigurationTest() {
            this(true);
        }

        public ConfigurationTest(boolean canSetPlugin) {
            super(false);
            this._pluginKey = this.addPlugin("pluginKey", canSetPlugin);
            this._objectKey = this.addObject("objectKey");
        }

        public String getTestKey() {
            return this._testKey.get();
        }

        public void setTestKey(String val) {
            this._testKey.set(val);
        }

        public String getSysKey() {
            return this._sysKey.get();
        }

        public void setSysKey(String val) {
            this._sysKey.set(val);
        }

        public String getPluginKey() {
            return this._pluginKey.getString();
        }

        public void setPluginKey(String val) {
            this._pluginKey.setString(val);
        }

        public Object getPluginKeyInstance() {
            if (this._pluginKey.get() == null) {
                return this._pluginKey.instantiate(Object.class, (Configuration)this);
            }
            return this._pluginKey.get();
        }

        public void setPluginKey(Object val) {
            this._pluginKey.set(val);
        }

        public Object getObjectKey() {
            return this._objectKey.get();
        }

        public void setObjectKey(Object val) {
            this._objectKey.set(val);
        }

        public void deriveObjectKey(Object val) {
            this._objectKey.set(val, true);
        }

        protected boolean isInvalidProperty(String s) {
            if ("openjpatest.properties".equals(s)) {
                return false;
            }
            return super.isInvalidProperty(s);
        }
    }
}

