/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.test.AbstractTestCase;
import org.apache.openjpa.lib.util.Options;
import org.junit.Assert;
import org.junit.Test;

public class TestConfigurations
extends AbstractTestCase {
    @Test
    public void testParsePlugin() {
        String str = null;
        Assert.assertNull((Object)Configurations.getClassName(str));
        Assert.assertNull((Object)Configurations.getProperties(str));
        str = "foo";
        Assert.assertEquals((Object)"foo", (Object)Configurations.getClassName((String)str));
        Assert.assertNull((Object)Configurations.getProperties((String)str));
        str = "a=b";
        Assert.assertNull((Object)Configurations.getClassName((String)str));
        Assert.assertEquals((Object)"a=b", (Object)Configurations.getProperties((String)str));
        str = "a=b, c=d";
        Assert.assertNull((Object)Configurations.getClassName((String)str));
        Assert.assertEquals((Object)"a=b, c=d", (Object)Configurations.getProperties((String)str));
        str = "foo(a=b, c=d)";
        Assert.assertEquals((Object)"foo", (Object)Configurations.getClassName((String)str));
        Assert.assertEquals((Object)"a=b, c=d", (Object)Configurations.getProperties((String)str));
        str = " foo( a=\"b,c d\", c=\"d\" ) ";
        Assert.assertEquals((Object)"foo", (Object)Configurations.getClassName((String)str));
        Assert.assertEquals((Object)"a=\"b,c d\", c=\"d\"", (Object)Configurations.getProperties((String)str));
        str = " foo( a='b,c d', c='d' ) ";
        Assert.assertEquals((Object)"foo", (Object)Configurations.getClassName((String)str));
        Assert.assertEquals((Object)"a='b,c d', c='d'", (Object)Configurations.getProperties((String)str));
    }

    @Test
    public void testParseProperties() {
        Options opts = Configurations.parseProperties(null);
        Assert.assertEquals((long)0L, (long)opts.size());
        opts = Configurations.parseProperties((String)" foo=bar, biz=baz ");
        Assert.assertEquals((long)2L, (long)opts.size());
        Assert.assertEquals((Object)"bar", (Object)opts.getProperty("foo"));
        Assert.assertEquals((Object)"baz", (Object)opts.getProperty("biz"));
        opts = Configurations.parseProperties((String)"foo=bar,biz=\"baz,=,baz\",x=y");
        Assert.assertEquals((long)3L, (long)opts.size());
        Assert.assertEquals((Object)"bar", (Object)opts.getProperty("foo"));
        Assert.assertEquals((Object)"baz,=,baz", (Object)opts.getProperty("biz"));
        Assert.assertEquals((Object)"y", (Object)opts.getProperty("x"));
        opts = Configurations.parseProperties((String)"foo=\"bar bar,10\",biz=\"baz baz\"");
        Assert.assertEquals((long)2L, (long)opts.size());
        Assert.assertEquals((Object)"bar bar,10", (Object)opts.getProperty("foo"));
        Assert.assertEquals((Object)"baz baz", (Object)opts.getProperty("biz"));
        opts = Configurations.parseProperties((String)"foo='bar bar,10',biz='baz baz'");
        Assert.assertEquals((long)2L, (long)opts.size());
        Assert.assertEquals((Object)"bar bar,10", (Object)opts.getProperty("foo"));
        Assert.assertEquals((Object)"baz baz", (Object)opts.getProperty("biz"));
    }

    @Test
    public void testCombinePlugins() {
        this.assertPluginsCombined("jpa", null, null, null, "jpa", null);
        this.assertPluginsCombined("jpa", null, "jpa", null, "jpa", null);
        this.assertPluginsCombined("jdo", null, "jpa", null, "jpa", null);
        this.assertPluginsCombined("jdo", new String[]{"foo", "bar"}, "jpa", null, "jpa", null);
        this.assertPluginsCombined("jdo", new String[]{"foo", "bar"}, "jpa", new String[]{"biz", "baz"}, "jpa", new String[]{"biz", "baz"});
        this.assertPluginsCombined("jdo", new String[]{"foo", "bar"}, null, new String[]{"biz", "baz"}, "jdo", new String[]{"foo", "bar", "biz", "baz"});
        this.assertPluginsCombined(null, new String[]{"foo", "bar"}, null, new String[]{"biz", "baz"}, null, new String[]{"foo", "bar", "biz", "baz"});
        this.assertPluginsCombined(null, new String[]{"foo", "bar"}, "jpa", new String[]{"biz", "baz"}, "jpa", new String[]{"foo", "bar", "biz", "baz"});
        this.assertPluginsCombined("jpa", new String[]{"foo", "bar"}, "jpa", new String[]{"biz", "baz"}, "jpa", new String[]{"foo", "bar", "biz", "baz"});
        this.assertPluginsCombined("jpa", new String[]{"foo", "bar"}, "jpa", new String[]{"foo", "baz"}, "jpa", new String[]{"foo", "baz"});
    }

    private void assertPluginsCombined(String cls1, String[] props1, String cls2, String[] props2, String expCls, String[] expProps) {
        String plugin1 = Configurations.getPlugin((String)cls1, (String)Configurations.serializeProperties((Map)TestConfigurations.toProperties(props1)));
        String plugin2 = Configurations.getPlugin((String)cls2, (String)Configurations.serializeProperties((Map)TestConfigurations.toProperties(props2)));
        String res = Configurations.combinePlugins((String)plugin1, (String)plugin2);
        String resCls = Configurations.getClassName((String)res);
        Options resProps = Configurations.parseProperties((String)Configurations.getProperties((String)res));
        Assert.assertEquals((Object)expCls, (Object)resCls);
        Assert.assertEquals((Object)TestConfigurations.toProperties(expProps), (Object)resProps);
    }

    private static Map toProperties(String[] props) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                map.put(props[i], props[++i]);
            }
        }
        return map;
    }
}

