/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestConfigurationProviderPrefixes {
    private static final String CUSTOM_PREFIX = TestConfigurationProviderPrefixes.class.getName();
    private String[] _origPrefixes;

    @Before
    public void setUp() {
        this._origPrefixes = ProductDerivations.getConfigurationPrefixes();
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(this._origPrefixes));
        l.add(CUSTOM_PREFIX);
        ProductDerivations.setConfigurationPrefixes((String[])l.toArray(new String[0]));
    }

    @After
    public void tearDown() {
        ProductDerivations.setConfigurationPrefixes((String[])this._origPrefixes);
    }

    @Test
    public void testPrefixContents() {
        String[] prefixes = ProductDerivations.getConfigurationPrefixes();
        Assert.assertEquals((Object)CUSTOM_PREFIX, (Object)prefixes[prefixes.length - 1]);
        Assert.assertEquals((Object)"openjpa", (Object)prefixes[0]);
    }

    @Test
    public void testPartialKeyAndNullMap() {
        TestConfigurationProviderPrefixes.assertEquals("openjpa.Foo", "Foo", null, null);
    }

    @Test
    public void testPartialKeyWithInvalidPrefix() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bar.Foo", "value");
        TestConfigurationProviderPrefixes.assertEquals("openjpa.Foo", "Foo", map, null);
    }

    @Test
    public void testPartialKeyWithoutMatch() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bar.Baz", "value");
        TestConfigurationProviderPrefixes.assertEquals("openjpa.Foo", "Foo", map, null);
    }

    @Test
    public void testPartialKeyWithOpenJPAMatch() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("openjpa.Foo", "value");
        TestConfigurationProviderPrefixes.assertEquals("openjpa.Foo", "Foo", map, "value");
    }

    @Test
    public void testPartialKeyWithCustomMatch() {
        HashMap<CallSite, String> map = new HashMap<CallSite, String>();
        map.put((CallSite)((Object)(CUSTOM_PREFIX + ".Foo")), "value");
        TestConfigurationProviderPrefixes.assertEquals(CUSTOM_PREFIX + ".Foo", "Foo", map, "value");
    }

    @Test
    public void testPartialKeyDuplicateFullKeys() {
        HashMap<Object, String> map = new HashMap<Object, String>();
        map.put(CUSTOM_PREFIX + ".Foo", "value");
        map.put("openjpa.Foo", "value");
        try {
            ProductDerivations.getConfigurationKey((String)"Foo", map);
            Assert.fail((String)"duplicate keys should result in an IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void assertEquals(String fullKey, String partialKey, Map map, Object value) {
        Assert.assertEquals((Object)fullKey, (Object)ProductDerivations.getConfigurationKey((String)partialKey, (Map)map));
        if (map != null) {
            Assert.assertEquals((Object)value, map.get(fullKey));
        }
    }
}

