/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.parsers.SAXParser;
import org.apache.openjpa.lib.xml.DocTypeReader;
import org.apache.openjpa.lib.xml.XMLFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestDocTypeReader {
    private String _docType = null;
    private String _validXML = null;
    private String _invalidXML = null;
    private String _expectedXML = null;
    private String _validHTML = null;
    private String _expectedHTML = null;
    private String _xmlWithDocType = null;

    @Before
    public void setUp() {
        StringBuffer docType = new StringBuffer();
        docType.append("<!DOCTYPE foo [\n");
        docType.append("\t<!ELEMENT foo (bar)>\n");
        docType.append("\t<!ELEMENT bar EMPTY>\n");
        docType.append("\t<!ATTLIST bar attr CDATA \"value\">\n");
        docType.append("\t<!ATTLIST bar attr2 CDATA \"value2\">\n");
        docType.append("]>\n");
        this._docType = docType.toString();
        StringBuffer expectedXML = new StringBuffer();
        String header = "<?xml version=\"1.0\"?>\n";
        String comment = "<!-- some < ... > <! funky -> - comment -->\n";
        expectedXML.append(header);
        expectedXML.append(comment);
        expectedXML.append(docType.toString());
        StringBuffer xmlWithDocType = new StringBuffer();
        xmlWithDocType.append(header);
        xmlWithDocType.append(comment);
        xmlWithDocType.append(docType.toString());
        StringBuffer validXML = new StringBuffer();
        validXML.append("<foo>\n");
        validXML.append("\t<bar attr=\"newValue\"/>\n");
        validXML.append("</foo>");
        expectedXML.append(validXML.toString());
        xmlWithDocType.append(validXML.toString());
        this._validXML = header + comment + validXML.toString();
        this._expectedXML = expectedXML.toString();
        this._xmlWithDocType = xmlWithDocType.toString();
        StringBuffer invalidXML = new StringBuffer();
        invalidXML.append("<?xml version=\"1.0\"?>\n");
        invalidXML.append("<foo>\n");
        invalidXML.append("\t<xxx />\n");
        invalidXML.append("</foo>");
        this._invalidXML = invalidXML.toString();
        StringBuffer expectedHTML = new StringBuffer();
        header = "   \n  ";
        expectedHTML.append(header);
        expectedHTML.append(docType.toString());
        StringBuffer validHTML = new StringBuffer();
        validHTML.append("some junk <html><body></body></html>  ");
        expectedHTML.append(validHTML.toString());
        this._validHTML = header + validHTML.toString();
        this._expectedHTML = expectedHTML.toString();
    }

    @Test
    public void testIncludesDocType() throws IOException {
        Assert.assertEquals((Object)this._validXML, (Object)this.getIncludedString(this._validXML, null, 1));
        Assert.assertEquals((Object)this._validXML, (Object)this.getIncludedString(this._validXML, null, 7));
        Assert.assertEquals((Object)this._validHTML, (Object)this.getIncludedString(this._validHTML, null, 1));
        Assert.assertEquals((Object)this._validHTML, (Object)this.getIncludedString(this._validHTML, null, 7));
        Assert.assertEquals((Object)this._expectedXML, (Object)this.getIncludedString(this._validXML, this._docType, 1));
        Assert.assertEquals((Object)this._expectedXML, (Object)this.getIncludedString(this._validXML, this._docType, 7));
        Assert.assertEquals((Object)this._expectedHTML, (Object)this.getIncludedString(this._validHTML, this._docType, 1));
        Assert.assertEquals((Object)this._expectedHTML, (Object)this.getIncludedString(this._validHTML, this._docType, 7));
        Assert.assertEquals((Object)"   ", (Object)this.getIncludedString("   ", this._docType, 1));
        Assert.assertEquals((Object)"   ", (Object)this.getIncludedString("   ", this._docType, 7));
    }

    @Test
    public void testStreamWithDocType() throws IOException {
        Assert.assertEquals((Object)this._xmlWithDocType, (Object)this.getIncludedString(this._xmlWithDocType, null, 1));
        Assert.assertEquals((Object)this._xmlWithDocType, (Object)this.getIncludedString(this._xmlWithDocType, null, 7));
        Assert.assertEquals((Object)this._xmlWithDocType, (Object)this.getIncludedString(this._xmlWithDocType, this._docType, 1));
        Assert.assertEquals((Object)this._xmlWithDocType, (Object)this.getIncludedString(this._xmlWithDocType, this._docType, 7));
    }

    private String getIncludedString(String xml, String docType, int bufSize) throws IOException {
        StringReader xmlReader = new StringReader(xml);
        StringReader docReader = null;
        if (docType != null) {
            docReader = new StringReader(docType);
        }
        StringWriter writer = new StringWriter();
        DocTypeReader reader = new DocTypeReader((Reader)xmlReader, (Reader)docReader);
        if (bufSize == 1) {
            int ch = reader.read();
            while (ch != -1) {
                ((Writer)writer).write(ch);
                ch = reader.read();
            }
        } else {
            char[] ch;
            int read;
            while ((read = reader.read(ch = new char[bufSize])) != -1) {
                ((Writer)writer).write(ch, 0, read);
            }
        }
        return ((Object)writer).toString();
    }

    @Test
    public void testValidation() throws IOException, SAXException {
        SAXParser parser = XMLFactory.getSAXParser((boolean)false, (boolean)false);
        InputSource source = new InputSource();
        source.setCharacterStream(new StringReader(this._validXML));
        parser.parse(source, (DefaultHandler)new Handler());
        source.setCharacterStream(new StringReader(this._invalidXML));
        parser.parse(source, (DefaultHandler)new Handler());
        parser = XMLFactory.getSAXParser((boolean)true, (boolean)false);
        source.setCharacterStream((Reader)new DocTypeReader((Reader)new StringReader(this._validXML), (Reader)new StringReader(this._docType)));
        parser.parse(source, (DefaultHandler)new Handler());
        try {
            source.setCharacterStream((Reader)new DocTypeReader((Reader)new StringReader(this._invalidXML), (Reader)new StringReader(this._docType)));
            parser.parse(source, (DefaultHandler)new Handler());
            Assert.fail((String)"Parsed invalid document");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private static class Handler
    extends DefaultHandler {
        private Handler() {
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            throw spe;
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            throw spe;
        }
    }
}

