/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import org.apache.openjpa.lib.util.UUIDGenerator;
import org.junit.Assert;
import org.junit.Test;

public class TestUUIDGenerator {
    @Test
    public void testUniqueString() {
        HashSet<String> seen = new HashSet<String>();
        for (int i = 0; i < 10000; ++i) {
            Assert.assertTrue((boolean)seen.add(UUIDGenerator.nextString((int)1)));
        }
    }

    @Test
    public void testUniqueHex() {
        HashSet<String> seen = new HashSet<String>();
        for (int i = 0; i < 10000; ++i) {
            Assert.assertTrue((boolean)seen.add(UUIDGenerator.nextHex((int)1)));
        }
    }

    @Test
    public void testUniqueType4String() {
        HashSet<String> seen = new HashSet<String>();
        for (int i = 0; i < 10000; ++i) {
            Assert.assertTrue((boolean)seen.add(UUIDGenerator.nextString((int)4)));
        }
    }

    @Test
    public void testUniqueType4Hex() {
        HashSet<String> seen = new HashSet<String>();
        for (int i = 0; i < 10000; ++i) {
            Assert.assertTrue((boolean)seen.add(UUIDGenerator.nextHex((int)4)));
        }
    }

    @Test
    public void testUniqueMixedTypesHex() {
        HashSet<String> seen = new HashSet<String>();
        for (int i = 0; i < 10000; ++i) {
            int type = i % 2 == 0 ? 4 : 1;
            Assert.assertTrue((boolean)seen.add(UUIDGenerator.nextHex((int)type)));
        }
    }

    @Test
    public void testGetTime() {
        long time = 0L;
        for (int i = 0; i < 10000; ++i) {
            long newTime = UUIDGenerator.getTime();
            Assert.assertTrue((newTime != time ? 1 : 0) != 0);
            time = newTime;
        }
    }

    @Test
    public void testInitType1MultiThreaded() throws Exception {
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                Field[] fields;
                Class<UUIDGenerator> uuid = UUIDGenerator.class;
                for (Field f : fields = uuid.getDeclaredFields()) {
                    if (f.getName().equals("type1Initialized")) {
                        f.setAccessible(true);
                        f.set(null, false);
                        continue;
                    }
                    if (!f.getName().equals("IP") && !f.getName().equals("RANDOM")) continue;
                    f.setAccessible(true);
                    f.set(null, null);
                }
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        UUIDGenerator.createType1();
                    }
                };
                t.start();
                UUIDGenerator.createType1();
                return null;
            }
        });
    }
}

