/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.util.Properties;
import org.apache.openjpa.lib.util.TypedProperties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTypedProperties {
    private TypedProperties _props = null;
    private TypedProperties _defs = null;

    @Before
    public void setUp() {
        this._props = new TypedProperties();
        this._props.setProperty("bool", "true");
        this._props.setProperty("int", "1");
        this._props.setProperty("long", "2");
        this._props.setProperty("float", "1.1");
        this._props.setProperty("double", "2.2");
        this._defs = new TypedProperties((Properties)this._props);
    }

    @Test
    public void testTypes() {
        Assert.assertTrue((boolean)this._props.getBooleanProperty("bool"));
        Assert.assertEquals((long)1L, (long)this._props.getIntProperty("int"));
        Assert.assertEquals((long)2L, (long)this._props.getLongProperty("long"));
        Assert.assertEquals((float)1.1f, (float)this._props.getFloatProperty("float"), (float)0.01f);
        Assert.assertEquals((double)2.2, (double)this._props.getDoubleProperty("double"), (double)0.01);
        Assert.assertEquals((Object)"2.2", (Object)this._props.getProperty("double"));
    }

    @Test
    public void testNoDefaults() {
        Assert.assertTrue((!this._props.getBooleanProperty("bool2") ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this._props.getIntProperty("int2"));
        Assert.assertEquals((long)0L, (long)this._props.getLongProperty("long2"));
        Assert.assertEquals((float)0.0f, (float)this._props.getFloatProperty("float2"), (float)0.0f);
        Assert.assertEquals((double)0.0, (double)this._props.getDoubleProperty("double2"), (double)0.0);
        Assert.assertEquals(null, (Object)this._props.getProperty("double2"));
    }

    @Test
    public void testDefaults() {
        Assert.assertTrue((boolean)this._defs.getBooleanProperty("bool"));
        Assert.assertEquals((long)1L, (long)this._defs.getIntProperty("int"));
        Assert.assertEquals((long)2L, (long)this._defs.getLongProperty("long"));
        Assert.assertEquals((float)1.1f, (float)this._defs.getFloatProperty("float"), (float)0.01f);
        Assert.assertEquals((double)2.2, (double)this._defs.getDoubleProperty("double"), (double)0.01);
        Assert.assertEquals((Object)"2.2", (Object)this._defs.getProperty("double"));
    }

    @Test
    public void testGivenDefaults() {
        Assert.assertTrue((boolean)this._props.getBooleanProperty("bool2", true));
        Assert.assertEquals((long)1L, (long)this._props.getIntProperty("int2", 1));
        Assert.assertEquals((long)2L, (long)this._props.getLongProperty("long2", 2L));
        Assert.assertEquals((float)1.1f, (float)this._props.getFloatProperty("float2", 1.1f), (float)0.01f);
        Assert.assertEquals((double)2.2, (double)this._props.getDoubleProperty("double2", 2.2), (double)0.01);
        Assert.assertEquals((Object)"2.2", (Object)this._props.getProperty("double2", "2.2"));
        Assert.assertTrue((boolean)this._defs.getBooleanProperty("bool", false));
        Assert.assertEquals((long)1L, (long)this._defs.getIntProperty("int", 2));
        Assert.assertEquals((long)2L, (long)this._defs.getLongProperty("long", 3L));
        Assert.assertEquals((float)1.1f, (float)this._defs.getFloatProperty("float", 2.2f), (float)0.01f);
        Assert.assertEquals((double)2.2, (double)this._defs.getDoubleProperty("double", 3.3), (double)0.01);
        Assert.assertEquals((Object)"2.2", (Object)this._defs.getProperty("double", "3.3"));
    }
}

