/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.util.Iterator;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.lib.util.ReferenceHashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestReferenceSet {
    private ReferenceHashSet _coll = new ReferenceHashSet(AbstractReferenceMap.ReferenceStrength.WEAK);
    private Object _heldValue = new Integer(2);

    @Before
    public void setUp() {
        this._coll.add(this._heldValue);
        this._coll.add((Object)new Integer(1));
    }

    @Test
    public void testBasics() {
        ReferenceHashSet coll = new ReferenceHashSet(AbstractReferenceMap.ReferenceStrength.WEAK);
        Assert.assertEquals((long)0L, (long)coll.size());
        Assert.assertTrue((!coll.contains("foo") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)coll.add("foo"));
        Assert.assertEquals((long)1L, (long)coll.size());
        Assert.assertTrue((boolean)coll.contains("foo"));
        Assert.assertEquals((Object)"foo", coll.iterator().next());
        Assert.assertTrue((!coll.remove("bar") ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)coll.size());
        Assert.assertTrue((boolean)coll.remove("foo"));
        Assert.assertEquals((long)0L, (long)coll.size());
        Assert.assertTrue((boolean)coll.isEmpty());
    }

    @Test
    public void testHeldReference() {
        if (JavaVersions.VERSION >= 5) {
            return;
        }
        System.gc();
        System.gc();
        Assert.assertTrue((boolean)this._coll.contains(this._heldValue));
    }

    @Test
    public void testWeakReference() {
        if (JavaVersions.VERSION >= 5) {
            return;
        }
        System.gc();
        System.gc();
        Assert.assertTrue((!this._coll.contains((Object)new Integer(1)) ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this._coll.size());
        int size = 0;
        Iterator itr = this._coll.iterator();
        while (itr.hasNext()) {
            Assert.assertEquals((Object)this._heldValue, itr.next());
            ++size;
        }
        Assert.assertEquals((long)1L, (long)size);
        this._coll.add((Object)"foo");
        Assert.assertEquals((long)2L, (long)this._coll.size());
        Assert.assertTrue((boolean)this._coll.contains((Object)"foo"));
        Assert.assertTrue((boolean)this._coll.contains(this._heldValue));
        Assert.assertTrue((!this._coll.contains((Object)new Integer(1)) ? 1 : 0) != 0);
    }

    @Test
    public void testChangeValue() {
        if (JavaVersions.VERSION >= 5) {
            return;
        }
        Integer held = new Integer(1);
        Assert.assertTrue((boolean)this._coll.remove((Object)held));
        Assert.assertTrue((boolean)this._coll.add((Object)held));
        System.gc();
        System.gc();
        this._coll.add((Object)"foo");
        Assert.assertTrue((boolean)this._coll.contains((Object)held));
    }
}

