/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.openjpa.lib.util.FormatPreservingProperties;
import org.junit.Assert;
import org.junit.Test;

public class TestPropertiesParser {
    private static final String LS = System.getProperty("line.separator");

    @Test
    public void testSimpleProperties() throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("key: value" + LS);
        buf.append("key2: value2");
        FormatPreservingProperties p = this.toProperties(buf.toString());
        this.assertProperties(new String[][]{{"key", "value"}, {"key2", "value2"}}, (Properties)p);
    }

    @Test
    public void testComments() throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("# this is a comment" + LS);
        buf.append(" # another one, with leading whitespace\t" + LS);
        buf.append(" \t# \tand more with interesting whitespace\t" + LS);
        buf.append("! and with a ! delimiter" + LS);
        buf.append("! and with escape \t chars" + LS);
        buf.append("#and a comment with no whitespace" + LS);
        FormatPreservingProperties p = this.toProperties(buf.toString());
        Assert.assertEquals((long)0L, (long)p.size());
    }

    @Test
    public void testMixedContent() throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("# this is a comment" + LS);
        buf.append(" # another one, with leading whitespace\t" + LS);
        buf.append("foo: bar#baz" + LS);
        buf.append("! and with a ! delimiter" + LS);
        buf.append("! and with escape \t chars" + LS);
        FormatPreservingProperties p = this.toProperties(buf.toString());
        this.assertProperties(new String[][]{{"foo", "bar#baz"}}, (Properties)p);
    }

    @Test
    public void testMultiLineInput() throws IOException {
        String s = "foo: bar\\" + LS + "more line goes here";
        FormatPreservingProperties p = this.toProperties(s);
        this.assertProperties(new String[][]{{"foo", "barmore line goes here"}}, (Properties)p);
    }

    @Test
    public void testEmptyLines() throws IOException {
        FormatPreservingProperties p = this.toProperties(LS + "foo: bar" + LS + LS + "baz: val");
        this.assertProperties(new String[][]{{"foo", "bar"}, {"baz", "val"}}, (Properties)p);
    }

    @Test
    public void testAddProperties() throws IOException {
        String s = "foo: bar" + LS + "baz: val";
        FormatPreservingProperties p = this.toProperties(s);
        this.assertProperties(new String[][]{{"foo", "bar"}, {"baz", "val"}}, (Properties)p);
        p.put("new-key", "val1");
        p.put("new-key-2", "val2");
        p.put("another-new-key", "val3");
        this.assertRoundTrip(s + LS + "new-key: val1" + LS + "new-key-2: val2" + LS + "another-new-key: val3" + LS, (Properties)p);
    }

    @Test
    public void testAddAndMutateProperties() throws IOException {
        FormatPreservingProperties p = this.toProperties("foo: bar" + LS + "baz: val");
        this.assertProperties(new String[][]{{"foo", "bar"}, {"baz", "val"}}, (Properties)p);
        p.put("new-key", "new value");
        p.put("foo", "barbar");
        this.assertRoundTrip("foo: barbar" + LS + "baz: val" + LS + "new-key: new value" + LS, (Properties)p);
    }

    @Test
    public void testEscapedEquals() throws IOException {
        FormatPreservingProperties p = this.toProperties("foo=bar\\=WARN,baz\\=TRACE");
        this.assertProperties(new String[][]{{"foo", "bar=WARN,baz=TRACE"}}, (Properties)p);
    }

    @Test
    public void testLineTypes() throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("   !comment" + LS + " \t  " + LS + "name = no" + LS + "    #morec\tomm\\" + LS + "ents" + LS + LS + "  dog=no\\cat   " + LS + "burps    :" + LS + "test=" + LS + "date today" + LS + LS + LS + "long\\" + LS + "   value=tryin \\" + LS + " gto" + LS + "4:vier" + LS + "vier     :4");
        FormatPreservingProperties p = this.toProperties(buf.toString());
        this.assertProperties(new String[][]{{"name", "no"}, {"ents", ""}, {"dog", "nocat   "}, {"burps", ""}, {"test", ""}, {"date", "today"}, {"longvalue", "tryin gto"}, {"4", "vier"}, {"vier", "4"}}, (Properties)p);
    }

    @Test
    public void testSpecialChars() throws Throwable {
        this.testSpecialChars(false, true);
        this.testSpecialChars(true, true);
        this.testSpecialChars(false, false);
        this.testSpecialChars(true, false);
    }

    private void testSpecialChars(boolean formattingProps, boolean value) throws Throwable {
        ArrayList<String> valueList = new ArrayList<String>(Arrays.asList("xxyy", "xx\\yy", "xx" + LS + "yy", "xx\\nyy", "xx\tyy", "xx\\tyy", "xx\ryy", "xx\\ryy", "xx\fyy", "xx\\fyy", "xx\r" + LS + "\\\t\r\t" + LS + "yy", "xx\\r" + LS + "\\\t\\r\t\\nyy", "xx\r" + LS + "\\\\\\\\\\\\\\\\\\\\\\\\\\\t\r\t" + LS + "yy", "C:\\Program Files\\Some Application\\OpenJPA\\My File.dat"));
        for (char c = 'a'; c < 'Z'; c = (char)((char)(c + 1))) {
            valueList.add(new String(new char[]{c}));
            valueList.add(new String(new char[]{c, '\\', c}));
            valueList.add(new String(new char[]{'\\', c}));
        }
        String[] values = valueList.toArray(new String[0]);
        String dummy = "XXX";
        for (int i = 0; i < values.length; ++i) {
            Object p;
            String val = value ? values[i] : "XXX";
            String key = value ? "XXX" : values[i];
            Object object = p = formattingProps ? new FormatPreservingProperties() : new Properties();
            if (p instanceof FormatPreservingProperties) {
                p.setDefaultEntryDelimiter('=');
                ((FormatPreservingProperties)p).setAddWhitespaceAfterDelimiter(false);
            }
            ((Properties)p).setProperty(key, val);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ((Properties)p).store(out, null);
            Properties copy = new Properties();
            copy.setProperty(key, val);
            ByteArrayOutputStream copyOut = new ByteArrayOutputStream();
            copy.store(copyOut, null);
            p = formattingProps ? new FormatPreservingProperties() : new Properties();
            BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(out.toByteArray()));
            try {
                String copyOutString = TestPropertiesParser.stripComments(copyOut.toByteArray());
                String outString = TestPropertiesParser.stripComments(out.toByteArray());
                Assert.assertEquals((Object)copyOutString, (Object)outString);
                ((Properties)p).load(in);
                Assert.assertNotNull((String)("Property \"" + key + "\" was null"), (Object)((Properties)p).getProperty(key));
                Assert.assertEquals((Object)val.trim(), (Object)((Properties)p).getProperty(key).trim());
                continue;
            }
            catch (Throwable ioe) {
                if (!formattingProps) {
                    throw ioe;
                }
                throw ioe;
            }
        }
    }

    static Character randomChar() {
        char[] TEST_CHAR_ARRAY = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        return new Character(TEST_CHAR_ARRAY[(int)(Math.random() * (double)TEST_CHAR_ARRAY.length)]);
    }

    static String randomString(int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < (int)(Math.random() * (double)len) + 1; ++i) {
            buf.append(TestPropertiesParser.randomChar());
        }
        return buf.toString();
    }

    @Test
    public void testEquivalentStore() throws IOException {
        Properties p1 = new Properties();
        FormatPreservingProperties p2 = new FormatPreservingProperties();
        p2.setDefaultEntryDelimiter('=');
        p2.setAddWhitespaceAfterDelimiter(false);
        String[] values = new String[]{"x", "x" + LS + "y", "x\\ny", "x\ty", "x\\ty", "x\fy", "x\\fy", "x\ry", "x\\ry", "C:\\Foo Bar\\Baz", TestPropertiesParser.randomString(5).replace('a', '\\'), TestPropertiesParser.randomString(500).replace('a', '\\'), TestPropertiesParser.randomString(5000).replace('a', '\\')};
        for (int i = 0; i < values.length; ++i) {
            p1.clear();
            p2.clear();
            p1.setProperty("xxx", values[i]);
            p2.setProperty("xxx", values[i]);
            ByteArrayOutputStream out1 = new ByteArrayOutputStream();
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            p1.store(out1, null);
            p2.store((OutputStream)out2, null);
            String s1 = new String(out1.toByteArray());
            String s2 = new String(out2.toByteArray());
            Assert.assertTrue((String)("Expected <" + s1 + "> but was <" + s2 + ">"), (s1.indexOf(s2) != -1 ? 1 : 0) != 0);
        }
    }

    static String stripComments(byte[] bytes) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));
        StringBuffer sbuf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if (line.trim().startsWith("#")) continue;
            sbuf.append(line);
            sbuf.append(LS);
        }
        return sbuf.toString();
    }

    @Test
    public void testDuplicateProperties() throws IOException {
        FormatPreservingProperties p = new FormatPreservingProperties();
        try {
            this.toProperties("foo=bar" + LS + "foo=baz", p);
            Assert.fail((String)"expected duplicate keys to cause exception");
        }
        catch (FormatPreservingProperties.DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
        p = new FormatPreservingProperties();
        p.setAllowDuplicates(true);
        this.toProperties("foo=bar" + LS + "foo=baz", p);
        this.assertProperties(new String[][]{{"foo", "baz"}}, (Properties)p);
    }

    @Test
    public void testMultipleLoads() throws IOException {
        String props = "foo=bar" + LS + "baz=quux";
        String props2 = "a=b" + LS + "c=d";
        Properties vanilla = new Properties();
        vanilla.load(new BufferedInputStream(new StringBufferInputStream(props)));
        vanilla.load(new BufferedInputStream(new StringBufferInputStream(props2)));
        FormatPreservingProperties p = new FormatPreservingProperties();
        p.load(new BufferedInputStream(new StringBufferInputStream(props)));
        p.load(new BufferedInputStream(new StringBufferInputStream(props2)));
        this.assertPropertiesSame(vanilla, (Properties)p);
    }

    protected FormatPreservingProperties toProperties(String s) throws IOException {
        return this.toProperties(s, new FormatPreservingProperties());
    }

    protected FormatPreservingProperties toProperties(String s, FormatPreservingProperties p) throws IOException {
        Properties vanilla = new Properties();
        vanilla.load(new StringBufferInputStream(s));
        p.load((InputStream)new StringBufferInputStream(s));
        this.assertRoundTrip(s, (Properties)p);
        this.assertPropertiesSame(vanilla, (Properties)p);
        return p;
    }

    private void assertRoundTrip(String s, Properties p) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        p.store(out, null);
        Assert.assertEquals((Object)s, (Object)out.toString());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(p);
        try {
            FormatPreservingProperties deserialized = (FormatPreservingProperties)new ObjectInputStream(new ByteArrayInputStream(bout.toByteArray())).readObject();
            Assert.assertEquals((Object)p, (Object)deserialized);
            out = new ByteArrayOutputStream();
            deserialized.store((OutputStream)out, null);
            Assert.assertEquals((Object)s, (Object)out.toString());
        }
        catch (ClassNotFoundException cnfe) {
            Assert.fail((String)(cnfe + ""));
        }
    }

    private void assertPropertiesSame(Properties vanilla, Properties p) {
        Assert.assertEquals((Object)vanilla, (Object)p);
    }

    protected void assertProperties(String[][] strings, Properties p) {
        for (int i = 0; i < strings.length; ++i) {
            Assert.assertEquals((Object)strings[i][1], (Object)p.get(strings[i][0]));
        }
        Assert.assertEquals((long)strings.length, (long)p.size());
    }
}

