/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.util.Properties;
import org.apache.openjpa.lib.util.Options;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOptions {
    private Options _opts = null;
    private String[] _args = new String[]{"-int", "10", "-boolean", "-string", "STR,STR2", "-range1", "10,100", "-range2", "10", "-fieldVal", "20", "-FieldVal2", "30", "-inner.nullInner.range1", "10,100", "arg1", "arg2", "arg3"};

    @Before
    public void setUp() {
        Properties defs = new Properties();
        defs.setProperty("default", "value");
        this._opts = new Options(defs);
        this._args = this._opts.setFromCmdLine(this._args);
    }

    @Test
    public void testCmdLineParsing() {
        Assert.assertEquals((long)3L, (long)this._args.length);
        Assert.assertEquals((Object)"arg1", (Object)this._args[0]);
        Assert.assertEquals((Object)"arg2", (Object)this._args[1]);
        Assert.assertEquals((Object)"arg3", (Object)this._args[2]);
        Assert.assertEquals((Object)"10", (Object)this._opts.getProperty("int"));
        Assert.assertEquals((Object)"true", (Object)this._opts.getProperty("boolean"));
        Assert.assertEquals((Object)"STR,STR2", (Object)this._opts.getProperty("string"));
        Assert.assertEquals((Object)"20", (Object)this._opts.getProperty("fieldVal"));
        Assert.assertEquals((Object)"30", (Object)this._opts.getProperty("FieldVal2"));
        Assert.assertEquals((Object)"10,100", (Object)this._opts.getProperty("range1"));
        Assert.assertEquals((Object)"10", (Object)this._opts.getProperty("range2"));
        Assert.assertEquals((Object)"10,100", (Object)this._opts.getProperty("inner.nullInner.range1"));
        Assert.assertEquals((Object)"value", (Object)this._opts.getProperty("default"));
        this._args = this._opts.setFromCmdLine(new String[]{"-default", "newValue"});
        Assert.assertEquals((long)0L, (long)this._args.length);
        Assert.assertEquals((Object)"newValue", (Object)this._opts.getProperty("default"));
    }

    @Test
    public void testSetObject() {
        Inner inner = new Inner();
        this._opts.setInto((Object)inner);
        Assert.assertEquals((long)10L, (long)inner.getInt());
        Assert.assertTrue((boolean)inner.getBoolean());
        Assert.assertEquals((Object)"STR,STR2", (Object)inner.getString());
        Assert.assertEquals((long)20L, (long)inner.fieldVal);
        Assert.assertEquals((long)30L, (long)inner.fieldVal2);
        Assert.assertEquals((long)10L, (long)inner.getRange1()[0]);
        Assert.assertEquals((long)100L, (long)inner.getRange1()[1]);
        Assert.assertEquals((long)10L, (long)inner.getRange2()[0]);
        Assert.assertEquals((long)0L, (long)inner.getRange2()[1]);
        Assert.assertEquals((Object)"value", (Object)inner.getDefault());
        Assert.assertEquals((long)10L, (long)inner.getInner().getNullInner().getRange1()[0]);
        Assert.assertEquals((long)100L, (long)inner.getInner().getNullInner().getRange1()[1]);
        inner = new Inner();
        Options opts = new Options();
        opts.setProperty("inner", Inner2.class.getName());
        opts.setInto((Object)inner);
        Assert.assertEquals(Inner2.class, inner.getInner().getClass());
        inner = new Inner();
        opts = new Options();
        opts.setProperty("mixed", "STR,1");
        opts.setInto((Object)inner);
        Assert.assertEquals((long)1L, (long)inner.getInt());
        Assert.assertEquals((Object)"STR", (Object)inner.getString());
    }

    public static class Inner2
    extends Inner {
    }

    public static class Inner {
        public int fieldVal = 0;
        public int fieldVal2 = 0;
        private int _int = 0;
        private boolean _boolean = false;
        private String _string = null;
        private String _default = null;
        private Inner _inner = null;
        private Inner _nullInner = null;
        private int[] _range1 = new int[2];
        private int[] _range2 = new int[2];

        public int getInt() {
            return this._int;
        }

        public void setInt(int i) {
            this._int = i;
        }

        public boolean getBoolean() {
            return this._boolean;
        }

        public void setBoolean(boolean b) {
            this._boolean = b;
        }

        public String getString() {
            return this._string;
        }

        public void setString(String s) {
            this._string = s;
        }

        public String getDefault() {
            return this._default;
        }

        public void setDefault(String s) {
            this._default = s;
        }

        public int[] getRange1() {
            return this._range1;
        }

        public void setRange1(int min, int max) {
            this._range1[0] = min;
            this._range1[1] = max;
        }

        public int[] getRange2() {
            return this._range2;
        }

        public void setRange2(int min, int max) {
            this._range2[0] = min;
            this._range2[1] = max;
        }

        public void setMixed(String s, int i) {
            this._int = i;
            this._string = s;
        }

        public Inner getInner() {
            if (this._inner == null) {
                this._inner = new Inner();
            }
            return this._inner;
        }

        public void setInner(Inner in) {
            this._inner = in;
        }

        public Inner getNullInner() {
            return this._nullInner;
        }

        public void setNullInner(Inner in) {
            this._nullInner = in;
        }
    }
}

