/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.net.URL;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMultiClassLoader {
    private ClassLoader SYSTEM_LOADER = MultiClassLoader.class.getClassLoader();
    private MultiClassLoader _loader = new MultiClassLoader();

    @Before
    public void setUp() {
        this._loader.addClassLoader(MultiClassLoader.THREAD_LOADER);
        this._loader.addClassLoader(this.SYSTEM_LOADER);
    }

    @Test
    public void testBasic() {
        Assert.assertEquals((long)2L, (long)this._loader.size());
        Assert.assertTrue((!this._loader.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((this._loader.getClassLoaders()[0] == this.SYSTEM_LOADER ? 1 : 0) != 0);
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)this._loader.getClassLoaders()[1]);
        Assert.assertTrue((this._loader.getClassLoader(0) == this.SYSTEM_LOADER ? 1 : 0) != 0);
        Assert.assertTrue((!this._loader.addClassLoader(MultiClassLoader.THREAD_LOADER) ? 1 : 0) != 0);
        FooLoader foo = new FooLoader();
        Assert.assertTrue((boolean)this._loader.addClassLoader((ClassLoader)foo));
        Assert.assertTrue((!this._loader.addClassLoader((ClassLoader)foo) ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)this._loader.size());
        Assert.assertEquals((Object)foo, (Object)this._loader.getClassLoaders()[2]);
        Assert.assertTrue((boolean)this._loader.removeClassLoader(MultiClassLoader.THREAD_LOADER));
        Assert.assertTrue((!this._loader.removeClassLoader(MultiClassLoader.THREAD_LOADER) ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)this._loader.size());
        Assert.assertTrue((this._loader.getClassLoaders()[0] == this.SYSTEM_LOADER ? 1 : 0) != 0);
        Assert.assertEquals((Object)foo, (Object)this._loader.getClassLoaders()[1]);
        Assert.assertTrue((boolean)this._loader.removeClassLoader((ClassLoader)foo));
        Assert.assertTrue((boolean)this._loader.removeClassLoader(this.SYSTEM_LOADER));
        Assert.assertTrue((boolean)this._loader.isEmpty());
        MultiClassLoader loader2 = new MultiClassLoader();
        loader2.addClassLoader(MultiClassLoader.THREAD_LOADER);
        loader2.addClassLoader(this.SYSTEM_LOADER);
        Assert.assertTrue((boolean)this._loader.addClassLoaders(loader2));
        Assert.assertTrue((!this._loader.addClassLoaders(loader2) ? 1 : 0) != 0);
        FooLoader foo2 = new FooLoader();
        loader2.addClassLoader((ClassLoader)foo);
        loader2.addClassLoader((ClassLoader)foo2);
        Assert.assertTrue((boolean)this._loader.addClassLoaders(1, loader2));
        ClassLoader[] loaders = this._loader.getClassLoaders();
        Assert.assertTrue((loaders[0] == this.SYSTEM_LOADER ? 1 : 0) != 0);
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)loaders[3]);
        Assert.assertEquals((Object)foo, (Object)loaders[1]);
        Assert.assertEquals((Object)foo2, (Object)loaders[2]);
    }

    @Test
    public void testGetResource() {
        Assert.assertNull((Object)this._loader.getResource("foo"));
        this._loader.addClassLoader((ClassLoader)new FooLoader());
        Assert.assertNotNull((Object)this._loader.getResource("foo"));
    }

    private static final class FooLoader
    extends ClassLoader {
        private FooLoader() {
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            if ("foo".equals(name)) {
                return Integer.class;
            }
            throw new ClassNotFoundException(name);
        }

        @Override
        protected URL findResource(String name) {
            try {
                if ("foo".equals(name)) {
                    return new URL("file:///dev/null");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

