/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import org.apache.openjpa.lib.util.concurrent.AbstractConcurrentEventManager;
import org.junit.Assert;
import org.junit.Test;

public class TestAbstractEventManager {
    private EventManager _em = new EventManager();

    @Test
    public void testReentrantAdd() {
        Listener l1 = new Listener(1);
        Listener l2 = new Listener(0);
        this._em.addListener(l1);
        this._em.addListener(l2);
        this._em.fireEvent(new Object());
        Assert.assertTrue((boolean)l1.fired);
        Assert.assertTrue((boolean)l2.fired);
        Assert.assertEquals((long)3L, (long)this._em.getListeners().size());
    }

    @Test
    public void testReentrantRemove() {
        Listener l1 = new Listener(2);
        Listener l2 = new Listener(0);
        this._em.addListener(l1);
        this._em.addListener(l2);
        this._em.fireEvent(new Object());
        Assert.assertTrue((boolean)l1.fired);
        Assert.assertTrue((boolean)l2.fired);
        Assert.assertEquals((long)1L, (long)this._em.getListeners().size());
        Assert.assertFalse((boolean)this._em.getListeners().contains(l1));
    }

    private class Listener {
        public static final int NONE = 0;
        public static final int ADD = 1;
        public static final int REMOVE = 2;
        public boolean fired;
        private final int _action;

        public Listener(int action) {
            this._action = action;
        }

        public void fire() {
            this.fired = true;
            if (this._action == 1) {
                TestAbstractEventManager.this._em.addListener(new Listener(0));
            } else if (this._action == 2) {
                Assert.assertTrue((boolean)TestAbstractEventManager.this._em.removeListener(this));
            }
        }
    }

    private static class EventManager
    extends AbstractConcurrentEventManager {
        private static final long serialVersionUID = 1L;

        private EventManager() {
        }

        protected void fireEvent(Object event, Object listener) {
            ((Listener)listener).fire();
        }
    }
}

