/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.LogFactoryImpl;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.REUtil;
import org.junit.After;
import org.junit.Assert;

public abstract class AbstractTestCase {
    private static final Localizer _loc = Localizer.forPackage(AbstractTestCase.class);
    private Log log = null;

    protected final Log getLog() {
        if (this.log == null) {
            this.log = this.newLog();
        }
        return this.log;
    }

    protected Log newLog() {
        return new LogFactoryImpl().getLog(this.getClass().getName());
    }

    @After
    public void tearDown() throws Exception {
        if ("true".equals(System.getProperty("meminfo"))) {
            this.printMemoryInfo();
        }
    }

    public static Integer randomInt() {
        return new Integer((int)(Math.random() * 2.147483647E9));
    }

    public static Character randomChar() {
        char[] TEST_CHAR_ARRAY = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        return new Character(TEST_CHAR_ARRAY[(int)(Math.random() * (double)TEST_CHAR_ARRAY.length)]);
    }

    public static Long randomLong() {
        return new Long((long)(Math.random() * 9.223372036854776E18));
    }

    public static String randomString() {
        return AbstractTestCase.randomString(50);
    }

    public static String randomString(int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < (int)(Math.random() * (double)len) + 1; ++i) {
            buf.append(AbstractTestCase.randomChar());
        }
        return buf.toString();
    }

    public void assertNotEquals(Object a, Object b) {
        if (a == null && b != null) {
            return;
        }
        if (a != null && b == null) {
            return;
        }
        if (!a.equals(b)) {
            return;
        }
        if (!b.equals(a)) {
            return;
        }
        Assert.fail((String)("expected !<" + a + ">.equals(<" + b + ">)"));
    }

    public void assertSize(int size, Object ob) {
        if (ob == null) {
            Assert.assertEquals((long)size, (long)0L);
            return;
        }
        if (ob instanceof Collection) {
            ob = ((Collection)((Object)ob)).iterator();
        }
        if (ob instanceof Iterator) {
            Iterator i = ob;
            int count = 0;
            while (i.hasNext()) {
                ++count;
                i.next();
            }
            Assert.assertEquals((long)size, (long)count);
        } else {
            Assert.fail((String)("assertSize: expected Collection, Iterator, Query, or Extent, but got " + ob.getClass().getName()));
        }
    }

    public void copy(File from, File to) throws IOException {
        this.copy(new FileInputStream(from), to);
    }

    public void copy(InputStream in, File to) throws IOException {
        FileOutputStream fout = new FileOutputStream(to);
        byte[] b = new byte[1024];
        int n = 0;
        while ((n = in.read(b)) != -1) {
            fout.write(b, 0, n);
        }
    }

    public void printMemoryInfo() {
        Runtime rt = Runtime.getRuntime();
        long total = rt.totalMemory();
        long free = rt.freeMemory();
        long used = total - free;
        NumberFormat nf = NumberFormat.getInstance();
        this.getLog().warn((Object)_loc.get("mem-info", (Object)nf.format(used), (Object)nf.format(total), (Object)nf.format(free)));
    }

    public static Object roundtrip(Object orig, boolean validateEquality) throws IOException, ClassNotFoundException {
        Assert.assertNotNull((Object)orig);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(orig);
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bin);
        Object result = in.readObject();
        if (validateEquality) {
            Assert.assertEquals((Object)orig, (Object)result);
            Assert.assertEquals((long)orig.hashCode(), (long)result.hashCode());
        }
        return result;
    }

    public static boolean matches(String regex, String input) throws RESyntaxException {
        RE re = REUtil.createRE((String)regex);
        return re.match(input);
    }

    public static List matches(String regex, Collection input) throws RESyntaxException {
        ArrayList<String> matches = new ArrayList<String>();
        for (String check : input) {
            if (!AbstractTestCase.matches(regex, check)) continue;
            matches.add(check);
        }
        return matches;
    }
}

