/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.identifier;

import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.lib.identifier.IdentifierConfiguration;
import org.apache.openjpa.lib.identifier.IdentifierRule;

public class IdConfigurationTestImpl
implements IdentifierConfiguration {
    Map<String, IdentifierRule> _rules = new HashMap<String, IdentifierRule>();
    private final String conversionKey = this.getLeadingDelimiter() + this.getIdentifierDelimiter() + this.getTrailingDelimiter();
    private IdentifierRule _defRule = new IdentifierRule();

    public IdConfigurationTestImpl() {
        this._rules.put("DEFAULT", this._defRule);
    }

    public boolean delimitAll() {
        return false;
    }

    public IdentifierRule getDefaultIdentifierRule() {
        return this._defRule;
    }

    public String getDelimitedCase() {
        return "preserve";
    }

    public String getLeadingDelimiter() {
        return "`";
    }

    public String getIdentifierDelimiter() {
        return ":";
    }

    public String getIdentifierConcatenator() {
        return "-";
    }

    public <T> IdentifierRule getIdentifierRule(T t) {
        IdentifierRule r = this._rules.get(t);
        if (r == null) {
            return this.getDefaultIdentifierRule();
        }
        return r;
    }

    public <T> Map<T, IdentifierRule> getIdentifierRules() {
        return this._rules;
    }

    public String getTrailingDelimiter() {
        return "`";
    }

    public String getSchemaCase() {
        return "upper";
    }

    public boolean getSupportsDelimitedIdentifiers() {
        return true;
    }

    public String getConversionKey() {
        return this.conversionKey;
    }
}

