/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf.test;

import org.apache.openjpa.lib.conf.PluginListValue;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.conf.StringValue;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.test.AbstractTestCase;
import org.junit.Assert;
import org.junit.Test;

public class TestPluginValue
extends AbstractTestCase {
    @Test
    public void testDefault() {
        this.defaultTest((Value)new StringValue("testKey"));
        this.defaultTest((Value)new PluginValue("testKey", true));
        this.defaultTest((Value)new PluginListValue("testKey"));
        this.pluginDefaultTest(new PluginValue("testKey", true));
    }

    private void defaultTest(Value val) {
        Assert.assertNull((Object)val.getString());
        val.setString("foo");
        Assert.assertEquals((Object)"foo", (Object)val.getString());
        val.setString(null);
        Assert.assertNull((Object)val.getString());
        val.setDefault("xxx");
        val.setString(null);
        Assert.assertEquals((Object)"xxx", (Object)val.getString());
        val.setString("bar");
        Assert.assertEquals((Object)"bar", (Object)val.getString());
        val.setString(" ");
        Assert.assertEquals((Object)"xxx", (Object)val.getString());
        val.setString("yyy");
        Assert.assertEquals((Object)"yyy", (Object)val.getString());
        val.setString(null);
        Assert.assertEquals((Object)"xxx", (Object)val.getString());
    }

    private void pluginDefaultTest(PluginValue val) {
        val.setDefault("foo");
        val.setString("x=y");
        Assert.assertEquals((Object)"foo(x=y)", (Object)val.getString());
        val.set((Object)new Integer(1));
        Assert.assertEquals((Object)"java.lang.Integer", (Object)val.getString());
        Assert.assertEquals((Object)new Integer(1), (Object)val.get());
        val.set(null);
        Assert.assertEquals((Object)"foo", (Object)val.getString());
        Assert.assertEquals(null, (Object)val.get());
    }

    @Test
    public void testAlias() {
        this.aliasTest((Value)new StringValue("testKey"));
        this.aliasTest((Value)new PluginValue("testKey", true));
        this.aliasTest((Value)new PluginListValue("testKey"));
        this.emptyAliasTest((Value)new StringValue("testKey"));
        this.emptyAliasTest((Value)new StringValue("testKey"));
        this.pluginAliasTest((Value)new PluginValue("testKey", true));
        this.pluginAliasTest((Value)new PluginListValue("testKey"));
        this.pluginListAliasTest((Value)new PluginListValue("testKey"));
    }

    private void aliasTest(Value val) {
        val.setAliases(new String[]{"foo", "bar"});
        val.setDefault("bar");
        Assert.assertEquals((Object)"bar", (Object)val.getDefault());
        val.setString(null);
        Assert.assertEquals((Object)"foo", (Object)val.getString());
        val.setDefault("xxx");
        val.setString(null);
        Assert.assertEquals((Object)"xxx", (Object)val.getString());
        val.setDefault("bar");
        val.setString(null);
        Assert.assertEquals((Object)"foo", (Object)val.getString());
        val.setString("yyy");
        val.setAliases(new String[]{"xxx", "yyy"});
        Assert.assertEquals((Object)"xxx", (Object)val.getString());
    }

    private void emptyAliasTest(Value val) {
        val.setDefault("foo");
        val.setAliases(new String[]{"false", null});
        val.setString("false");
        Assert.assertEquals((Object)"false", (Object)val.getString());
        val.setString(null);
        Assert.assertEquals((Object)"foo", (Object)val.getString());
    }

    private void pluginAliasTest(Value val) {
        val.setString("foo(biz=baz)");
        Assert.assertEquals((Object)"foo(biz=baz)", (Object)val.getString());
        val.setAliases(new String[]{"xxx", "foo"});
        Assert.assertEquals((Object)"xxx(biz=baz)", (Object)val.getString());
    }

    private void pluginListAliasTest(Value val) {
        val.setString("foo(biz=baz), foo(a=b),xxx, foo, yyy");
        Assert.assertEquals((Object)"foo(biz=baz), foo(a=b), xxx, foo, yyy", (Object)val.getString());
        val.setAliases(new String[]{"bar", "foo"});
        Assert.assertEquals((Object)"bar(biz=baz), bar(a=b), xxx, bar, yyy", (Object)val.getString());
        val.setAliases(new String[]{"none", null});
        val.setString("none");
        Assert.assertTrue((((PluginListValue)val).getClassNames().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPluginListParsing() {
        PluginListValue val = new PluginListValue("testKey");
        Assert.assertEquals((long)0L, (long)val.getClassNames().length);
        val.setString("foo");
        Assert.assertEquals((long)1L, (long)val.getClassNames().length);
        Assert.assertEquals((Object)"foo", (Object)val.getClassNames()[0]);
        Assert.assertNull((Object)val.getProperties()[0]);
        val.setString("foo()");
        Assert.assertEquals((long)1L, (long)val.getClassNames().length);
        Assert.assertEquals((Object)"foo", (Object)val.getClassNames()[0]);
        Assert.assertNull((Object)val.getProperties()[0]);
        val.setString("foo(a=b)");
        Assert.assertEquals((long)1L, (long)val.getClassNames().length);
        Assert.assertEquals((Object)"foo", (Object)val.getClassNames()[0]);
        Assert.assertEquals((Object)"a=b", (Object)val.getProperties()[0]);
        val.setString("foo(a=b, c=\"d,e f\", g=\"h\")");
        Assert.assertEquals((long)1L, (long)val.getClassNames().length);
        Assert.assertEquals((Object)"foo", (Object)val.getClassNames()[0]);
        Assert.assertEquals((Object)"a=b, c=\"d,e f\", g=\"h\"", (Object)val.getProperties()[0]);
        val.setString("foo(a=b, c=\"d,e f\"), bar, biz(a=c, d=g), baz()");
        Assert.assertEquals((long)4L, (long)val.getClassNames().length);
        Assert.assertEquals((Object)"foo", (Object)val.getClassNames()[0]);
        Assert.assertEquals((Object)"a=b, c=\"d,e f\"", (Object)val.getProperties()[0]);
        Assert.assertEquals((Object)"bar", (Object)val.getClassNames()[1]);
        Assert.assertNull((Object)val.getProperties()[1]);
        Assert.assertEquals((Object)"biz", (Object)val.getClassNames()[2]);
        Assert.assertEquals((Object)"a=c, d=g", (Object)val.getProperties()[2]);
        Assert.assertEquals((Object)"baz", (Object)val.getClassNames()[3]);
        Assert.assertNull((Object)val.getProperties()[3]);
    }

    public String getTestKey() {
        return null;
    }

    public void setTestKey(String key) {
    }
}

