/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import org.apache.openjpa.lib.conf.AbstractProductDerivation;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.MapConfigurationProvider;

public class ConfigurationTestProductDerivation
extends AbstractProductDerivation {
    public static boolean closed = false;

    public int getType() {
        return 100;
    }

    public void beforeConfigurationClose(Configuration conf) {
        closed = true;
    }

    public ConfigurationProvider loadGlobals(ClassLoader loader) throws IOException {
        return this.load(null, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationProvider load(String rsrc, ClassLoader loader) throws IOException {
        if (rsrc == null) {
            rsrc = System.getProperty("openjpatest.properties");
        }
        if (rsrc == null || !rsrc.endsWith(".properties")) {
            return null;
        }
        URL url = this.findResource(rsrc, loader);
        if (url == null) {
            throw new MissingResourceException(rsrc, ((Object)((Object)this)).getClass().getName(), rsrc);
        }
        InputStream in = url.openStream();
        Properties props = new Properties();
        if (in != null) {
            try {
                props.load(in);
                MapConfigurationProvider mapConfigurationProvider = new MapConfigurationProvider((Map)props);
                return mapConfigurationProvider;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private URL findResource(String rsrc, ClassLoader loader) throws IOException {
        if (loader != null) {
            return loader.getResource(rsrc);
        }
        URL url = null;
        loader = ((Object)((Object)this)).getClass().getClassLoader();
        if (loader != null) {
            url = loader.getResource(rsrc);
        }
        if (url == null && (loader = Thread.currentThread().getContextClassLoader()) != null) {
            url = loader.getResource(rsrc);
        }
        if (url == null && (loader = ClassLoader.getSystemClassLoader()) != null) {
            url = loader.getResource(rsrc);
        }
        return url;
    }
}

