/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import org.apache.openjpa.lib.conf.Value;
import org.junit.Assert;
import org.junit.Test;

public class TestValue {
    @Test
    public void testSetAliasesByValue() {
        String alias = "alias";
        String aName = "Johnny";
        String bName = "Pete";
        String[] aStrings = new String[]{alias, aName};
        SimpleValue sValue = new SimpleValue();
        sValue.setAliases(aStrings);
        sValue.setAlias(alias, bName);
        Assert.assertEquals((String)"Did not set the new alias", (Object)bName, (Object)sValue.getAliases()[1]);
        Assert.assertEquals((String)"Array of aliases not set by value", (Object)aName, (Object)aStrings[1]);
    }

    @Test
    public void testEquivalentValueCanBeSet() {
        SimpleValue v = new SimpleValue();
        v.setProperty("main");
        v.addEquivalentKey("eqivalent1");
        v.addEquivalentKey("eqivalent2");
        Assert.assertEquals((long)2L, (long)v.getEquivalentKeys().size());
        Assert.assertEquals((long)3L, (long)v.getPropertyKeys().size());
        Assert.assertEquals((Object)v.getProperty(), v.getPropertyKeys().get(0));
        Assert.assertTrue((boolean)v.matches("main"));
        Assert.assertTrue((boolean)v.matches("eqivalent1"));
        Assert.assertTrue((boolean)v.matches("eqivalent2"));
        Assert.assertFalse((boolean)v.matches("eqivalent3"));
    }

    @Test
    public void testEquivalentValuesAreUnmodifable() {
        SimpleValue v = new SimpleValue();
        v.setProperty("main");
        v.addEquivalentKey("eqivalent1");
        v.addEquivalentKey("eqivalent2");
        try {
            v.getPropertyKeys().add("extra");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail();
        }
        try {
            v.getEquivalentKeys().add("impossible");
            Assert.fail();
        }
        catch (UnsupportedOperationException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail();
        }
    }

    private static class SimpleValue
    extends Value {
        private SimpleValue() {
        }

        protected String getInternalString() {
            return null;
        }

        public Class getValueType() {
            return null;
        }

        protected void setInternalObject(Object obj) {
        }

        protected void setInternalString(String str) {
        }

        public Object get() {
            return null;
        }
    }
}

