/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.openjpa.lib.meta.MetaDataFilter;
import org.apache.openjpa.lib.meta.MetaDataIterator;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;

public class FileMetaDataIterator
implements MetaDataIterator {
    private static final long SCAN_LIMIT = 100000L;
    private static final Localizer _loc = Localizer.forPackage(FileMetaDataIterator.class);
    private final Iterator<File> _itr;
    private File _file = null;

    public FileMetaDataIterator(File file) {
        this._itr = Collections.singleton(file).iterator();
    }

    public FileMetaDataIterator(File dir, MetaDataFilter filter) throws IOException {
        if (dir == null) {
            this._itr = null;
        } else {
            ArrayList<File> metas = new ArrayList<File>();
            FileResource rsrc = filter == null ? null : new FileResource();
            this.scan(dir, filter, rsrc, metas, 0);
            this._itr = metas.iterator();
        }
    }

    private int scan(File file, MetaDataFilter filter, FileResource rsrc, Collection<File> metas, int scanned) throws IOException {
        if ((long)scanned > 100000L) {
            throw new IllegalStateException(_loc.get("too-many-files", String.valueOf(100000L)).getMessage());
        }
        ++scanned;
        if (filter == null) {
            metas.add(file);
        } else {
            rsrc.setFile(file);
            if (filter.matches(rsrc)) {
                metas.add(file);
            } else {
                File[] files = AccessController.doPrivileged(J2DoPrivHelper.listFilesAction(file));
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        scanned = this.scan(files[i], filter, rsrc, metas, scanned);
                    }
                }
            }
        }
        return scanned;
    }

    @Override
    public boolean hasNext() {
        return this._itr != null && this._itr.hasNext();
    }

    @Override
    public URL next() throws IOException {
        if (this._itr == null) {
            throw new NoSuchElementException();
        }
        this._file = this._itr.next();
        try {
            File f = AccessController.doPrivileged(J2DoPrivHelper.getAbsoluteFileAction(this._file));
            return AccessController.doPrivileged(J2DoPrivHelper.toURLAction(f));
        }
        catch (PrivilegedActionException pae) {
            throw (MalformedURLException)pae.getException();
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this._file == null) {
            throw new IllegalStateException();
        }
        FileInputStream fis = null;
        try {
            fis = AccessController.doPrivileged(J2DoPrivHelper.newFileInputStreamAction(this._file));
            return fis;
        }
        catch (PrivilegedActionException pae) {
            throw (FileNotFoundException)pae.getException();
        }
    }

    @Override
    public File getFile() {
        if (this._file == null) {
            throw new IllegalStateException();
        }
        return this._file;
    }

    @Override
    public void close() {
    }

    private static class FileResource
    implements MetaDataFilter.Resource {
        private File _file = null;

        private FileResource() {
        }

        public void setFile(File file) {
            this._file = file;
        }

        @Override
        public String getName() {
            return this._file.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getContent() throws IOException {
            long len = AccessController.doPrivileged(J2DoPrivHelper.lengthAction(this._file));
            FileInputStream fin = null;
            try {
                fin = AccessController.doPrivileged(J2DoPrivHelper.newFileInputStreamAction(this._file));
            }
            catch (PrivilegedActionException pae) {
                throw (FileNotFoundException)pae.getException();
            }
            try {
                byte[] content;
                if (len <= 0L || len > Integer.MAX_VALUE) {
                    int r;
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    byte[] buf = new byte[1024];
                    while ((r = fin.read(buf)) != -1) {
                        bout.write(buf, 0, r);
                    }
                    content = bout.toByteArray();
                } else {
                    int r;
                    content = new byte[(int)len];
                    for (int o = 0; o < content.length && (r = fin.read(content, o, content.length - o)) != -1; o += r) {
                    }
                }
                byte[] byArray = content;
                return byArray;
            }
            finally {
                try {
                    fin.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

