/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.event.kubernetes;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodStatusBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.server.mock.KubernetesServer;
import java.lang.reflect.Field;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.openjpa.event.TCPRemoteCommitProvider;
import org.apache.openjpa.event.kubernetes.KubernetesTCPRemoteCommitProvider;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.SLF4JLogFactory;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JUnitRuleMockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class KubernetesTCPRemoteCommitProviderTest {
    private static final String NAMESPACE = "ns1";
    private static final String LABEL = "testKey";
    @Rule
    public JUnitRuleMockery context = new JUnitRuleMockery();
    @Rule
    public KubernetesServer server = new KubernetesServer(true, true);
    private Pod pod1;
    private Pod pod2;
    private Pod pod3;
    private Pod pod4;

    @Before
    public void setupKubernetes() {
        NamespacedKubernetesClient client = this.server.getClient();
        this.pod1 = ((PodBuilder)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod1")).addToLabels(LABEL, "value1")).endMetadata()).withStatus(((PodStatusBuilder)new PodStatusBuilder().withPodIP("1.1.1.1")).build())).build();
        ((NonNamespaceOperation)client.pods().inNamespace(NAMESPACE)).create((Object[])new Pod[]{this.pod1});
        this.pod2 = ((PodBuilder)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod2")).addToLabels(LABEL, "value2")).endMetadata()).withStatus(((PodStatusBuilder)new PodStatusBuilder().withPodIP("2.2.2.2")).build())).build();
        ((NonNamespaceOperation)client.pods().inNamespace(NAMESPACE)).create((Object[])new Pod[]{this.pod2});
        this.pod3 = ((PodBuilder)((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod3")).endMetadata()).withStatus(((PodStatusBuilder)new PodStatusBuilder().withPodIP("3.3.3.3")).build())).build();
        ((NonNamespaceOperation)client.pods().inNamespace("ns2")).create((Object[])new Pod[]{this.pod3});
        this.pod4 = ((PodBuilder)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withName("pod4")).addToLabels("other", "value1")).endMetadata()).withStatus(((PodStatusBuilder)new PodStatusBuilder().withPodIP("4.4.4.4")).build())).build();
        ((NonNamespaceOperation)client.pods().inNamespace(NAMESPACE)).create((Object[])new Pod[]{this.pod4});
        PodList podList = (PodList)((FilterWatchListDeletable)((NonNamespaceOperation)client.pods().inNamespace(NAMESPACE)).withLabel(LABEL)).list();
        Assert.assertNotNull((Object)podList);
        Assert.assertEquals((long)2L, (long)podList.getItems().size());
        Assert.assertTrue((boolean)podList.getItems().contains(this.pod1));
        Assert.assertTrue((boolean)podList.getItems().contains(this.pod2));
    }

    private List<String> getAddresses(KubernetesTCPRemoteCommitProvider rcp) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field _addresses = TCPRemoteCommitProvider.class.getDeclaredField("_addresses");
        _addresses.setAccessible(true);
        return new ArrayList((List)_addresses.get(rcp)).stream().map(ReflectionToStringBuilder::toString).map(address -> StringUtils.substringAfter((String)address, (String)"_address=/")).map(address -> StringUtils.substringBefore((String)address, (String)",")).collect(Collectors.toList());
    }

    @Test
    public void addresses() throws UnknownHostException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, InterruptedException {
        KubernetesTCPRemoteCommitProvider rcp = new KubernetesTCPRemoteCommitProvider(){

            protected KubernetesClient kubernetesClient() throws KubernetesClientException {
                return KubernetesTCPRemoteCommitProviderTest.this.server.getClient();
            }
        };
        rcp.setNamespace(NAMESPACE);
        rcp.setLabel(LABEL);
        rcp.setCacheDurationMillis(500);
        final Configuration conf = (Configuration)this.context.mock(Configuration.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Configuration)this.oneOf(conf)).getLog((String)this.with(2.any(String.class)));
                this.will(2.returnValue((Object)new SLF4JLogFactory().getLog("")));
            }
        });
        rcp.setConfiguration(conf);
        rcp.endConfiguration();
        List<String> addresses = this.getAddresses(rcp);
        Assert.assertEquals((long)2L, (long)addresses.size());
        Assert.assertTrue((boolean)addresses.contains(this.pod1.getStatus().getPodIP()));
        Assert.assertTrue((boolean)addresses.contains(this.pod2.getStatus().getPodIP()));
        Thread.sleep(500L);
        addresses = this.getAddresses(rcp);
        Assert.assertEquals((long)2L, (long)addresses.size());
        Assert.assertTrue((boolean)addresses.contains(this.pod1.getStatus().getPodIP()));
        Assert.assertTrue((boolean)addresses.contains(this.pod2.getStatus().getPodIP()));
    }
}

