/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import com.meterware.httpunit.HttpException;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.ServletRunner;
import com.meterware.servletunit.ServletUnitClient;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import junit.framework.TestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestJEST
extends TestCase {
    private static ServletRunner container;
    private static String baseURI;
    private static String DEFAULT_WEB_XML;
    private static String DEFAULT_BASE_URI;
    private static DocumentBuilder _xmlParser;
    private static XPathFactory _xpathFactory;

    protected void setUp() throws Exception {
        super.setUp();
        if (container == null) {
            String resource = System.getProperty("jest.web.xml", DEFAULT_WEB_XML);
            System.err.println("Starting Servlet Container from " + resource);
            InputStream wdesc = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            TestJEST.assertNotNull((String)(resource + " not loadable at thread context classpath"), (Object)wdesc);
            container = new ServletRunner(wdesc);
            TestJEST.assertNotNull((String)"Servlet engine could not be started", (Object)container);
            baseURI = System.getProperty("jest.base.uri", DEFAULT_BASE_URI);
            System.err.println("Base URI  " + baseURI);
            _xmlParser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            _xpathFactory = XPathFactory.newInstance();
        }
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)true);
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        HttpUnitOptions.setExceptionsThrownOnScriptError((boolean)false);
    }

    public void testBadURL() throws Exception {
        this.assertError(404, this.uri("some+bad+url"));
    }

    public void testDomain() throws Exception {
        WebResponse response = this.getResponse(this.uri("domain"));
        TestJEST.assertNotNull((Object)response);
        System.err.println(response.getText());
        TestJEST.assertEquals((String)"text/xml", (String)response.getContentType());
        Document doc = _xmlParser.parse(response.getInputStream());
        TestJEST.assertNotNull((Object)doc);
        Node metamodel = this.getNode(doc, "/metamodel");
        TestJEST.assertNotNull((Object)metamodel);
        NodeList entities = this.getNodes(doc, "/metamodel/entity");
        TestJEST.assertEquals((int)2, (int)entities.getLength());
    }

    WebResponse getResponse(String url) {
        try {
            ServletUnitClient client = container.newClient();
            return client.getResponse(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJEST.fail((String)("Failed to get response on " + url + ". Error: " + e.getMessage()));
            return null;
        }
    }

    protected String uri(String path) {
        return baseURI + '/' + path;
    }

    void assertError(int error, String url) throws Exception {
        ServletUnitClient client = container.newClient();
        try {
            client.getResponse(url);
            TestJEST.fail((String)("expected HTTP error " + error + " on " + url));
        }
        catch (HttpException e) {
            TestJEST.assertEquals((String)("Unexpected HTTP Error code for " + url), (int)error, (int)e.getResponseCode());
        }
    }

    NodeList getNodes(Document doc, String path) throws Exception {
        XPath xpath = _xpathFactory.newXPath();
        Object nodes = xpath.compile(path).evaluate(doc, XPathConstants.NODESET);
        TestJEST.assertTrue((boolean)(nodes instanceof NodeList));
        return (NodeList)nodes;
    }

    Node getNode(Document doc, String path) throws Exception {
        XPath xpath = _xpathFactory.newXPath();
        Object node = xpath.compile(path).evaluate(doc, XPathConstants.NODE);
        TestJEST.assertTrue((boolean)(node instanceof Node));
        return (Node)node;
    }

    static {
        DEFAULT_WEB_XML = "WEB-INF/web.xml";
        DEFAULT_BASE_URI = "http://localhost/jest";
    }
}

