/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.Actor;
import demo.Movie;
import java.util.Date;
import javax.persistence.EntityManager;

public class DataLoader {
    public static Object[][] ACTOR_DATA = new Object[][]{{"m1", "Robert", "Redford", Actor.Gender.Male, new Date(50, 1, 12)}, {"m2", "Robert", "De Niro", Actor.Gender.Male, new Date(40, 4, 14)}, {"m3", "Al", "Pacino", Actor.Gender.Male, new Date(50, 1, 12)}, {"m4", "Jack", "Nichelson", Actor.Gender.Male, new Date(40, 4, 14)}, {"m5", "Clint", "Eastwood", Actor.Gender.Male, new Date(50, 1, 12)}, {"f1", "Meryl", "Streep", Actor.Gender.Female, new Date(40, 4, 14)}, {"f2", "Fay", "Dunaway", Actor.Gender.Female, new Date(50, 1, 12)}, {"f3", "Jodie", "Foster", Actor.Gender.Female, new Date(40, 4, 14)}, {"f4", "Diane", "Keaton", Actor.Gender.Female, new Date(50, 1, 12)}, {"f5", "Catherine", "Hepburn", Actor.Gender.Female, new Date(40, 4, 14)}};
    public static Object[][] MOVIE_DATA = new Object[][]{{"1", "China Town", 1980}, {"2", "Taxi Driver", 1980}, {"3", "Where Eagles Dare", 1980}, {"4", "Godfather", 1980}, {"5", "Horse Whisperer", 1980}};
    public static int[][] MOVIE_ACTORS = new int[][]{{3, 6}, {1, 7}, {4}, {2, 3, 8}, {0}};
    public static int[][] PARTNERS = new int[][]{{3, 6}, {1, 7}, {3, 8}};

    public void populate(EntityManager em) throws Exception {
        Long count = (Long)em.createQuery("select count(m) from Movie m", Long.class).getSingleResult();
        if (count != null && count > 0L) {
            System.err.println("Found " + count + " Movie records in the database");
            return;
        }
        Actor[] actors = this.createActors();
        Movie[] movies = this.createMovies();
        this.linkActorAndMovie(movies, actors);
        this.makePartner(actors);
        em.getTransaction().begin();
        for (Actor a : actors) {
            em.persist((Object)a);
        }
        for (Movie m : movies) {
            em.persist((Object)m);
        }
        em.getTransaction().commit();
    }

    Actor[] createActors() {
        Actor[] actors = new Actor[ACTOR_DATA.length];
        for (int i = 0; i < ACTOR_DATA.length; ++i) {
            Object[] a = ACTOR_DATA[i];
            actors[i] = new Actor((String)a[0], (String)a[1], (String)a[2], (Actor.Gender)((Object)a[3]), (Date)a[4]);
        }
        return actors;
    }

    Movie[] createMovies() {
        Movie[] movies = new Movie[MOVIE_DATA.length];
        for (int i = 0; i < MOVIE_DATA.length; ++i) {
            Object[] m = MOVIE_DATA[i];
            movies[i] = new Movie((String)m[0], (String)m[1], (Integer)m[2]);
        }
        return movies;
    }

    void linkActorAndMovie(Movie[] movies, Actor[] actors) {
        for (int i = 0; i < MOVIE_ACTORS.length; ++i) {
            int[] roles = MOVIE_ACTORS[i];
            Movie m = movies[i];
            for (int j = 0; j < roles.length; ++j) {
                Actor a = actors[roles[j]];
                a.addMovie(m);
                m.addActor(a);
            }
        }
    }

    void makePartner(Actor[] actors) {
        for (int i = 0; i < PARTNERS.length; ++i) {
            int[] partners = PARTNERS[i];
            Actor a1 = actors[partners[0]];
            Actor a2 = actors[partners[1]];
            a1.setPartner(a2);
            a2.setPartner(a1);
        }
    }
}

