/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql.identifier;

import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.junit.Assert;
import org.junit.Test;

public class TestDBIdentifiers {
    @Test
    public void testSchemaOps() {
        QualifiedDBIdentifier p1 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"my.schema")});
        DBIdentifier s1 = DBIdentifier.newSchema((String)"my.schema");
        Assert.assertTrue((boolean)DBIdentifier.equal((DBIdentifier)p1, (DBIdentifier)s1));
        Assert.assertEquals((Object)"\"my.schema\"", (Object)p1.getName());
        Assert.assertEquals((Object)"\"my.schema\"", (Object)s1.getName());
        Assert.assertEquals((Object)p1.getType(), (Object)DBIdentifier.DBIdentifierType.SCHEMA);
        Assert.assertEquals((Object)s1.getType(), (Object)DBIdentifier.DBIdentifierType.SCHEMA);
        Assert.assertFalse((boolean)(s1 instanceof QualifiedDBIdentifier));
        QualifiedDBIdentifier p2 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"SCHEMA")});
        DBIdentifier s2 = DBIdentifier.newSchema((String)"SCHEMA2");
        Assert.assertFalse((boolean)DBIdentifier.equal((DBIdentifier)p2, (DBIdentifier)s2));
        Assert.assertEquals((Object)"SCHEMA", (Object)p2.getName());
        Assert.assertEquals((Object)"SCHEMA2", (Object)s2.getName());
        Assert.assertEquals((Object)p2.getType(), (Object)DBIdentifier.DBIdentifierType.SCHEMA);
        Assert.assertEquals((Object)s2.getType(), (Object)DBIdentifier.DBIdentifierType.SCHEMA);
        Assert.assertTrue((boolean)(p2 instanceof QualifiedDBIdentifier));
        Assert.assertFalse((boolean)(s2 instanceof QualifiedDBIdentifier));
    }

    @Test
    public void testTableOps() {
        DBIdentifier name = DBIdentifier.newTable((String)"table");
        Assert.assertEquals((Object)"table", (Object)name.getName());
        name = DBIdentifier.newTable((String)"my table");
        Assert.assertEquals((Object)"\"my table\"", (Object)name.getName());
        DBIdentifier[] names = QualifiedDBIdentifier.splitPath((DBIdentifier)name);
        this.assertTableEquals(names, null, "\"my table\"");
        name = DBIdentifier.newTable((String)"\"my.schema\".\"my.table\"");
        Assert.assertEquals((Object)"\"my.schema\".\"my.table\"", (Object)name.getName());
        names = QualifiedDBIdentifier.splitPath((DBIdentifier)name);
        this.assertTableEquals(names, "\"my.schema\"", "\"my.table\"");
        name = DBIdentifier.newTable((String)"my_schema.my_table");
        Assert.assertEquals((Object)"my_schema.my_table", (Object)name.getName());
        names = QualifiedDBIdentifier.splitPath((DBIdentifier)name);
        this.assertTableEquals(names, "my_schema", "my_table");
        DBIdentifier tName = DBIdentifier.newTable((String)"my table");
        DBIdentifier sName = DBIdentifier.newSchema((String)"my schema");
        QualifiedDBIdentifier path = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{sName, tName});
        Assert.assertEquals((Object)"\"my schema\".\"my table\"", (Object)path.getName());
        Assert.assertEquals((Object)tName.getName(), (Object)path.getBaseName());
        Assert.assertEquals((Object)sName.getName(), (Object)path.getSchemaName().getName());
        tName = DBIdentifier.newTable((String)"my_table");
        sName = DBIdentifier.newSchema((String)"my_schema");
        path = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{sName, tName});
        Assert.assertEquals((Object)"my_schema.my_table", (Object)path.getName());
        Assert.assertEquals((Object)tName.getName(), (Object)path.getBaseName());
        Assert.assertEquals((Object)sName.getName(), (Object)path.getSchemaName().getName());
        QualifiedDBIdentifier p1 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"schema"), DBIdentifier.newTable((String)"my table")});
        QualifiedDBIdentifier p2 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"schema"), DBIdentifier.newTable((String)"\"my table\"")});
        QualifiedDBIdentifier p3 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"schema"), DBIdentifier.newTable((String)"my_table")});
        Assert.assertTrue((boolean)p1.equals((Object)p2));
        Assert.assertFalse((boolean)p1.equals((Object)p3));
        Assert.assertFalse((boolean)p2.equals((Object)p3));
        Assert.assertFalse((boolean)p1.equals(null));
        Assert.assertFalse((boolean)p1.equals((Object)DBIdentifier.NULL));
    }

    @Test
    public void testColumnOps() {
        DBIdentifier c0 = DBIdentifier.newColumn((String)"\"col.1\"");
        Assert.assertEquals((Object)"\"col.1\"", (Object)c0.getName());
        Assert.assertTrue((boolean)(c0 instanceof QualifiedDBIdentifier));
        Assert.assertEquals((Object)c0.getType(), (Object)DBIdentifier.DBIdentifierType.COLUMN);
        DBIdentifier c1 = DBIdentifier.newColumn((String)"column 1");
        DBIdentifier t1 = DBIdentifier.newTable((String)"table");
        DBIdentifier s1 = DBIdentifier.newSchema((String)"\"my schema\"");
        QualifiedDBIdentifier p1 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{s1, t1, c1});
        Assert.assertEquals((Object)"\"my schema\".table.\"column 1\"", (Object)p1.getName());
        DBIdentifier c2 = DBIdentifier.newColumn((String)"\"column_2\"");
        DBIdentifier t2 = DBIdentifier.newTable((String)"table.2", (boolean)true);
        QualifiedDBIdentifier p2 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{t2, c2});
        Assert.assertEquals((Object)"\"table.2\".\"column_2\"", (Object)p2.getName());
    }

    @Test
    public void testDBIdentifierOps() {
        DBIdentifier n1 = DBIdentifier.newColumn((String)"abcdefgh");
        n1 = DBIdentifier.truncate((DBIdentifier)n1, (int)6);
        Assert.assertEquals((Object)"ab", (Object)n1.getName());
        DBIdentifier n2 = DBIdentifier.newColumn((String)"\"abcd efgh\"");
        n2 = DBIdentifier.truncate((DBIdentifier)n2, (int)3);
        Assert.assertEquals((Object)"\"abcd e\"", (Object)n2.getName());
        DBIdentifier n3 = DBIdentifier.newColumn((String)"abcdefgh");
        n3 = DBIdentifier.append((DBIdentifier)n3, (String)"ijk");
        Assert.assertEquals((Object)"abcdefghijk", (Object)n3.getName());
        DBIdentifier n4 = DBIdentifier.newColumn((String)"\"abcd efgh\"");
        n4 = DBIdentifier.append((DBIdentifier)n4, (String)"i k");
        Assert.assertEquals((Object)"\"abcd efghi k\"", (Object)n4.getName());
        DBIdentifier n5 = DBIdentifier.newColumn((String)"\"abcd efgh\"");
        n5 = DBIdentifier.append((DBIdentifier)n5, (String)"\"i k\"");
        Assert.assertEquals((Object)"\"abcd efghi k\"", (Object)n5.getName());
        DBIdentifier cn1 = DBIdentifier.newTable((String)"sch.tbl");
        DBIdentifier cn2 = cn1.clone();
        Assert.assertFalse((cn1 == cn2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)cn1.getName(), (Object)cn2.getName());
        Assert.assertEquals((Object)cn1, (Object)cn2);
        DBIdentifier tbl = DBIdentifier.newTable((String)"tbl");
        DBIdentifier sch = DBIdentifier.newSchema((String)"sch");
        QualifiedDBIdentifier path = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{sch, tbl});
        QualifiedDBIdentifier path2 = path.clone();
        Assert.assertEquals((Object)tbl.getName(), (Object)path.getBaseName());
        Assert.assertEquals((Object)sch, (Object)path.getSchemaName());
        Assert.assertEquals((Object)tbl.getName(), (Object)path2.getBaseName());
        Assert.assertEquals((Object)sch, (Object)path2.getSchemaName());
        DBIdentifier tbl2 = DBIdentifier.newTable((String)"tbl2");
        DBIdentifier sch2 = DBIdentifier.newSchema((String)"sch2");
        DBIdentifier col = DBIdentifier.newColumn((String)"col");
        QualifiedDBIdentifier cpath = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{sch2, tbl2, col});
        QualifiedDBIdentifier cpath2 = cpath.clone();
        Assert.assertEquals((Object)col.getName(), (Object)cpath2.getBaseName());
        Assert.assertEquals((Object)sch2, (Object)cpath2.getSchemaName());
        Assert.assertEquals((Object)tbl2, (Object)cpath2.getObjectTableName());
        DBIdentifier dName = DBIdentifier.newColumn((String)"\"ITEMNAME\"", (boolean)true);
        Assert.assertEquals((Object)"\"ITEMNAME\"", (Object)dName.getName());
    }

    @Test
    public void testPathOps() {
        QualifiedDBIdentifier p1 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"MyTable"), DBIdentifier.newColumn((String)"mycol")});
        QualifiedDBIdentifier p2 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"MYTABLE"), DBIdentifier.newColumn((String)"MYCOL")});
        Assert.assertTrue((boolean)DBIdentifier.equal((DBIdentifier)p1, (DBIdentifier)p1));
        QualifiedDBIdentifier p3 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"\"MyTable\""), DBIdentifier.newColumn((String)"\"mycol\"")});
        QualifiedDBIdentifier p4 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"MYTABLE"), DBIdentifier.newColumn((String)"MYCOL")});
        QualifiedDBIdentifier p5 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"\"MyTable\""), DBIdentifier.newColumn((String)"\"mycol\"")});
        Assert.assertFalse((boolean)DBIdentifier.equal((DBIdentifier)p3, (DBIdentifier)p4));
        Assert.assertTrue((boolean)DBIdentifier.equal((DBIdentifier)p3, (DBIdentifier)p5));
        QualifiedDBIdentifier p6 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"MyTable"), DBIdentifier.newColumn((String)"mycol")});
        DBIdentifier n1 = DBIdentifier.newSchema((String)"Schema_1");
        DBIdentifier n2 = DBIdentifier.newTable((String)"Table_1");
        DBIdentifier n3 = DBIdentifier.newColumn((String)"Column_1");
        p6.setPath(new DBIdentifier[]{n1});
        Assert.assertEquals((Object)"Schema_1", (Object)n1.getName());
        Assert.assertEquals((Object)n1.getType(), (Object)DBIdentifier.DBIdentifierType.SCHEMA);
        p6.setPath(new DBIdentifier[]{n2});
        Assert.assertEquals((Object)"Table_1", (Object)n2.getName());
        Assert.assertEquals((Object)n2.getType(), (Object)DBIdentifier.DBIdentifierType.TABLE);
        p6.setPath(new DBIdentifier[]{n3});
        Assert.assertEquals((Object)"Column_1", (Object)n3.getName());
        Assert.assertEquals((Object)n3.getType(), (Object)DBIdentifier.DBIdentifierType.COLUMN);
        QualifiedDBIdentifier p7 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"MyTable"), DBIdentifier.newColumn((String)"mycol")});
        Assert.assertFalse((boolean)p7.isDelimited());
        QualifiedDBIdentifier p8 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"My Table"), DBIdentifier.newColumn((String)"mycol")});
        Assert.assertFalse((boolean)p8.isDelimited());
        QualifiedDBIdentifier p9 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"My Table"), DBIdentifier.newColumn((String)"my col")});
        Assert.assertTrue((boolean)p9.isDelimited());
        QualifiedDBIdentifier p10 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"\"MyTable\""), DBIdentifier.newColumn((String)"\"my col\"")});
        Assert.assertTrue((boolean)p10.isDelimited());
        QualifiedDBIdentifier p11 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"\"MySchema\""), DBIdentifier.newTable((String)"\"my tbl\"")});
        Assert.assertTrue((boolean)p11.isDelimited());
        QualifiedDBIdentifier p12 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"\"MySchema\""), DBIdentifier.newTable((String)"mytbl"), DBIdentifier.newColumn((String)"\"my col\"")});
        Assert.assertFalse((boolean)p12.isDelimited());
    }

    private void assertTableEquals(DBIdentifier[] names, String schema, String table) {
        Assert.assertNotNull((Object)names);
        Assert.assertEquals((long)(schema == null ? 1 : 2), (long)names.length);
        int idx = 0;
        if (schema != null) {
            Assert.assertEquals((Object)DBIdentifier.DBIdentifierType.SCHEMA, (Object)names[idx].getType());
            Assert.assertEquals((Object)names[idx].getName(), (Object)schema);
            ++idx;
        } else {
            Assert.assertEquals((Object)DBIdentifier.DBIdentifierType.TABLE, (Object)names[idx].getType());
            String path = DBIdentifier.join((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)schema), DBIdentifier.newTable((String)table)});
            Assert.assertEquals((Object)names[idx].getName(), (Object)path);
        }
    }
}

