/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.DBIdentifierUtilImpl;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.util.UserException;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JUnitRuleMockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestDBDictionaryGeneratedSQL {
    @Rule
    public JUnitRuleMockery context = new JUnitRuleMockery();

    @Test
    public void testCreateTableLongNameException() {
        final JDBCConfiguration mockConfiguration = (JDBCConfiguration)this.context.mock(JDBCConfiguration.class);
        final DBIdentifierUtilImpl idImpl = new DBIdentifierUtilImpl();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((JDBCConfiguration)this.allowing(mockConfiguration)).getIdentifierUtilInstance();
                this.will(1.returnValue((Object)idImpl));
                this.allowing(mockConfiguration);
            }
        });
        DBDictionary dict = new DBDictionary();
        dict.setConfiguration((Configuration)mockConfiguration);
        dict.maxTableNameLength = 10;
        Table table = new Table();
        table.setIdentifier(DBIdentifier.newTable((String)"NameIsTooLong"));
        try {
            dict.getCreateTableSQL(table);
            Assert.fail((String)"Expected a UserException");
        }
        catch (UserException ue) {
            Assert.assertTrue((boolean)ue.getMessage().contains("Table name \"NameIsTooLong\""));
        }
    }

    @Test
    public void testThrowsExceptionWithSchemaSet() {
        final JDBCConfiguration mockConfiguration = (JDBCConfiguration)this.context.mock(JDBCConfiguration.class);
        final DBIdentifierUtilImpl idImpl = new DBIdentifierUtilImpl();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((JDBCConfiguration)this.allowing(mockConfiguration)).getIdentifierUtilInstance();
                this.will(2.returnValue((Object)idImpl));
                this.allowing(mockConfiguration);
            }
        });
        DBDictionary dict = new DBDictionary();
        dict.setConfiguration((Configuration)mockConfiguration);
        dict.maxTableNameLength = 10;
        Table table = new Table();
        table.setIdentifier(DBIdentifier.newTable((String)"NameIsTooLong"));
        table.setSchemaIdentifier(DBIdentifier.newSchema((String)"IAmASchema"));
        try {
            dict.getCreateTableSQL(table);
            Assert.fail((String)"Expected a UserException");
        }
        catch (UserException ue) {
            Assert.assertTrue((boolean)ue.getMessage().contains("Table name \"IAmASchema.NameIsTooLong\""));
        }
    }

    @Test
    public void testSchemaNameIsNotConsidered() {
        final JDBCConfiguration mockConfiguration = (JDBCConfiguration)this.context.mock(JDBCConfiguration.class);
        final DBIdentifierUtilImpl idImpl = new DBIdentifierUtilImpl();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((JDBCConfiguration)this.allowing(mockConfiguration)).getIdentifierUtilInstance();
                this.will(3.returnValue((Object)idImpl));
                this.allowing(mockConfiguration);
            }
        });
        DBDictionary dict = new DBDictionary();
        dict.setConfiguration((Configuration)mockConfiguration);
        dict.maxTableNameLength = 12;
        Table table = new Table();
        table.setIdentifier(DBIdentifier.newTable((String)"NameIsRight"));
        table.setSchemaIdentifier(DBIdentifier.newSchema((String)"IAmASchema"));
        String[] sqls = dict.getCreateTableSQL(table);
        Assert.assertEquals((long)1L, (long)sqls.length);
        Assert.assertTrue((boolean)sqls[0].contains("NameIsRight"));
        Assert.assertTrue((boolean)sqls[0].contains("IAmASchema"));
    }

    @Test
    public void testOverrideProperty() {
        final JDBCConfiguration mockConfiguration = (JDBCConfiguration)this.context.mock(JDBCConfiguration.class);
        final DBIdentifierUtilImpl idImpl = new DBIdentifierUtilImpl();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((JDBCConfiguration)this.allowing(mockConfiguration)).getIdentifierUtilInstance();
                this.will(4.returnValue((Object)idImpl));
                this.allowing(mockConfiguration);
            }
        });
        DBDictionary dict = new DBDictionary();
        dict.setConfiguration((Configuration)mockConfiguration);
        dict.tableLengthIncludesSchema = true;
        dict.maxTableNameLength = 12;
        Table table = new Table();
        table.setIdentifier(DBIdentifier.newTable((String)"NameIsTooLong"));
        table.setSchemaIdentifier(DBIdentifier.newSchema((String)"IAmASchema"));
        try {
            dict.getCreateTableSQL(table);
            Assert.fail((String)"Expected a UserException");
        }
        catch (UserException ue) {
            Assert.assertTrue((boolean)ue.getMessage().contains("Table name \"IAmASchema.NameIsTooLong\""));
        }
    }

    @Test
    public void testOverridePropertyShortName() {
        final JDBCConfiguration mockConfiguration = (JDBCConfiguration)this.context.mock(JDBCConfiguration.class);
        final DBIdentifierUtilImpl idImpl = new DBIdentifierUtilImpl();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((JDBCConfiguration)this.allowing(mockConfiguration)).getIdentifierUtilInstance();
                this.will(5.returnValue((Object)idImpl));
                this.allowing(mockConfiguration);
            }
        });
        DBDictionary dict = new DBDictionary();
        dict.setConfiguration((Configuration)mockConfiguration);
        dict.tableLengthIncludesSchema = true;
        dict.maxTableNameLength = 18;
        Table table = new Table();
        table.setIdentifier(DBIdentifier.newTable((String)"NameIsRight"));
        table.setSchemaIdentifier(DBIdentifier.newSchema((String)"schema"));
        String[] sqls = dict.getCreateTableSQL(table);
        Assert.assertEquals((long)1L, (long)sqls.length);
        Assert.assertTrue((boolean)sqls[0].contains("NameIsRight"));
        Assert.assertTrue((boolean)sqls[0].contains("schema"));
    }
}

