/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.conf.Configuration;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JUnitRuleMockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TestDB2Dictionary {
    @Rule
    public JUnitRuleMockery context = new JUnitRuleMockery();
    final JDBCConfiguration mockConfiguration = (JDBCConfiguration)this.context.mock(JDBCConfiguration.class);
    final Statement mockStatement = (Statement)this.context.mock(Statement.class);
    final Connection mockConnection = (Connection)this.context.mock(Connection.class);
    final ResultSet mockRS = (ResultSet)this.context.mock(ResultSet.class);
    final DataSource mockDS = (DataSource)this.context.mock(DataSource.class);
    final DatabaseMetaData mockMetaData = (DatabaseMetaData)this.context.mock(DatabaseMetaData.class);
    final StoreContext sc = null;
    final String schema = "abcd";

    @Test
    public void testGetDefaultSchemaNameDS1() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((JDBCConfiguration)this.oneOf(TestDB2Dictionary.this.mockConfiguration)).getDataSource((StoreContext)this.with(1.equal((Object)TestDB2Dictionary.this.sc)));
                this.will(1.returnValue((Object)TestDB2Dictionary.this.mockDS));
                ((DataSource)this.oneOf(TestDB2Dictionary.this.mockDS)).getConnection();
                this.will(1.returnValue((Object)TestDB2Dictionary.this.mockConnection));
                ((Connection)this.oneOf(TestDB2Dictionary.this.mockConnection)).createStatement();
                this.will(1.returnValue((Object)TestDB2Dictionary.this.mockStatement));
                ((Statement)this.oneOf(TestDB2Dictionary.this.mockStatement)).executeQuery((String)this.with(1.any(String.class)));
                this.will(1.returnValue((Object)TestDB2Dictionary.this.mockRS));
                ((ResultSet)this.oneOf(TestDB2Dictionary.this.mockRS)).next();
                this.will(1.returnValue((Object)true));
                ((ResultSet)this.oneOf(TestDB2Dictionary.this.mockRS)).getString(1);
                this.will(1.returnValue((Object)"abcd"));
                ((Connection)this.oneOf(TestDB2Dictionary.this.mockConnection)).close();
                ((ResultSet)this.oneOf(TestDB2Dictionary.this.mockRS)).close();
                ((Statement)this.oneOf(TestDB2Dictionary.this.mockStatement)).close();
                this.allowing(TestDB2Dictionary.this.mockConfiguration);
            }
        });
        DB2Dictionary dict = new DB2Dictionary();
        dict.setConfiguration((Configuration)this.mockConfiguration);
        Assert.assertNotNull((Object)dict);
        Assert.assertEquals((Object)"abcd", (Object)dict.getDefaultSchemaName());
    }

    @Test
    public void testGetDefaultSchemaNameDS2() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((JDBCConfiguration)this.oneOf(TestDB2Dictionary.this.mockConfiguration)).getDataSource((StoreContext)this.with(2.equal((Object)TestDB2Dictionary.this.sc)));
                this.will(2.returnValue(null));
                ((JDBCConfiguration)this.oneOf(TestDB2Dictionary.this.mockConfiguration)).getDataSource2((StoreContext)this.with(2.equal((Object)TestDB2Dictionary.this.sc)));
                this.will(2.returnValue((Object)TestDB2Dictionary.this.mockDS));
                ((DataSource)this.oneOf(TestDB2Dictionary.this.mockDS)).getConnection();
                this.will(2.returnValue((Object)TestDB2Dictionary.this.mockConnection));
                ((Connection)this.oneOf(TestDB2Dictionary.this.mockConnection)).createStatement();
                this.will(2.returnValue((Object)TestDB2Dictionary.this.mockStatement));
                ((Statement)this.oneOf(TestDB2Dictionary.this.mockStatement)).executeQuery((String)this.with(2.any(String.class)));
                this.will(2.returnValue((Object)TestDB2Dictionary.this.mockRS));
                ((ResultSet)this.oneOf(TestDB2Dictionary.this.mockRS)).next();
                this.will(2.returnValue((Object)true));
                ((ResultSet)this.oneOf(TestDB2Dictionary.this.mockRS)).getString(1);
                this.will(2.returnValue((Object)"abcd"));
                ((Connection)this.oneOf(TestDB2Dictionary.this.mockConnection)).close();
                ((ResultSet)this.oneOf(TestDB2Dictionary.this.mockRS)).close();
                ((Statement)this.oneOf(TestDB2Dictionary.this.mockStatement)).close();
                this.allowing(TestDB2Dictionary.this.mockConfiguration);
            }
        });
        DB2Dictionary dict = new DB2Dictionary();
        dict.setConfiguration((Configuration)this.mockConfiguration);
        Assert.assertNotNull((Object)dict);
        Assert.assertEquals((Object)"abcd", (Object)dict.getDefaultSchemaName());
    }

    @Test
    public void testGetDefaultSchemaNameNoDS() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((JDBCConfiguration)this.oneOf(TestDB2Dictionary.this.mockConfiguration)).getDataSource((StoreContext)this.with(3.equal((Object)TestDB2Dictionary.this.sc)));
                this.will(3.returnValue(null));
                ((JDBCConfiguration)this.oneOf(TestDB2Dictionary.this.mockConfiguration)).getDataSource2((StoreContext)this.with(3.equal((Object)TestDB2Dictionary.this.sc)));
                this.will(3.returnValue(null));
                this.allowing(TestDB2Dictionary.this.mockConfiguration);
            }
        });
        DB2Dictionary dict = new DB2Dictionary();
        dict.setConfiguration((Configuration)this.mockConfiguration);
        Assert.assertNotNull((Object)dict);
        Assert.assertEquals(null, (Object)dict.getDefaultSchemaName());
    }

    @Test
    public void testGetDefaultSchemaNameTrimmed() throws Exception {
        String schema2 = "abcd     ";
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((JDBCConfiguration)this.oneOf(TestDB2Dictionary.this.mockConfiguration)).getDataSource((StoreContext)this.with(4.equal((Object)TestDB2Dictionary.this.sc)));
                this.will(4.returnValue((Object)TestDB2Dictionary.this.mockDS));
                ((DataSource)this.oneOf(TestDB2Dictionary.this.mockDS)).getConnection();
                this.will(4.returnValue((Object)TestDB2Dictionary.this.mockConnection));
                ((Connection)this.oneOf(TestDB2Dictionary.this.mockConnection)).createStatement();
                this.will(4.returnValue((Object)TestDB2Dictionary.this.mockStatement));
                ((Statement)this.oneOf(TestDB2Dictionary.this.mockStatement)).executeQuery((String)this.with(4.any(String.class)));
                this.will(4.returnValue((Object)TestDB2Dictionary.this.mockRS));
                ((ResultSet)this.oneOf(TestDB2Dictionary.this.mockRS)).next();
                this.will(4.returnValue((Object)true));
                ((ResultSet)this.oneOf(TestDB2Dictionary.this.mockRS)).getString(1);
                this.will(4.returnValue((Object)"abcd     "));
                ((Connection)this.oneOf(TestDB2Dictionary.this.mockConnection)).close();
                ((ResultSet)this.oneOf(TestDB2Dictionary.this.mockRS)).close();
                ((Statement)this.oneOf(TestDB2Dictionary.this.mockStatement)).close();
                this.allowing(TestDB2Dictionary.this.mockConfiguration);
            }
        });
        DB2Dictionary dict = new DB2Dictionary();
        dict.setConfiguration((Configuration)this.mockConfiguration);
        Assert.assertNotNull((Object)dict);
        Assert.assertEquals((Object)"abcd     ".trim(), (Object)dict.getDefaultSchemaName());
    }

    @Test
    public void testConnectedConfigurationOnlyUsesMetaData() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Connection)this.allowing(TestDB2Dictionary.this.mockConnection)).getMetaData();
                this.will(5.returnValue((Object)TestDB2Dictionary.this.mockMetaData));
                this.allowing(TestDB2Dictionary.this.mockMetaData);
                this.allowing(TestDB2Dictionary.this.mockConfiguration);
            }
        });
        DB2Dictionary dict = new DB2Dictionary();
        dict.db2ServerType = 4;
        dict.setMajorVersion(9);
        dict.setConfiguration((Configuration)this.mockConfiguration);
        Assert.assertNotNull((Object)dict);
        dict.connectedConfiguration(this.mockConnection);
    }
}

