/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Assert;
import org.apache.openjpa.jdbc.sql.BooleanRepresentation;
import org.apache.openjpa.jdbc.sql.BooleanRepresentationFactory;
import org.apache.openjpa.lib.jdbc.DelegatingPreparedStatement;
import org.junit.Test;

public class TestBooleanRepresentation {
    @Test
    public void testBooleanRepresentation() throws Exception {
        this.checkBooleanRepresentation("BOOLEAN", Boolean.class, Boolean.TRUE, Boolean.FALSE);
        this.checkBooleanRepresentation("INT_10", Integer.class, 1, 0);
        this.checkBooleanRepresentation("STRING_10", String.class, "1", "0");
        this.checkBooleanRepresentation("STRING_YN", String.class, "Y", "N");
        this.checkBooleanRepresentation("STRING_YN_LOWERCASE", String.class, "y", "n");
        this.checkBooleanRepresentation("STRING_TF", String.class, "T", "F");
        this.checkBooleanRepresentation("STRING_TF_LOWERCASE", String.class, "t", "f");
        this.checkBooleanRepresentation("oui/non", String.class, "oui", "non");
        this.checkBooleanRepresentation("org.apache.openjpa.jdbc.sql.TestBooleanRepresentation$DummyTestBooleanRepresentation", String.class, "somehowtrue", "somehowfalse");
    }

    private <T> void checkBooleanRepresentation(String representationKey, final Class<T> expectedType, final T yesRepresentation, final T noRepresentation) throws Exception {
        ClassLoader cl = TestBooleanRepresentation.class.getClassLoader();
        BooleanRepresentation booleanRepresentation = BooleanRepresentationFactory.valueOf((String)representationKey, (ClassLoader)cl);
        Assert.assertNotNull((Object)booleanRepresentation);
        DummyPreparedStatement<T> dummyPreparedStatement = new DummyPreparedStatement<T>(expectedType);
        booleanRepresentation.setBoolean(dummyPreparedStatement, 1, true);
        Assert.assertEquals(yesRepresentation, dummyPreparedStatement.getBooleanRepresentationValue());
        booleanRepresentation.setBoolean(dummyPreparedStatement, 1, false);
        Assert.assertEquals(noRepresentation, dummyPreparedStatement.getBooleanRepresentationValue());
        ResultSet yesRs = (ResultSet)Proxy.newProxyInstance(cl, new Class[]{ResultSet.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (String.class.equals((Object)expectedType) && !"getString".equals(method.getName()) || Boolean.class.equals((Object)expectedType) && !"getBoolean".equals(method.getName()) || Integer.class.equals((Object)expectedType) && !"getInt".equals(method.getName())) {
                    Assert.fail((String)("wrong ResultSet method " + method.getName() + "for expectedType " + expectedType.getName()));
                }
                return yesRepresentation;
            }
        });
        Assert.assertTrue((boolean)booleanRepresentation.getBoolean(yesRs, 1));
        ResultSet noRs = (ResultSet)Proxy.newProxyInstance(cl, new Class[]{ResultSet.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (String.class.equals((Object)expectedType) && !"getString".equals(method.getName()) || Boolean.class.equals((Object)expectedType) && !"getBoolean".equals(method.getName()) || Integer.class.equals((Object)expectedType) && !"getInt".equals(method.getName())) {
                    Assert.fail((String)("wrong ResultSet method " + method.getName() + "for expectedType " + expectedType.getName()));
                }
                return noRepresentation;
            }
        });
        Assert.assertFalse((boolean)booleanRepresentation.getBoolean(noRs, 1));
    }

    public static class DummyTestBooleanRepresentation
    implements BooleanRepresentation<String> {
        public void setBoolean(PreparedStatement stmnt, int columnIndex, boolean val) throws SQLException {
            stmnt.setString(columnIndex, this.getRepresentation(val));
        }

        public boolean getBoolean(ResultSet rs, int columnIndex) throws SQLException {
            return "somehowtrue".equals(rs.getString(columnIndex));
        }

        public String getRepresentation(boolean bool) {
            return bool ? "somehowtrue" : "somehowfalse";
        }
    }

    public static class DummyPreparedStatement<T>
    extends DelegatingPreparedStatement {
        private final Class<T> expectedType;
        private Object booleanRepresentationValue;

        public DummyPreparedStatement(Class<T> expectedType) {
            super(null, null);
            this.expectedType = expectedType;
        }

        public T getBooleanRepresentationValue() {
            return (T)this.booleanRepresentationValue;
        }

        public void setBooleanRepresentationValue(T booleanRepresentationValue) {
            this.booleanRepresentationValue = booleanRepresentationValue;
        }

        public void setBoolean(int idx, boolean b) throws SQLException {
            Assert.assertEquals(Boolean.class, this.expectedType);
            this.booleanRepresentationValue = b;
        }

        public void setString(int idx, String s) throws SQLException {
            Assert.assertEquals(String.class, this.expectedType);
            this.booleanRepresentationValue = s;
        }

        public void setInt(int idx, int i) throws SQLException {
            Assert.assertEquals(Integer.class, this.expectedType);
            this.booleanRepresentationValue = i;
        }
    }
}

