/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.MappingDefaultsImpl;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.lib.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class TestMappingDefaultsImpl {
    @Test
    public void testPopulateWithLongColumnNames() {
        MappingDefaultsImpl mapping = new MappingDefaultsImpl();
        JDBCConfigurationImpl conf = new JDBCConfigurationImpl(false, false);
        conf.setDBDictionary("oracle");
        mapping.setConfiguration((Configuration)conf);
        Table table = new Table("testtable", null);
        Column[] cols = new Column[]{new Column("longnamelongnamelongnamelongnamelongnamelongname1", null), new Column("longnamelongnamelongnamelongnamelongnamelongname2", null), new Column("longnamelongnamelongnamelongnamelongnamelongname3", null)};
        MappingRepository mr = new MappingRepository();
        mr.setConfiguration((Configuration)conf);
        Version version = new Version(new ClassMapping(String.class, mr));
        mapping.populateColumns(version, table, cols);
        Assert.assertFalse((String)("column names are conflicted : " + cols[0].getName()), (boolean)cols[0].getName().equals(cols[1].getName()));
        Assert.assertFalse((String)("column names are conflicted : " + cols[0].getName()), (boolean)cols[0].getName().equals(cols[2].getName()));
        Assert.assertFalse((String)("column names are conflicted : " + cols[1].getName()), (boolean)cols[1].getName().equals(cols[2].getName()));
    }
}

