/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql.identifier;

import junit.framework.TestCase;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;

public class TestDBIdentifiers
extends TestCase {
    public void testSchemaOps() {
        QualifiedDBIdentifier p1 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"my.schema")});
        DBIdentifier s1 = DBIdentifier.newSchema((String)"my.schema");
        TestDBIdentifiers.assertTrue((boolean)QualifiedDBIdentifier.equal((DBIdentifier)p1, (DBIdentifier)s1));
        TestDBIdentifiers.assertEquals((String)"\"my.schema\"", (String)p1.getName());
        TestDBIdentifiers.assertEquals((String)"\"my.schema\"", (String)s1.getName());
        TestDBIdentifiers.assertEquals((Object)p1.getType(), (Object)DBIdentifier.DBIdentifierType.SCHEMA);
        TestDBIdentifiers.assertEquals((Object)s1.getType(), (Object)DBIdentifier.DBIdentifierType.SCHEMA);
        TestDBIdentifiers.assertFalse((boolean)(s1 instanceof QualifiedDBIdentifier));
        QualifiedDBIdentifier p2 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"SCHEMA")});
        DBIdentifier s2 = DBIdentifier.newSchema((String)"SCHEMA2");
        TestDBIdentifiers.assertFalse((boolean)QualifiedDBIdentifier.equal((DBIdentifier)p2, (DBIdentifier)s2));
        TestDBIdentifiers.assertEquals((String)"SCHEMA", (String)p2.getName());
        TestDBIdentifiers.assertEquals((String)"SCHEMA2", (String)s2.getName());
        TestDBIdentifiers.assertEquals((Object)p2.getType(), (Object)DBIdentifier.DBIdentifierType.SCHEMA);
        TestDBIdentifiers.assertEquals((Object)s2.getType(), (Object)DBIdentifier.DBIdentifierType.SCHEMA);
        TestDBIdentifiers.assertTrue((boolean)(p2 instanceof QualifiedDBIdentifier));
        TestDBIdentifiers.assertFalse((boolean)(s2 instanceof QualifiedDBIdentifier));
    }

    public void testTableOps() {
        DBIdentifier name = DBIdentifier.newTable((String)"table");
        TestDBIdentifiers.assertEquals((String)"table", (String)name.getName());
        name = DBIdentifier.newTable((String)"my table");
        TestDBIdentifiers.assertEquals((String)"\"my table\"", (String)name.getName());
        DBIdentifier[] names = QualifiedDBIdentifier.splitPath((DBIdentifier)name);
        this.assertTableEquals(names, null, "\"my table\"");
        name = DBIdentifier.newTable((String)"\"my.schema\".\"my.table\"");
        TestDBIdentifiers.assertEquals((String)"\"my.schema\".\"my.table\"", (String)name.getName());
        names = QualifiedDBIdentifier.splitPath((DBIdentifier)name);
        this.assertTableEquals(names, "\"my.schema\"", "\"my.table\"");
        name = DBIdentifier.newTable((String)"my_schema.my_table");
        TestDBIdentifiers.assertEquals((String)"my_schema.my_table", (String)name.getName());
        names = QualifiedDBIdentifier.splitPath((DBIdentifier)name);
        this.assertTableEquals(names, "my_schema", "my_table");
        DBIdentifier tName = DBIdentifier.newTable((String)"my table");
        DBIdentifier sName = DBIdentifier.newSchema((String)"my schema");
        QualifiedDBIdentifier path = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{sName, tName});
        TestDBIdentifiers.assertEquals((String)"\"my schema\".\"my table\"", (String)path.getName());
        TestDBIdentifiers.assertEquals((String)tName.getName(), (String)path.getBaseName());
        TestDBIdentifiers.assertEquals((String)sName.getName(), (String)path.getSchemaName().getName());
        tName = DBIdentifier.newTable((String)"my_table");
        sName = DBIdentifier.newSchema((String)"my_schema");
        path = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{sName, tName});
        TestDBIdentifiers.assertEquals((String)"my_schema.my_table", (String)path.getName());
        TestDBIdentifiers.assertEquals((String)tName.getName(), (String)path.getBaseName());
        TestDBIdentifiers.assertEquals((String)sName.getName(), (String)path.getSchemaName().getName());
        QualifiedDBIdentifier p1 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"schema"), DBIdentifier.newTable((String)"my table")});
        QualifiedDBIdentifier p2 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"schema"), DBIdentifier.newTable((String)"\"my table\"")});
        QualifiedDBIdentifier p3 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"schema"), DBIdentifier.newTable((String)"my_table")});
        TestDBIdentifiers.assertTrue((boolean)p1.equals((Object)p2));
        TestDBIdentifiers.assertFalse((boolean)p1.equals((Object)p3));
        TestDBIdentifiers.assertFalse((boolean)p2.equals((Object)p3));
        TestDBIdentifiers.assertFalse((boolean)p1.equals(null));
        TestDBIdentifiers.assertFalse((boolean)p1.equals((Object)DBIdentifier.NULL));
    }

    public void testColumnOps() {
        DBIdentifier c0 = DBIdentifier.newColumn((String)"\"col.1\"");
        TestDBIdentifiers.assertEquals((String)"\"col.1\"", (String)c0.getName());
        TestDBIdentifiers.assertTrue((boolean)(c0 instanceof QualifiedDBIdentifier));
        TestDBIdentifiers.assertEquals((Object)c0.getType(), (Object)DBIdentifier.DBIdentifierType.COLUMN);
        DBIdentifier c1 = DBIdentifier.newColumn((String)"column 1");
        DBIdentifier t1 = DBIdentifier.newTable((String)"table");
        DBIdentifier s1 = DBIdentifier.newSchema((String)"\"my schema\"");
        QualifiedDBIdentifier p1 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{s1, t1, c1});
        TestDBIdentifiers.assertEquals((String)"\"my schema\".table.\"column 1\"", (String)p1.getName());
        DBIdentifier c2 = DBIdentifier.newColumn((String)"\"column_2\"");
        DBIdentifier t2 = DBIdentifier.newTable((String)"table.2", (boolean)true);
        QualifiedDBIdentifier p2 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{t2, c2});
        TestDBIdentifiers.assertEquals((String)"\"table.2\".\"column_2\"", (String)p2.getName());
    }

    public void testDBIdentifierOps() {
        DBIdentifier n1 = DBIdentifier.newColumn((String)"abcdefgh");
        n1 = DBIdentifier.truncate((DBIdentifier)n1, (int)6);
        TestDBIdentifiers.assertEquals((String)"ab", (String)n1.getName());
        DBIdentifier n2 = DBIdentifier.newColumn((String)"\"abcd efgh\"");
        n2 = DBIdentifier.truncate((DBIdentifier)n2, (int)3);
        TestDBIdentifiers.assertEquals((String)"\"abcd e\"", (String)n2.getName());
        DBIdentifier n3 = DBIdentifier.newColumn((String)"abcdefgh");
        n3 = DBIdentifier.append((DBIdentifier)n3, (String)"ijk");
        TestDBIdentifiers.assertEquals((String)"abcdefghijk", (String)n3.getName());
        DBIdentifier n4 = DBIdentifier.newColumn((String)"\"abcd efgh\"");
        n4 = DBIdentifier.append((DBIdentifier)n4, (String)"i k");
        TestDBIdentifiers.assertEquals((String)"\"abcd efghi k\"", (String)n4.getName());
        DBIdentifier n5 = DBIdentifier.newColumn((String)"\"abcd efgh\"");
        n5 = DBIdentifier.append((DBIdentifier)n5, (String)"\"i k\"");
        TestDBIdentifiers.assertEquals((String)"\"abcd efghi k\"", (String)n5.getName());
        DBIdentifier cn1 = DBIdentifier.newTable((String)"sch.tbl");
        DBIdentifier cn2 = cn1.clone();
        TestDBIdentifiers.assertFalse((cn1 == cn2 ? 1 : 0) != 0);
        TestDBIdentifiers.assertEquals((String)cn1.getName(), (String)cn2.getName());
        TestDBIdentifiers.assertEquals((Object)cn1, (Object)cn2);
        DBIdentifier tbl = DBIdentifier.newTable((String)"tbl");
        DBIdentifier sch = DBIdentifier.newSchema((String)"sch");
        QualifiedDBIdentifier path = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{sch, tbl});
        QualifiedDBIdentifier path2 = path.clone();
        TestDBIdentifiers.assertEquals((String)tbl.getName(), (String)path.getBaseName());
        TestDBIdentifiers.assertEquals((Object)sch, (Object)path.getSchemaName());
        TestDBIdentifiers.assertEquals((String)tbl.getName(), (String)path2.getBaseName());
        TestDBIdentifiers.assertEquals((Object)sch, (Object)path2.getSchemaName());
        DBIdentifier tbl2 = DBIdentifier.newTable((String)"tbl2");
        DBIdentifier sch2 = DBIdentifier.newSchema((String)"sch2");
        DBIdentifier col = DBIdentifier.newColumn((String)"col");
        QualifiedDBIdentifier cpath = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{sch2, tbl2, col});
        QualifiedDBIdentifier cpath2 = cpath.clone();
        TestDBIdentifiers.assertEquals((String)col.getName(), (String)cpath2.getBaseName());
        TestDBIdentifiers.assertEquals((Object)sch2, (Object)cpath2.getSchemaName());
        TestDBIdentifiers.assertEquals((Object)tbl2, (Object)cpath2.getObjectTableName());
        DBIdentifier dName = DBIdentifier.newColumn((String)"\"ITEMNAME\"", (boolean)true);
        TestDBIdentifiers.assertEquals((String)"\"ITEMNAME\"", (String)dName.getName());
    }

    public void testPathOps() {
        QualifiedDBIdentifier p1 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"MyTable"), DBIdentifier.newColumn((String)"mycol")});
        QualifiedDBIdentifier p2 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"MYTABLE"), DBIdentifier.newColumn((String)"MYCOL")});
        TestDBIdentifiers.assertTrue((boolean)QualifiedDBIdentifier.equal((DBIdentifier)p1, (DBIdentifier)p1));
        QualifiedDBIdentifier p3 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"\"MyTable\""), DBIdentifier.newColumn((String)"\"mycol\"")});
        QualifiedDBIdentifier p4 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"MYTABLE"), DBIdentifier.newColumn((String)"MYCOL")});
        QualifiedDBIdentifier p5 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"\"MyTable\""), DBIdentifier.newColumn((String)"\"mycol\"")});
        TestDBIdentifiers.assertFalse((boolean)QualifiedDBIdentifier.equal((DBIdentifier)p3, (DBIdentifier)p4));
        TestDBIdentifiers.assertTrue((boolean)QualifiedDBIdentifier.equal((DBIdentifier)p3, (DBIdentifier)p5));
        QualifiedDBIdentifier p6 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"MyTable"), DBIdentifier.newColumn((String)"mycol")});
        DBIdentifier n1 = DBIdentifier.newSchema((String)"Schema_1");
        DBIdentifier n2 = DBIdentifier.newTable((String)"Table_1");
        DBIdentifier n3 = DBIdentifier.newColumn((String)"Column_1");
        p6.setPath(new DBIdentifier[]{n1});
        TestDBIdentifiers.assertEquals((String)"Schema_1", (String)n1.getName());
        TestDBIdentifiers.assertEquals((Object)n1.getType(), (Object)DBIdentifier.DBIdentifierType.SCHEMA);
        p6.setPath(new DBIdentifier[]{n2});
        TestDBIdentifiers.assertEquals((String)"Table_1", (String)n2.getName());
        TestDBIdentifiers.assertEquals((Object)n2.getType(), (Object)DBIdentifier.DBIdentifierType.TABLE);
        p6.setPath(new DBIdentifier[]{n3});
        TestDBIdentifiers.assertEquals((String)"Column_1", (String)n3.getName());
        TestDBIdentifiers.assertEquals((Object)n3.getType(), (Object)DBIdentifier.DBIdentifierType.COLUMN);
        QualifiedDBIdentifier p7 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"MyTable"), DBIdentifier.newColumn((String)"mycol")});
        TestDBIdentifiers.assertFalse((boolean)p7.isDelimited());
        QualifiedDBIdentifier p8 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"My Table"), DBIdentifier.newColumn((String)"mycol")});
        TestDBIdentifiers.assertFalse((boolean)p8.isDelimited());
        QualifiedDBIdentifier p9 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"My Table"), DBIdentifier.newColumn((String)"my col")});
        TestDBIdentifiers.assertTrue((boolean)p9.isDelimited());
        QualifiedDBIdentifier p10 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newTable((String)"\"MyTable\""), DBIdentifier.newColumn((String)"\"my col\"")});
        TestDBIdentifiers.assertTrue((boolean)p10.isDelimited());
        QualifiedDBIdentifier p11 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"\"MySchema\""), DBIdentifier.newTable((String)"\"my tbl\"")});
        TestDBIdentifiers.assertTrue((boolean)p11.isDelimited());
        QualifiedDBIdentifier p12 = QualifiedDBIdentifier.newPath((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)"\"MySchema\""), DBIdentifier.newTable((String)"mytbl"), DBIdentifier.newColumn((String)"\"my col\"")});
        TestDBIdentifiers.assertFalse((boolean)p12.isDelimited());
    }

    private void assertTableEquals(DBIdentifier[] names, String schema, String table) {
        TestDBIdentifiers.assertNotNull((Object)names);
        TestDBIdentifiers.assertEquals((int)(schema == null ? 1 : 2), (int)names.length);
        int idx = 0;
        if (schema != null) {
            TestDBIdentifiers.assertEquals((Object)DBIdentifier.DBIdentifierType.SCHEMA, (Object)names[idx].getType());
            TestDBIdentifiers.assertEquals((String)names[idx].getName(), (String)schema);
            ++idx;
        } else {
            TestDBIdentifiers.assertEquals((Object)DBIdentifier.DBIdentifierType.TABLE, (Object)names[idx].getType());
            String path = QualifiedDBIdentifier.join((DBIdentifier[])new DBIdentifier[]{DBIdentifier.newSchema((String)schema), DBIdentifier.newTable((String)table)});
            TestDBIdentifiers.assertEquals((String)names[idx].getName(), (String)path);
        }
    }
}

