/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfigurationImpl;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.MySQLDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.jmock.Expectations;
import org.jmock.integration.junit3.MockObjectTestCase;
import org.jmock.internal.ExpectationBuilder;

public class TestMySQLDictionary
extends MockObjectTestCase {
    public void testDBDictionaryGetBatchFetchSize() throws Exception {
        MySQLDictionary db = new MySQLDictionary();
        TestMySQLDictionary.assertEquals((int)Integer.MIN_VALUE, (int)db.getBatchFetchSize(1));
    }

    public void testPreparedStatementGetFetchBatchSize() throws Exception {
        MySQLDictionary db = new MySQLDictionary();
        SQLBuffer sql = new SQLBuffer((DBDictionary)db);
        final PreparedStatement mockStatement = (PreparedStatement)this.mock(PreparedStatement.class);
        final Connection mockConnection = (Connection)this.mock(Connection.class);
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Connection)this.oneOf(mockConnection)).prepareStatement((String)this.with(1.any(String.class)));
                this.will(1.returnValue((Object)mockStatement));
                ((PreparedStatement)this.oneOf(mockStatement)).setFetchSize(Integer.MIN_VALUE);
            }
        });
        JDBCFetchConfigurationImpl fetch = new JDBCFetchConfigurationImpl();
        fetch.setResultSetType(1003);
        fetch.setFetchBatchSize(1);
        sql.prepareStatement(mockConnection, (JDBCFetchConfiguration)fetch, -1, -1);
    }

    public void testPreparedCallGetFetchBatchSize() throws Exception {
        MySQLDictionary db = new MySQLDictionary();
        SQLBuffer sql = new SQLBuffer((DBDictionary)db);
        final CallableStatement mockStatement = (CallableStatement)this.mock(CallableStatement.class);
        final Connection mockConnection = (Connection)this.mock(Connection.class);
        this.checking((ExpectationBuilder)new Expectations(){
            {
                ((Connection)this.oneOf(mockConnection)).prepareCall((String)this.with(2.any(String.class)));
                this.will(2.returnValue((Object)mockStatement));
                ((CallableStatement)this.oneOf(mockStatement)).setFetchSize(Integer.MIN_VALUE);
            }
        });
        JDBCFetchConfigurationImpl fetch = new JDBCFetchConfigurationImpl();
        fetch.setResultSetType(1003);
        fetch.setFetchBatchSize(1);
        sql.prepareCall(mockConnection, (JDBCFetchConfiguration)fetch, -1, -1);
    }
}

