/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.apache.openjpa.jdbc.sql.DBDictionaryFactory;

public class TestDictionaryFactory
extends TestCase {
    private String[][] testMatrix = new String[][]{{"jdbc:mysql:", "jdbc:mysql:"}, {"jdbc:cloudscape:database", "jdbc:cloudscape:"}, {"jdbc:as400://systemname", "jdbc:as400:"}, {"jdbc:Cache://host:1234/db", "jdbc:Cache:"}, {"jdbc:FrontBase://host.domain.com/mydb", "jdbc:FrontBase:"}, {"jdbc:sqlserver://server\\instance:1234;p1=v1", "jdbc:sqlserver:"}, {"jdbc:interbase://win32:3/C:/fire/test.gdb", "jdbc:interbase:"}, {"jdbc:firebirdsql://unix/fire/test.gdb", "jdbc:firebirdsql:"}, {"jdbc:db2://localhost:5000/db2", "jdbc:db2:"}, {"jdbc:oracle:thin:@host:1234:database_sid", "jdbc:oracle:thin:"}, {"jdbc:oracle:oci://host:port/service", "jdbc:oracle:oci:"}, {"jdbc:oracle:thin:host:1234:sid", "jdbc:oracle:thin:"}, {"jdbc:oracle:oci:TNSName", "jdbc:oracle:oci:"}, {"jdbc:microsoft:sqlserver://host:123;dbname=name;usr=u;pwd=p", "jdbc:microsoft:sqlserver:"}, {"jdbc:inetdae7:host:1234?database=DB", "jdbc:inetdae7:host:"}, {"jdbc:odbc:Driver=Microsoft Access Driver (*.mdb);DBQ=c:\\db_file;", "jdbc:odbc:Driver=Microsoft Access Driver (*.mdb);DBQ=c:"}, {"jdbc:jtds:microsoft:host:1234/database", "jdbc:jtds:microsoft:"}, {"jdbc:jtds:sqlserver://server:1234/database;p=v1", "jdbc:jtds:sqlserver:"}, {"jdbc:mysql://host,failoverhost:1234/database", "jdbc:mysql:"}, {"jdbc:mysql://host1:1,host2:2/database?p1=v1&p2=v2", "jdbc:mysql:"}, {"jdbc:postgresql:database", "jdbc:postgresql:"}, {"jdbc:AvenirDriver://127.0.0.1:1433/master;uid=sa;pwd=sa", "jdbc:AvenirDriver:"}, {"jdbc:merant:sqlserver://suresh:1433", "jdbc:merant:sqlserver:"}, {"jdbc:JSQLConnect://localhost/database=Master&user=sa&password=sa", "jdbc:JSQLConnect:"}, {"jdbc:weblogic:mssqlserver4:Master@suresh:1433?user=sa&password=sa", "jdbc:weblogic:mssqlserver4:"}, {"jdbc:sybase:Tds:host:1234?ServiceName=database_name", "jdbc:sybase:Tds:"}, {"jdbc:hsqldb:file:/opt/db/testdb", "jdbc:hsqldb:file:"}, {"jdbc:hsqldb:mem:aname", "jdbc:hsqldb:mem:"}, {"jdbc:hsqldb:database", "jdbc:hsqldb:"}, {"jdbc:hsqldb:hsql://host:1234", "jdbc:hsqldb:hsql:"}, {"jdbc:informix-sqli://host:1234/database:informixserver=dbserver.com", "jdbc:informix-sqli:"}, {"jdbc:derby:net://host:1527/<databaseName", "jdbc:derby:net:"}, {"jdbc:cloudscape:MyDataBase", "jdbc:cloudscape:"}, {"jdbc:pointbase:embedded:PBPUBLIC", "jdbc:pointbase:embedded:"}, {"jdbc:pointbase:server://host:1234/database", "jdbc:pointbase:server:"}, {"jdbc:interbase:jndi:LDAP_hostname:1234/db", "jdbc:interbase:jndi:"}, {"jdbc:borland:dsremote://hostName/path/storeName.jds", "jdbc:borland:dsremote:"}, {"jdbc:borland:dslocal:storeName.jds", "jdbc:borland:dslocal:"}, {"jdbc:easysoft://server/datasource:logonuser=user:logonpassword=pwd", "jdbc:easysoft:"}, {"jdbc:empress:DATABASE=db", "jdbc:empress:"}, {"jdbc:empress://SERVER=localhost;PORT=6322", "jdbc:empress:"}, {"jdbc:pointbase:embedded:sample", "jdbc:pointbase:embedded:"}, {"jdbc:firebirdsql:host/1234:database", "jdbc:firebirdsql:"}, {"jdbc:firebirdsql:localhost/3050:/firebird/test.gdb", "jdbc:firebirdsql:"}, {"jdbc:h2:test", "jdbc:h2:"}, {"jdbc:h2:tcp://localhost:9092/test", "jdbc:h2:tcp:"}, {"jdbc:h2:mem:name;key=value", "jdbc:h2:mem:"}, {"jdbc:h2:file:fileName;key=value", "jdbc:h2:file:"}, {"file://c:/", null}};
    private static Method getProtocol;

    public void setUp() {
        try {
            getProtocol = DBDictionaryFactory.class.getDeclaredMethod("getProtocol", String.class);
        }
        catch (Exception e) {
            TestDictionaryFactory.fail((String)e.getMessage());
        }
    }

    public void testUrl2Dictionary() {
        for (int i = 0; i < this.testMatrix.length; ++i) {
            try {
                String dbType = (String)getProtocol.invoke(null, this.testMatrix[i][0]);
                TestDictionaryFactory.assertEquals((String)dbType, (String)this.testMatrix[i][1]);
                continue;
            }
            catch (Exception e) {
                TestDictionaryFactory.fail((String)e.getMessage());
            }
        }
    }
}

