/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;

public class MySQLDictionary
extends DBDictionary {
    public static final String SELECT_HINT = "openjpa.hint.MySQLSelectHint";
    public String tableType = "innodb";
    public boolean useClobs = true;
    public boolean driverDeserializesBlobs = false;
    public boolean optimizeMultiTableDeletes = false;

    public MySQLDictionary() {
        this.platform = "MySQL";
        this.validationSQL = "SELECT NOW()";
        this.distinctCountColumnSeparator = ",";
        this.supportsDeferredConstraints = false;
        this.constraintNameMode = "mid";
        this.supportsMultipleNontransactionalResultSets = false;
        this.requiresAliasForSubselect = true;
        this.requiresTargetForDelete = true;
        this.supportsSelectStartIndex = true;
        this.supportsSelectEndIndex = true;
        this.concatenateFunction = "CONCAT({0},{1})";
        this.maxTableNameLength = 64;
        this.maxColumnNameLength = 64;
        this.maxIndexNameLength = 64;
        this.maxConstraintNameLength = 64;
        this.maxIndexesPerTable = 32;
        this.schemaCase = "preserve";
        this.supportsAutoAssign = true;
        this.lastGeneratedKeyQuery = "SELECT LAST_INSERT_ID()";
        this.autoAssignClause = "AUTO_INCREMENT";
        this.clobTypeName = "TEXT";
        this.longVarcharTypeName = "TEXT";
        this.longVarbinaryTypeName = "LONG VARBINARY";
        this.timestampTypeName = "DATETIME";
        this.xmlTypeName = "TEXT";
        this.fixedSizeTypeNameSet.addAll(Arrays.asList("BOOL", "LONG VARBINARY", "MEDIUMBLOB", "LONGBLOB", "TINYBLOB", "LONG VARCHAR", "MEDIUMTEXT", "LONGTEXT", "TEXT", "TINYTEXT", "DOUBLE PRECISION", "ENUM", "SET", "DATETIME"));
        this.reservedWordSet.addAll(Arrays.asList("AUTO_INCREMENT", "BINARY", "BLOB", "CHANGE", "ENUM", "INFILE", "INT1", "INT2", "INT4", "FLOAT1", "FLOAT2", "FLOAT4", "LOAD", "MEDIUMINT", "OUTFILE", "REPLACE", "STARTING", "TEXT", "UNSIGNED", "ZEROFILL"));
        this.invalidColumnWordSet.addAll(Arrays.asList("ADD", "ALL", "ALTER", "AND", "AS", "ASC", "BETWEEN", "BINARY", "BLOB", "BOTH", "BY", "CASCADE", "CASE", "CHANGE", "CHAR", "CHARACTER", "CHECK", "COLLATE", "COLUMN", "CONSTRAINT", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DELETE", "DESC", "DESCRIBE", "DISTINCT", "DOUBLE", "DROP", "ELSE", "END-EXEC", "EXISTS", "FALSE", "FETCH", "FLOAT", "FLOAT4", "FOR", "FOREIGN", "FROM", "GRANT", "GROUP", "HAVING", "IN", "INFILE", "INNER", "INSENSITIVE", "INSERT", "INT", "INT1", "INT2", "INT4", "INTEGER", "INTERVAL", "INTO", "IS", "JOIN", "KEY", "LEADING", "LEFT", "LIKE", "LOAD", "MATCH", "MEDIUMINT", "NATURAL", "NOT", "NULL", "NUMERIC", "ON", "OPTION", "OR", "ORDER", "OUTER", "OUTFILE", "PRECISION", "PRIMARY", "PROCEDURE", "READ", "REAL", "REFERENCES", "REPLACE", "RESTRICT", "REVOKE", "RIGHT", "SCHEMA", "SELECT", "SET", "SMALLINT", "SQL", "SQLSTATE", "STARTING", "TABLE", "THEN", "TO", "TRAILING", "TRUE", "UNION", "UNIQUE", "UNSIGNED", "UPDATE", "USAGE", "USING", "VALUES", "VARCHAR", "VARYING", "WHEN", "WHERE", "WITH", "WRITE", "ZEROFILL"));
        this.searchStringEscape = "\\\\";
        this.typeModifierSet.addAll(Arrays.asList("UNSIGNED", "ZEROFILL"));
    }

    public void connectedConfiguration(Connection conn) throws SQLException {
        int min;
        int maj;
        DatabaseMetaData metaData;
        block7: {
            super.connectedConfiguration(conn);
            metaData = conn.getMetaData();
            maj = 0;
            min = 0;
            if (this.isJDBC3) {
                maj = metaData.getDatabaseMajorVersion();
                min = metaData.getDatabaseMinorVersion();
            } else {
                try {
                    String productVersion = metaData.getDatabaseProductVersion();
                    int[] versions = MySQLDictionary.getMajorMinorVersions(productVersion);
                    maj = versions[0];
                    min = versions[1];
                }
                catch (IllegalArgumentException e) {
                    if (!this.log.isWarnEnabled()) break block7;
                    this.log.warn((Object)e.toString(), (Throwable)e);
                }
            }
        }
        if (maj < 4 || maj == 4 && min < 1) {
            this.supportsSubselect = false;
            this.allowsAliasInBulkClause = false;
            this.supportsForeignKeysComposite = false;
        }
        if (maj > 5 || maj == 5 && min >= 1) {
            this.supportsXMLColumn = true;
        }
        if (metaData.getDriverMajorVersion() < 5) {
            this.driverDeserializesBlobs = true;
        }
    }

    public Connection decorate(Connection conn) throws SQLException {
        conn = super.decorate(conn);
        String driver = this.conf.getConnectionDriverName();
        if ("com.mysql.jdbc.ReplicationDriver".equals(driver)) {
            conn.setReadOnly(true);
        }
        return conn;
    }

    private static int[] getMajorMinorVersions(String versionStr) throws IllegalArgumentException {
        String[] arr;
        int beginIndex = 0;
        versionStr = versionStr.trim();
        char[] charArr = versionStr.toCharArray();
        for (int i = 0; i < charArr.length; ++i) {
            if (!Character.isDigit(charArr[i])) continue;
            beginIndex = i;
            break;
        }
        int endIndex = charArr.length;
        for (int i = beginIndex + 1; i < charArr.length; ++i) {
            if (charArr[i] == '.' || Character.isDigit(charArr[i])) continue;
            endIndex = i;
            break;
        }
        if ((arr = versionStr.substring(beginIndex, endIndex).split("\\.")).length < 2) {
            throw new IllegalArgumentException();
        }
        int maj = Integer.parseInt(arr[0]);
        int min = Integer.parseInt(arr[1]);
        return new int[]{maj, min};
    }

    public String[] getCreateTableSQL(Table table) {
        String[] sql = super.getCreateTableSQL(table);
        if (!StringUtils.isEmpty((String)this.tableType)) {
            sql[0] = sql[0] + " TYPE = " + this.tableType;
        }
        return sql;
    }

    public String[] getDropIndexSQL(Index index) {
        return new String[]{"DROP INDEX " + this.getFullName(index) + " ON " + this.getFullName(index.getTable(), false)};
    }

    public String[] getDropPrimaryKeySQL(PrimaryKey pk) {
        if (pk.getName() == null) {
            return new String[0];
        }
        return new String[]{"ALTER TABLE " + this.getFullName(pk.getTable(), false) + " DROP PRIMARY KEY"};
    }

    public String[] getDropForeignKeySQL(ForeignKey fk, Connection conn) {
        if (fk.getName() == null) {
            String[] stringArray;
            String fkName = fk.loadNameFromDB(this, conn);
            if (fkName == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "ALTER TABLE " + this.getFullName(fk.getTable(), false) + " DROP FOREIGN KEY " + fkName;
            }
            String[] retVal = stringArray;
            return retVal;
        }
        return new String[]{"ALTER TABLE " + this.getFullName(fk.getTable(), false) + " DROP FOREIGN KEY " + fk.getName()};
    }

    public String[] getAddPrimaryKeySQL(PrimaryKey pk) {
        String[] sql = super.getAddPrimaryKeySQL(pk);
        Column[] cols = pk.getColumns();
        String[] ret = new String[cols.length + sql.length];
        for (int i = 0; i < cols.length; ++i) {
            ret[i] = "ALTER TABLE " + this.getFullName(cols[i].getTable(), false) + " CHANGE " + cols[i].getName() + " " + cols[i].getName() + " " + this.getTypeName(cols[i]) + " NOT NULL";
        }
        System.arraycopy(sql, 0, ret, cols.length, sql.length);
        return ret;
    }

    public String[] getDeleteTableContentsSQL(Table[] tables, Connection conn) {
        if (!this.optimizeMultiTableDeletes) {
            return super.getDeleteTableContentsSQL(tables, conn);
        }
        StringBuffer buf = new StringBuffer(tables.length * 8);
        buf.append("DELETE FROM ");
        for (int i = 0; i < tables.length; ++i) {
            buf.append(tables[i].getFullName());
            if (i >= tables.length - 1) continue;
            buf.append(", ");
        }
        return new String[]{buf.toString()};
    }

    protected void appendSelectRange(SQLBuffer buf, long start, long end, boolean subselect) {
        buf.append(" LIMIT ").appendValue(start).append(", ");
        if (end == Long.MAX_VALUE) {
            buf.appendValue(Long.MAX_VALUE);
        } else {
            buf.appendValue(end - start);
        }
    }

    protected Column newColumn(ResultSet colMeta) throws SQLException {
        Column col = super.newColumn(colMeta);
        if (col.isNotNull() && "0".equals(col.getDefaultString())) {
            col.setDefaultString(null);
        }
        return col;
    }

    public Object getBlobObject(ResultSet rs, int column, JDBCStore store) throws SQLException {
        if (this.useGetBytesForBlobs || this.useGetObjectForBlobs || !this.driverDeserializesBlobs) {
            return super.getBlobObject(rs, column, store);
        }
        return rs.getObject(column);
    }

    public int getPreferredType(int type) {
        if (type == 2005 && !this.useClobs) {
            return -1;
        }
        return super.getPreferredType(type);
    }

    public void appendXmlComparison(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs, boolean lhsxml, boolean rhsxml) {
        super.appendXmlComparison(buf, op, lhs, rhs, lhsxml, rhsxml);
        if (lhsxml) {
            this.appendXmlValue(buf, lhs);
        } else {
            lhs.appendTo(buf);
        }
        buf.append(" ").append(op).append(" ");
        if (rhsxml) {
            this.appendXmlValue(buf, rhs);
        } else {
            rhs.appendTo(buf);
        }
    }

    private void appendXmlValue(SQLBuffer buf, FilterValue val) {
        buf.append("ExtractValue(").append(val.getColumnAlias(val.getFieldMapping().getColumns()[0])).append(",'/*/");
        val.appendTo(buf);
        buf.append("')");
    }

    public int getBatchFetchSize(int batchFetchSize) {
        return Integer.MIN_VALUE;
    }

    public String getSelectOperation(JDBCFetchConfiguration fetch) {
        Object hint = fetch == null ? null : fetch.getHint(SELECT_HINT);
        String select = "SELECT";
        if (hint != null) {
            select = select + " " + hint;
        }
        return select;
    }
}

