/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.util.Map;
import org.apache.openjpa.jdbc.kernel.exps.BinaryOpExpState;
import org.apache.openjpa.jdbc.kernel.exps.Exp;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;

public class WhenScalar
implements Exp {
    private final Val _val1;
    private final Val _val2;

    public WhenScalar(Val val1, Val val2) {
        this._val1 = val1;
        this._val2 = val2;
    }

    public Val getVal1() {
        return this._val1;
    }

    public Val getVal2() {
        return this._val2;
    }

    public Class getType() {
        return this._val2.getType();
    }

    public ExpState initialize(Select sel, ExpContext ctx, Map contains) {
        ExpState s1 = this._val1.initialize(sel, ctx, 0);
        ExpState s2 = this._val2.initialize(sel, ctx, 0);
        return new BinaryOpExpState(sel.and(s1.joins, s2.joins), s1, s2);
    }

    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer buf) {
        BinaryOpExpState bstate = (BinaryOpExpState)state;
        this._val1.appendTo(sel, ctx, bstate.state1, buf, 0);
        buf.append(" THEN ");
        this._val2.appendTo(sel, ctx, bstate.state2, buf, 0);
    }

    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        BinaryOpExpState bstate = (BinaryOpExpState)state;
        this._val1.selectColumns(sel, ctx, bstate.state1, pks);
        this._val2.selectColumns(sel, ctx, bstate.state2, pks);
    }

    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter((Expression)this);
        this._val1.acceptVisit(visitor);
        this._val2.acceptVisit(visitor);
        visitor.exit((Expression)this);
    }

    public int getId() {
        return 16;
    }
}

