/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.util.Map;
import org.apache.openjpa.jdbc.kernel.exps.BinaryOpExpState;
import org.apache.openjpa.jdbc.kernel.exps.Exp;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;

public class WhenCondition
implements Exp {
    private final Exp _exp;
    private final Val _val;

    public WhenCondition(Exp exp, Val val) {
        this._exp = exp;
        this._val = val;
    }

    public Exp getExp() {
        return this._exp;
    }

    public Val getVal() {
        return this._val;
    }

    public Class getType() {
        return this._val.getType();
    }

    public ExpState initialize(Select sel, ExpContext ctx, Map contains) {
        ExpState s1 = this._exp.initialize(sel, ctx, contains);
        ExpState s2 = this._val.initialize(sel, ctx, 0);
        return new BinaryOpExpState(sel.and(s1.joins, s2.joins), s1, s2);
    }

    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer buf) {
        BinaryOpExpState bstate = (BinaryOpExpState)state;
        buf.append(" WHEN ");
        this._exp.appendTo(sel, ctx, bstate.state1, buf);
        buf.append(" THEN ");
        this._val.appendTo(sel, ctx, bstate.state2, buf, 0);
    }

    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        BinaryOpExpState bstate = (BinaryOpExpState)state;
        this._exp.selectColumns(sel, ctx, bstate.state1, pks);
        this._val.selectColumns(sel, ctx, bstate.state2, pks);
    }

    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter((Expression)this);
        this._exp.acceptVisit(visitor);
        this._val.acceptVisit(visitor);
        visitor.exit((Expression)this);
    }

    public int getId() {
        return 15;
    }
}

