/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import org.apache.openjpa.jdbc.kernel.exps.Const;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.Literal;

public class TypeLit
extends Const
implements Literal {
    private Object _val;
    private int _ptype;

    public TypeLit(Object val, int ptype) {
        this._val = val;
        this._ptype = ptype;
    }

    public Class getType() {
        return this._val == null ? Object.class : this._val.getClass();
    }

    public void setImplicitType(Class type) {
        this._val = Filters.convert((Object)this._val, (Class)type);
    }

    public int getParseType() {
        return this._ptype;
    }

    public Object getValue() {
        return this._val;
    }

    public void setValue(Object val) {
        this._val = val;
    }

    public Object getValue(Object[] params) {
        return this.getValue();
    }

    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        return new LitExpState();
    }

    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        super.calculateValue(sel, ctx, state, other, otherState);
        LitExpState lstate = (LitExpState)state;
        lstate.mapping = (ClassMapping)this.getMetaData();
        lstate.disc = lstate.mapping.getDiscriminator();
        lstate.discValue = lstate.disc != null ? lstate.disc.getValue() : null;
        sel.select(((ClassMapping)this.getMetaData()).getPrimaryKeyColumns(), lstate.joins);
    }

    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql, int index) {
        LitExpState lstate = (LitExpState)state;
        if (lstate.otherLength > 1) {
            sql.appendValue(((Object[])lstate.sqlValue)[index], lstate.getColumn(index));
        } else if (lstate.discValue != null) {
            sql.append(this.getDiscriminator(lstate));
        } else {
            sql.append("1");
        }
    }

    private String getDiscriminator(LitExpState lstate) {
        StringBuffer disc = new StringBuffer(lstate.discValue.toString());
        switch (lstate.disc.getJavaType()) {
            case 5: {
                return disc.toString();
            }
        }
        return disc.insert(0, "'").append("'").toString();
    }

    private static class LitExpState
    extends Const.ConstExpState {
        public Object sqlValue;
        public int otherLength;
        public ClassMapping mapping = null;
        public Discriminator disc = null;
        public Object discValue = null;

        private LitExpState() {
        }
    }
}

