/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.kernel.exps.Const;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Type;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.Parameter;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.ImplHelper;

public class CollectionParam
extends Const
implements Parameter {
    private static final Localizer _loc = Localizer.forPackage(CollectionParam.class);
    private final Object _key;
    private Class _type = null;
    private int _idx = -1;
    private boolean _container = false;

    public CollectionParam(Object key, Class type) {
        this._key = key;
        this.setImplicitType(type);
    }

    public Object getParameterKey() {
        return this._key;
    }

    public Class getType() {
        return this._type;
    }

    public void setImplicitType(Class type) {
        this._type = type;
        this._container = !(this.getMetaData() != null && ImplHelper.isManagedType((OpenJPAConfiguration)this.getMetaData().getRepository().getConfiguration(), (Class)type) || !Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type));
    }

    public int getIndex() {
        return this._idx;
    }

    public void setIndex(int idx) {
        this._idx = idx;
    }

    public Object getValue(Object[] params) {
        return Filters.convert((Object)params[this._idx], (Class)this.getType());
    }

    public Object getValue(ExpContext ctx, ExpState state) {
        ParamExpState pstate = (ParamExpState)state;
        if (pstate.discValue[0] != null) {
            return Arrays.asList(pstate.discValue);
        }
        return this.getValue(ctx.params);
    }

    public Object getSQLValue(Select sel, ExpContext ctx, ExpState state) {
        return ((ParamExpState)state).sqlValue;
    }

    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        return new ParamExpState(ctx.params[this._idx]);
    }

    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        super.calculateValue(sel, ctx, state, other, otherState);
        ParamExpState pstate = (ParamExpState)state;
        Object value = this.getValue(ctx.params);
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException(_loc.get("not-collection-parm", this._key).toString());
        }
        if (((Collection)value).isEmpty()) {
            throw new IllegalArgumentException(_loc.get("empty-collection-parm", this._key).toString());
        }
        Iterator itr = ((Collection)value).iterator();
        for (int i = 0; i < pstate.size && itr.hasNext(); ++i) {
            Object val = itr.next();
            if (other != null && !this._container) {
                pstate.sqlValue[i] = other.toDataStoreValue(sel, ctx, otherState, val);
                pstate.otherLength[i] = other.length(sel, ctx, otherState);
                if (!(other instanceof Type)) continue;
                pstate.mapping[i] = ctx.store.getConfiguration().getMappingRepositoryInstance().getMapping((Class)val, ctx.store.getContext().getClassLoader(), true);
                pstate.disc[i] = pstate.mapping[i].getDiscriminator();
                pstate.discValue[i] = pstate.disc != null ? pstate.disc[i].getValue() : null;
                continue;
            }
            if (ImplHelper.isManageable(val)) {
                ClassMapping mapping = ctx.store.getConfiguration().getMappingRepositoryInstance().getMapping(val.getClass(), ctx.store.getContext().getClassLoader(), true);
                pstate.sqlValue[i] = mapping.toDataStoreValue(val, mapping.getPrimaryKeyColumns(), ctx.store);
                pstate.otherLength[i] = mapping.getPrimaryKeyColumns().length;
                continue;
            }
            pstate.sqlValue[i] = val;
        }
    }

    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql, int index) {
        ParamExpState pstate = (ParamExpState)state;
        for (int i = 0; i < pstate.size; ++i) {
            if (pstate.otherLength[i] > 1) {
                sql.appendValue(((Object[])pstate.sqlValue[i])[index], pstate.getColumn(index), this);
                continue;
            }
            if (pstate.cols != null) {
                sql.appendValue(pstate.sqlValue[i], pstate.getColumn(index), this);
                continue;
            }
            if (pstate.discValue[i] != null) {
                sql.appendValue(pstate.discValue[i]);
                continue;
            }
            sql.appendValue(pstate.sqlValue[i], pstate.getColumn(index), this);
        }
    }

    public static class ParamExpState
    extends Const.ConstExpState {
        public int size = 0;
        public Object[] sqlValue = null;
        public int[] otherLength;
        public ClassMapping[] mapping = null;
        public Discriminator[] disc = null;
        public Object[] discValue = null;

        ParamExpState(Object params) {
            if (params instanceof Collection) {
                this.size = ((Collection)params).size();
            }
            this.sqlValue = new Object[this.size];
            this.otherLength = new int[this.size];
            this.mapping = new ClassMapping[this.size];
            this.disc = new Discriminator[this.size];
            this.discValue = new Object[this.size];
            for (int i = 0; i < this.size; ++i) {
                this.sqlValue[i] = null;
                this.otherLength[i] = 1;
                this.mapping[i] = null;
                this.disc[i] = null;
                this.discValue[i] = null;
            }
        }
    }
}

