/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.PreparedQueryCacheImpl;
import org.apache.openjpa.jdbc.kernel.SelectResultObjectProvider;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.LogicalUnion;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SelectExecutor;
import org.apache.openjpa.jdbc.sql.SelectImpl;
import org.apache.openjpa.jdbc.sql.Union;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.PreparedQuery;
import org.apache.openjpa.kernel.PreparedQueryCache;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.QueryImpl;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.lib.rop.RangeResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreparedQueryImpl
implements PreparedQuery {
    private static Localizer _loc = Localizer.forPackage(PreparedQueryImpl.class);
    private final String _id;
    private String _sql;
    private boolean _initialized;
    private Class<?> _candidate;
    private boolean _subclasses;
    private QueryExpressions[] _exps;
    private Class<?>[] _projTypes;
    private Map<Object, int[]> _userParamPositions;
    private Map<Integer, Object> _template;
    private SelectImpl select;

    public PreparedQueryImpl(String id, Query compiled) {
        this(id, null, compiled);
    }

    public PreparedQueryImpl(String id, String sql, Query compiled) {
        this._id = id;
        this._sql = sql;
        if (compiled != null) {
            this._candidate = compiled.getCandidateType();
            this._subclasses = compiled.hasSubclasses();
        }
    }

    public String getIdentifier() {
        return this._id;
    }

    public String getLanguage() {
        return "openjpa.prepared.SQL";
    }

    public String getOriginalQuery() {
        return this.getIdentifier();
    }

    public String getTargetQuery() {
        return this._sql;
    }

    void setTargetQuery(String sql) {
        this._sql = sql;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public QueryExpressions[] getQueryExpressions() {
        return this._exps;
    }

    public Class[] getProjectionTypes() {
        return this._projTypes;
    }

    public void setInto(Query q) {
        q.setQuery((Object)this._id);
        q.setCandidateType(this._candidate, this._subclasses);
    }

    public PreparedQueryCache.Exclusion initialize(Object result) {
        if (this.isInitialized()) {
            return null;
        }
        Object[] extract = this.extractSelectExecutor(result);
        SelectExecutor selector = (SelectExecutor)extract[0];
        if (selector == null) {
            return new PreparedQueryCacheImpl.StrongExclusion(this._id, ((Localizer.Message)extract[1]).getMessage());
        }
        if (selector == null || selector.hasMultipleSelects() || selector instanceof Union && ((Union)selector).getSelects().length != 1) {
            return new PreparedQueryCacheImpl.StrongExclusion(this._id, _loc.get("exclude-multi-select").getMessage());
        }
        this.select = this.extractImplementation(selector);
        if (this.select == null) {
            return new PreparedQueryCacheImpl.StrongExclusion(this._id, _loc.get("exclude-no-select").getMessage());
        }
        SQLBuffer buffer = selector.getSQL();
        if (buffer == null) {
            return new PreparedQueryCacheImpl.StrongExclusion(this._id, _loc.get("exclude-no-sql").getMessage());
        }
        this.setTargetQuery(buffer.getSQL());
        this.setParameters(buffer.getParameters());
        this.setUserParameterPositions(buffer.getUserParameters());
        this._initialized = true;
        return null;
    }

    private Object[] extractSelectExecutor(Object result) {
        if (!(result instanceof ResultList)) {
            return new Object[]{null, _loc.get("exclude-not-result")};
        }
        Object userObject = ((ResultList)result).getUserObject();
        if (userObject == null || !userObject.getClass().isArray() || ((Object[])userObject).length != 2) {
            return new Object[]{null, _loc.get("exclude-no-user-object")};
        }
        Object provider = ((Object[])userObject)[0];
        Object executor = ((Object[])userObject)[1];
        if (!(executor instanceof StoreQuery.Executor)) {
            return new Object[]{null, _loc.get("exclude-not-executor")};
        }
        this._exps = ((StoreQuery.Executor)executor).getQueryExpressions();
        if (this._exps[0].projections.length == 0) {
            this._projTypes = StoreQuery.EMPTY_CLASSES;
        } else {
            this._projTypes = new Class[this._exps[0].projections.length];
            for (int i = 0; i < this._exps[0].projections.length; ++i) {
                this._projTypes[i] = this._exps[0].projections[i].getType();
            }
        }
        if (provider instanceof QueryImpl.PackingResultObjectProvider) {
            provider = ((QueryImpl.PackingResultObjectProvider)provider).getDelegate();
        }
        if (provider instanceof RangeResultObjectProvider) {
            provider = ((RangeResultObjectProvider)provider).getDelegate();
        }
        if (provider instanceof SelectResultObjectProvider) {
            return new Object[]{((SelectResultObjectProvider)provider).getSelect(), null};
        }
        return new Object[]{null, _loc.get("exclude-not-select-rop", provider)};
    }

    private SelectImpl extractImplementation(SelectExecutor selector) {
        if (selector == null) {
            return null;
        }
        if (selector instanceof SelectImpl) {
            return (SelectImpl)selector;
        }
        if (selector instanceof LogicalUnion.UnionSelect) {
            return ((LogicalUnion.UnionSelect)selector).getDelegate();
        }
        if (selector instanceof Union) {
            return this.extractImplementation(((Union)selector).getSelects()[0]);
        }
        return null;
    }

    public Map<Integer, Object> reparametrize(Map user, Broker broker) {
        if (!this.isInitialized()) {
            throw new InternalException("reparameterize() on uninitialized.");
        }
        if (user == null || user.isEmpty()) {
            if (!this._userParamPositions.isEmpty()) {
                throw new UserException(_loc.get("uparam-null", this._userParamPositions.keySet(), (Object)this));
            }
            return this._template;
        }
        if (!((Object)this._userParamPositions.keySet()).equals(user.keySet())) {
            throw new UserException(_loc.get("uparam-mismatch", this._userParamPositions.keySet(), user.keySet(), (Object)this));
        }
        HashMap<Integer, Object> result = new HashMap<Integer, Object>(this._template);
        for (Object key : user.keySet()) {
            int[] indices = this._userParamPositions.get(key);
            if (indices == null || indices.length == 0) {
                throw new UserException(_loc.get("uparam-no-pos", key, (Object)this));
            }
            Object val = user.get(key);
            if (ImplHelper.isManageable(val)) {
                this.setPersistenceCapableParameter(result, val, indices, broker);
                continue;
            }
            if (val instanceof Collection) {
                this.setCollectionValuedParameter(result, (Collection)val, indices, key);
                continue;
            }
            for (int j : indices) {
                result.put(j, val);
            }
        }
        return result;
    }

    private void setPersistenceCapableParameter(Map<Integer, Object> result, Object pc, int[] indices, Broker broker) {
        Column[] pks;
        JDBCStore store = (JDBCStore)broker.getStoreManager().getInnermostDelegate();
        MappingRepository repos = store.getConfiguration().getMappingRepositoryInstance();
        ClassMapping mapping = repos.getMapping(pc.getClass(), broker.getClassLoader(), true);
        Object cols = mapping.toDataStoreValue(pc, pks = mapping.getPrimaryKeyColumns(), store);
        if (cols instanceof Object[]) {
            Object[] array = (Object[])cols;
            int n = array.length;
            if (n > indices.length || indices.length % n != 0) {
                throw new UserException(_loc.get("uparam-pc-key", pc.getClass(), (Object)n, (Object)Arrays.toString(indices)));
            }
            int k = 0;
            for (int j : indices) {
                result.put(j, array[k % n]);
                ++k;
            }
        } else {
            for (int j : indices) {
                result.put(j, cols);
            }
        }
    }

    private void setCollectionValuedParameter(Map<Integer, Object> result, Collection values, int[] indices, Object param) {
        int n = values.size();
        Object[] array = values.toArray();
        if (n > indices.length || indices.length % n != 0) {
            throw new UserException(_loc.get("uparam-coll-size", param, (Object)values, (Object)Arrays.toString(indices)));
        }
        int k = 0;
        for (int j : indices) {
            result.put(j, array[k % n]);
            ++k;
        }
    }

    void setUserParameterPositions(List list) {
        this._userParamPositions = new HashMap<Object, int[]>();
        for (int i = 1; list != null && i < list.size(); i += 2) {
            Object key = list.get(i);
            int p = (Integer)list.get(i - 1);
            int[] positions = this._userParamPositions.get(key);
            if (positions == null) {
                positions = new int[]{p};
            } else {
                int[] temp = new int[positions.length + 1];
                System.arraycopy(positions, 0, temp, 0, positions.length);
                temp[positions.length] = p;
                positions = temp;
            }
            this._userParamPositions.put(key, positions);
        }
    }

    void setParameters(List list) {
        HashMap tmp = new HashMap();
        for (int i = 0; list != null && i < list.size(); ++i) {
            tmp.put(i, list.get(i));
        }
        this._template = Collections.unmodifiableMap(tmp);
    }

    SelectImpl getSelect() {
        return this.select;
    }

    public String toString() {
        return "PreparedQuery: [" + this.getOriginalQuery() + "] --> [" + this.getTargetQuery() + "]";
    }
}

