/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CombinationGenerator {
    private List<List> dimensions = new ArrayList<List>();

    public void addDimension(List dim) {
        if (dim == null || dim.isEmpty()) {
            return;
        }
        this.dimensions.add(dim);
    }

    public void addDimension(Object[] dim) {
        if (dim == null || dim.length == 0) {
            return;
        }
        this.dimensions.add(Arrays.asList(dim));
    }

    public List[] generate() {
        int comboSize = this.getSize();
        int dimsSize = this.dimensions.size();
        List[] result = new ArrayList[comboSize];
        for (int i = 0; i < comboSize; ++i) {
            ArrayList<Object> elem = new ArrayList<Object>(dimsSize);
            for (int j = 0; j < dimsSize; ++j) {
                elem.add(null);
            }
            result[i] = elem;
        }
        int dimRepeatingStep = 1;
        for (int dimIndex = 0; dimIndex < dimsSize; ++dimIndex) {
            List dimValueList = this.dimensions.get(dimIndex);
            int valuListSize = dimValueList.size();
            for (int j = 0; j < comboSize; ++j) {
                result[j].set(dimIndex, dimValueList.get(j / dimRepeatingStep % valuListSize));
            }
            dimRepeatingStep *= valuListSize;
        }
        return result;
    }

    public int getSize() {
        int size = 1;
        for (List d : this.dimensions) {
            size *= d.size();
        }
        return size;
    }
}

