/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.integration.daytrader;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.openjpa.integration.daytrader.HoldingDataBean;
import org.apache.openjpa.integration.daytrader.TradeAction;
import org.apache.openjpa.integration.daytrader.TradeConfig;

public class TradeScenario {
    private TradeAction tAction = null;

    public TradeScenario(TradeAction tAction) {
        this.tAction = tAction;
    }

    public boolean performUserTasks(String userID) {
        StringBuilder sb = new StringBuilder(16384);
        boolean brc = false;
        if (TradeConfig.log.isTraceEnabled()) {
            TradeConfig.log.trace((Object)("TradeScenario.performUserTasks(" + userID + ")"));
        }
        try {
            this.log(sb, this.performTask("l", userID));
            this.log(sb, this.performTask("h", userID));
            this.log(sb, this.performTask("a", userID));
            this.log(sb, this.performTask("u", userID));
            this.log(sb, this.performTask("h", userID));
            this.log(sb, this.performTask("p", userID));
            this.log(sb, this.performTask("s", userID));
            this.log(sb, this.performTask("b", userID));
            this.log(sb, this.performTask("h", userID));
            this.log(sb, this.performTask("p", userID));
            this.log(sb, this.performTask("s", userID));
            this.log(sb, this.performTask("b", userID));
            this.log(sb, this.performTask("h", userID));
            this.log(sb, this.performTask("a", userID));
            this.log(sb, this.performTask("o", userID));
            brc = true;
            if (TradeConfig.log.isTraceEnabled()) {
                TradeConfig.log.trace((Object)sb.toString());
            }
        }
        catch (Exception e) {
            TradeConfig.log.error((Object)("TradeScenario.performUserTasks(" + userID + ") failed"), (Throwable)e);
        }
        return brc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String performTask(String scenarioAction, String userID) throws IOException {
        StringBuilder sb = new StringBuilder(256);
        String results = "";
        int action = 32;
        Object dispPath = null;
        if (scenarioAction != null && scenarioAction.length() >= 1 && (action = (int)scenarioAction.charAt(0)) == 110) {
            try {
                this.log(sb, "TradeScenario.performTask() scenarioAction=" + scenarioAction + ", userID=" + userID);
            }
            catch (Exception e) {
                this.log(sb, "ERROR - TradeScenario.performTask() - Exception ", e);
            }
            finally {
                return sb.toString();
            }
        }
        if (userID == null || userID.trim().length() == 0) {
            userID = null;
            action = 108;
            TradeConfig.incrementScenarioCount();
        } else if (action == 32) {
            action = TradeConfig.getScenarioAction(userID.startsWith("ru:"));
        }
        switch (action) {
            case 113: {
                this.tAction.doQuotes(sb, userID, TradeConfig.rndSymbols());
                break;
            }
            case 97: {
                this.tAction.doAccount(sb, userID, results);
                break;
            }
            case 117: {
                String fullName = "rnd" + System.currentTimeMillis();
                String address = "rndAddress";
                String password = "xxx";
                String email = "rndEmail";
                String creditcard = "rndCC";
                this.tAction.doAccountUpdate(sb, userID, password, password, fullName, address, creditcard, email);
                break;
            }
            case 104: {
                this.tAction.doHome(sb, userID, results);
                break;
            }
            case 108: {
                userID = TradeConfig.getUserID();
                String password2 = "xxx";
                boolean brc = this.tAction.doLogin(sb, userID, password2);
                if (brc) break;
                this.log(sb, "TradeScenario login failed. Reset DB between runs.");
                break;
            }
            case 111: {
                this.tAction.doLogout(sb, userID);
                break;
            }
            case 112: {
                this.tAction.doPortfolio(sb, userID, results);
                break;
            }
            case 114: {
                this.tAction.doLogout(sb, userID);
                userID = TradeConfig.rndNewUserID();
                String passwd = "yyy";
                String fullName = TradeConfig.rndFullName();
                String creditcard = TradeConfig.rndCreditCard();
                String money = TradeConfig.rndBalance();
                String email = TradeConfig.rndEmail(userID);
                String smail = TradeConfig.rndAddress();
                this.tAction.doRegister(sb, userID, passwd, passwd, fullName, creditcard, money, email, smail);
                break;
            }
            case 115: {
                Collection<HoldingDataBean> holdings = this.tAction.getHoldings(userID);
                int numHoldings = holdings.size();
                if (numHoldings > 0) {
                    Iterator<HoldingDataBean> it = holdings.iterator();
                    boolean foundHoldingToSell = false;
                    while (it.hasNext()) {
                        HoldingDataBean holdingData = it.next();
                        if (holdingData.getPurchaseDate().equals(new Date(0L))) continue;
                        Integer holdingID = holdingData.getHoldingID();
                        this.tAction.doSell(sb, userID, holdingID);
                        foundHoldingToSell = true;
                        break;
                    }
                    if (foundHoldingToSell) break;
                    TradeAction.log.warn((Object)("TradeScenario: No holdings sold for userID=" + userID + ", holdings=" + numHoldings));
                } else {
                    TradeAction.log.warn((Object)("TradeScenario: No holdings to sell for userID=" + userID));
                }
                TradeAction.log.warn((Object)("TradeScenario: No holdings sold - switching to buy -- userID=" + userID));
                if (!userID.startsWith("ru:")) {
                    TradeConfig.incrementSellDeficit();
                }
            }
            case 98: {
                String symbol = TradeConfig.rndSymbol();
                String amount = TradeConfig.rndQuantity() + "";
                this.tAction.doQuotes(sb, userID, symbol);
                this.tAction.doBuy(sb, userID, symbol, amount);
            }
        }
        this.log(sb, "Results", results);
        return sb.toString();
    }

    private void log(StringBuilder sb, String msg) {
        if (TradeAction.log != null) {
            if (TradeAction.log.isTraceEnabled()) {
                sb.append(msg);
                sb.append(System.getProperty("line.separator"));
            }
        }
    }

    private void log(StringBuilder sb, String msg, Object obj) {
        if (TradeAction.log != null) {
            if (TradeAction.log.isTraceEnabled()) {
                sb.append(msg);
                sb.append(" = ");
                sb.append(obj);
                sb.append(System.getProperty("line.separator"));
            }
        }
    }
}

