/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.integration.daytrader;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.persistence.Query;
import org.apache.openjpa.integration.daytrader.AccountDataBean;
import org.apache.openjpa.integration.daytrader.AccountProfileDataBean;
import org.apache.openjpa.integration.daytrader.HoldingDataBean;
import org.apache.openjpa.integration.daytrader.MarketSummaryDataBean;
import org.apache.openjpa.integration.daytrader.OrderDataBean;
import org.apache.openjpa.integration.daytrader.QuoteDataBean;
import org.apache.openjpa.integration.daytrader.TradeConfig;
import org.apache.openjpa.lib.log.Log;

public class TradeJPADirect {
    @PersistenceUnit(unitName="daytrader")
    private static EntityManagerFactory emf;
    private static BigDecimal ZERO;
    private static boolean initialized;
    protected static Log log;

    public TradeJPADirect(Log log, EntityManagerFactory emf) {
        TradeJPADirect.log = log;
        TradeJPADirect.emf = emf;
        if (!initialized) {
            TradeJPADirect.init();
        }
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        TradeConfig.setPublishQuotePriceChange(false);
        initialized = true;
    }

    public static void destroy() {
        try {
            if (!initialized) {
                return;
            }
            log.trace((Object)"TradeJPADirect:destroy");
        }
        catch (Exception e) {
            log.error((Object)"TradeJPADirect:destroy", (Throwable)e);
        }
    }

    public MarketSummaryDataBean getMarketSummary() {
        MarketSummaryDataBean marketSummaryData;
        EntityManager entityManager = emf.createEntityManager();
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"TradeJPADirect:getMarketSummary -- getting market summary");
            }
            Query query = entityManager.createNamedQuery("quoteejb.quotesByChange");
            List quotes = query.getResultList();
            QuoteDataBean[] quoteArray = quotes.toArray(new QuoteDataBean[quotes.size()]);
            ArrayList<QuoteDataBean> topGainers = new ArrayList<QuoteDataBean>(5);
            ArrayList<QuoteDataBean> topLosers = new ArrayList<QuoteDataBean>(5);
            BigDecimal TSIA = new BigDecimal(0.0).setScale(2);
            BigDecimal openTSIA = new BigDecimal(0.0).setScale(2);
            double totalVolume = 0.0;
            if (quoteArray.length > 5) {
                int i;
                for (i = 0; i < 5; ++i) {
                    topGainers.add(quoteArray[i]);
                }
                for (i = quoteArray.length - 1; i >= quoteArray.length - 5; --i) {
                    topLosers.add(quoteArray[i]);
                }
                for (QuoteDataBean quote : quoteArray) {
                    BigDecimal price = quote.getPrice();
                    BigDecimal open = quote.getOpen();
                    double volume = quote.getVolume();
                    TSIA = TSIA.add(price);
                    openTSIA = openTSIA.add(open);
                    totalVolume += volume;
                }
                TSIA = TSIA.divide(new BigDecimal(quoteArray.length), 4);
                openTSIA = openTSIA.divide(new BigDecimal(quoteArray.length), 4);
            }
            marketSummaryData = new MarketSummaryDataBean(TSIA, openTSIA, totalVolume, topGainers, topLosers);
        }
        catch (Exception e) {
            log.error((Object)"TradeJPADirect:getMarketSummary", (Throwable)e);
            throw new RuntimeException("TradeJPADirect:getMarketSummary -- error ", e);
        }
        finally {
            entityManager.close();
        }
        return marketSummaryData;
    }

    public OrderDataBean buy(String userID, String symbol, double quantity, int orderProcessingMode) {
        OrderDataBean order = null;
        EntityManager entityManager = emf.createEntityManager();
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("TradeJPADirect:buy - userID=" + userID + " symbol=" + symbol + " quantity=" + quantity));
            }
            entityManager.getTransaction().begin();
            AccountProfileDataBean profile = (AccountProfileDataBean)entityManager.find(AccountProfileDataBean.class, (Object)userID);
            AccountDataBean account = profile.getAccount();
            QuoteDataBean quote = (QuoteDataBean)entityManager.find(QuoteDataBean.class, (Object)symbol);
            HoldingDataBean holding = null;
            order = this.createOrder(account, quote, holding, "buy", quantity, entityManager);
            BigDecimal price = quote.getPrice();
            BigDecimal orderFee = order.getOrderFee();
            BigDecimal balance = account.getBalance();
            BigDecimal total = new BigDecimal(quantity).multiply(price).add(orderFee);
            account.setBalance(balance.subtract(total));
            entityManager.getTransaction().commit();
            if (orderProcessingMode == 0) {
                this.completeOrder(order.getOrderID(), false);
            } else if (orderProcessingMode == 1) {
                this.queueOrder(order.getOrderID(), true);
            }
        }
        catch (Exception e) {
            log.error((Object)("TradeJPADirect:buy(" + userID + "," + symbol + "," + quantity + ") --> failed"), (Throwable)e);
            if (order != null) {
                order.cancel();
            }
            if (entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().rollback();
            }
            throw new RuntimeException(e);
        }
        finally {
            if (entityManager != null) {
                entityManager.close();
                entityManager = null;
            }
        }
        this.updateQuotePriceVolume(symbol, TradeConfig.getRandomPriceChangeFactor(), quantity);
        return order;
    }

    public OrderDataBean sell(String userID, Integer holdingID, int orderProcessingMode) {
        EntityManager entityManager = emf.createEntityManager();
        OrderDataBean order = null;
        try {
            entityManager.getTransaction().begin();
            if (log.isTraceEnabled()) {
                log.trace((Object)("TradeJPADirect:sell - userID=" + userID + " holding=" + holdingID));
            }
            AccountProfileDataBean profile = (AccountProfileDataBean)entityManager.find(AccountProfileDataBean.class, (Object)userID);
            AccountDataBean account = profile.getAccount();
            HoldingDataBean holding = (HoldingDataBean)entityManager.find(HoldingDataBean.class, (Object)holdingID);
            if (holding == null) {
                log.error((Object)("TradeJPADirect:sell User " + userID + " attempted to sell holding " + holdingID + " which has already been sold"));
                OrderDataBean orderData = new OrderDataBean();
                orderData.setOrderStatus("cancelled");
                entityManager.persist((Object)orderData);
                entityManager.getTransaction().commit();
                OrderDataBean orderDataBean = orderData;
                return orderDataBean;
            }
            QuoteDataBean quote = holding.getQuote();
            double quantity = holding.getQuantity();
            order = this.createOrder(account, quote, holding, "sell", quantity, entityManager);
            holding.setPurchaseDate(new Timestamp(0L));
            BigDecimal price = quote.getPrice();
            BigDecimal orderFee = order.getOrderFee();
            BigDecimal balance = account.getBalance();
            BigDecimal total = new BigDecimal(quantity).multiply(price).subtract(orderFee);
            account.setBalance(balance.add(total));
            entityManager.getTransaction().commit();
            if (orderProcessingMode == 0) {
                this.completeOrder(order.getOrderID(), false);
            } else if (orderProcessingMode == 1) {
                this.queueOrder(order.getOrderID(), true);
            }
        }
        catch (Exception e) {
            log.error((Object)("TradeJPADirect:sell(" + userID + "," + holdingID + ") --> failed"), (Throwable)e);
            if (order != null) {
                order.cancel();
            }
            entityManager.getTransaction().rollback();
            throw new RuntimeException("TradeJPADirect:sell(" + userID + "," + holdingID + ")", e);
        }
        finally {
            if (entityManager != null) {
                entityManager.close();
                entityManager = null;
            }
        }
        if (!order.getOrderStatus().equalsIgnoreCase("cancelled")) {
            this.updateQuotePriceVolume(order.getSymbol(), TradeConfig.getRandomPriceChangeFactor(), order.getQuantity());
        }
        return order;
    }

    public void queueOrder(Integer orderID, boolean twoPhase) {
        log.error((Object)"TradeJPADirect:queueOrder() not implemented for this runtime mode");
        throw new UnsupportedOperationException("TradeJPADirect:queueOrder() not implemented for this runtime mode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderDataBean completeOrder(Integer orderID, boolean twoPhase) throws Exception {
        EntityManager entityManager = emf.createEntityManager();
        OrderDataBean order = null;
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:completeOrder - orderId=" + orderID + " twoPhase=" + twoPhase));
        }
        try {
            order = (OrderDataBean)entityManager.find(OrderDataBean.class, (Object)orderID);
            order.getQuote();
            if (order == null) {
                log.error((Object)("TradeJPADirect:completeOrder -- Unable to find orderID=" + orderID));
                OrderDataBean orderDataBean = null;
                return orderDataBean;
            }
            if (order.isCompleted()) {
                throw new RuntimeException("Error: attempt to complete Order that is already completed\n" + order);
            }
            AccountDataBean account = order.getAccount();
            QuoteDataBean quote = order.getQuote();
            HoldingDataBean holding = order.getHolding();
            BigDecimal price = order.getPrice();
            double quantity = order.getQuantity();
            String userID = account.getProfile().getUserID();
            if (log.isTraceEnabled()) {
                log.trace((Object)("TradeJPADirect:completeOrder--> Completing Order " + order.getOrderID() + "\n\t Order info: " + order + "\n\t Account info: " + account + "\n\t Quote info: " + quote + "\n\t Holding info: " + holding));
            }
            HoldingDataBean newHolding = null;
            if (order.isBuy()) {
                newHolding = this.createHolding(account, quote, quantity, price, entityManager);
            }
            entityManager.getTransaction().begin();
            if (newHolding != null) {
                order.setHolding(newHolding);
            }
            if (order.isSell()) {
                if (holding == null) {
                    log.error((Object)("TradeJPADirect:completeOrder -- Unable to sell order " + order.getOrderID() + ", holding already sold (null)"));
                    order.cancel();
                    entityManager.getTransaction().commit();
                    OrderDataBean orderDataBean = order;
                    return orderDataBean;
                }
                entityManager.remove((Object)holding);
                order.setHolding(null);
            }
            order.setOrderStatus("closed");
            order.setCompletionDate(new Timestamp(System.currentTimeMillis()));
            entityManager.persist((Object)order);
            entityManager.getTransaction().commit();
            if (log.isTraceEnabled()) {
                log.trace((Object)("TradeJPADirect:completeOrder--> Completed Order " + order.getOrderID() + "\n\t Order info: " + order + "\n\t Account info: " + account + "\n\t Quote info: " + quote + "\n\t Holding info: " + newHolding));
            }
        }
        catch (Exception e) {
            log.error((Object)("TradeJPADirect:completeOrder() failed for orderID=" + orderID), (Throwable)e);
            if (entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().rollback();
            }
        }
        finally {
            if (entityManager != null) {
                entityManager.close();
                entityManager = null;
            }
        }
        return order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelOrder(Integer orderID, boolean twoPhase) {
        EntityManager entityManager = emf.createEntityManager();
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:cancelOrder - orderId=" + orderID + " twoPhase=" + twoPhase));
        }
        OrderDataBean order = (OrderDataBean)entityManager.find(OrderDataBean.class, (Object)orderID);
        try {
            entityManager.getTransaction().begin();
            order.cancel();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
    }

    public void orderCompleted(String userID, Integer orderID) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeAction:orderCompleted - userID=" + userID + " orderID=" + orderID));
        }
    }

    public Collection<OrderDataBean> getOrders(String userID) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:getOrders - userID=" + userID));
        }
        EntityManager entityManager = emf.createEntityManager();
        AccountProfileDataBean profile = (AccountProfileDataBean)entityManager.find(AccountProfileDataBean.class, (Object)userID);
        AccountDataBean account = profile.getAccount();
        entityManager.close();
        return account.getOrders();
    }

    public Collection<OrderDataBean> getClosedOrders(String userID) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:getClosedOrders - userID=" + userID));
        }
        EntityManager entityManager = emf.createEntityManager();
        try {
            entityManager.getTransaction().begin();
            Query query = entityManager.createNamedQuery("orderejb.closedOrders");
            query.setParameter("userID", (Object)userID);
            entityManager.getTransaction().commit();
            List results = query.getResultList();
            for (OrderDataBean thisOrder : results) {
                thisOrder.getQuote();
            }
            if (TradeConfig.jpaLayer == 0) {
                Query updateStatus = entityManager.createNamedQuery("orderejb.completeClosedOrders");
                try {
                    entityManager.getTransaction().begin();
                    updateStatus.setParameter("userID", (Object)userID);
                    updateStatus.executeUpdate();
                    entityManager.getTransaction().commit();
                }
                catch (Exception e) {
                    entityManager.getTransaction().rollback();
                    entityManager.close();
                    entityManager = null;
                }
            } else if (TradeConfig.jpaLayer == 1) {
                Query findaccountid = entityManager.createNativeQuery("select a.ACCOUNTID, a.LOGINCOUNT, a.LOGOUTCOUNT, a.LASTLOGIN, a.CREATIONDATE, a.BALANCE, a.OPENBALANCE, a.PROFILE_USERID from accountejb a where a.profile_userid = ?", AccountDataBean.class);
                findaccountid.setParameter(1, (Object)userID);
                AccountDataBean account = (AccountDataBean)findaccountid.getSingleResult();
                Integer accountid = account.getAccountID();
                Query updateStatus = entityManager.createNativeQuery("UPDATE orderejb o SET o.orderStatus = 'completed' WHERE o.orderStatus = 'closed' AND o.ACCOUNT_ACCOUNTID  = ?");
                updateStatus.setParameter(1, (Object)accountid);
                updateStatus.executeUpdate();
            }
            if (entityManager != null) {
                entityManager.close();
                entityManager = null;
            }
            List list = results;
            return list;
        }
        catch (Exception e) {
            log.error((Object)"TradeJPADirect.getClosedOrders", (Throwable)e);
            entityManager.close();
            entityManager = null;
            throw new RuntimeException("TradeJPADirect.getClosedOrders - error", e);
        }
        finally {
            if (entityManager != null) {
                entityManager.close();
                entityManager = null;
            }
        }
    }

    public QuoteDataBean createQuote(String symbol, String companyName, BigDecimal price) {
        EntityManager entityManager = emf.createEntityManager();
        QuoteDataBean quote = null;
        try {
            quote = new QuoteDataBean(symbol, companyName, 0.0, price, price, price, price, 0.0);
            entityManager.getTransaction().begin();
            entityManager.persist((Object)quote);
            entityManager.getTransaction().commit();
            if (log.isTraceEnabled()) {
                log.trace((Object)("TradeJPADirect:createQuote-->" + quote));
            }
            QuoteDataBean quoteDataBean = quote;
            return quoteDataBean;
        }
        catch (Exception e) {
            log.error((Object)("TradeJPADirect:createQuote -- exception creating Quote=" + quote), (Throwable)e);
            if (entityManager.getTransaction().isActive()) {
                entityManager.getTransaction().rollback();
            }
            throw new RuntimeException(e);
        }
        finally {
            if (entityManager != null) {
                entityManager.close();
                entityManager = null;
            }
        }
    }

    public QuoteDataBean getQuote(String symbol) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:getQuote - symbol=" + symbol));
        }
        EntityManager entityManager = emf.createEntityManager();
        QuoteDataBean qdb = (QuoteDataBean)entityManager.find(QuoteDataBean.class, (Object)symbol);
        if (entityManager != null) {
            entityManager.close();
            entityManager = null;
        }
        return qdb;
    }

    public Collection<QuoteDataBean> getAllQuotes() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"TradeJPADirect:getAllQuotes");
        }
        EntityManager entityManager = emf.createEntityManager();
        Query query = entityManager.createNamedQuery("quoteejb.allQuotes");
        if (entityManager != null) {
            entityManager.close();
            entityManager = null;
        }
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuoteDataBean updateQuotePriceVolume(String symbol, BigDecimal changeFactor, double sharesTraded) {
        if (!TradeConfig.getUpdateQuotePrices()) {
            return new QuoteDataBean();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:updateQuote - symbol=" + symbol + "changeFactor=" + changeFactor));
        }
        EntityManager entityManager = emf.createEntityManager();
        QuoteDataBean quote = null;
        if (TradeConfig.jpaLayer == 1) {
            quote = (QuoteDataBean)entityManager.find(QuoteDataBean.class, (Object)symbol);
        } else if (TradeConfig.jpaLayer == 0) {
            Query q = entityManager.createNamedQuery("quoteejb.quoteForUpdate");
            q.setParameter(1, (Object)symbol);
            quote = (QuoteDataBean)q.getSingleResult();
        }
        BigDecimal oldPrice = quote.getPrice();
        if (quote.getPrice().equals(TradeConfig.PENNY_STOCK_PRICE)) {
            changeFactor = TradeConfig.PENNY_STOCK_RECOVERY_MIRACLE_MULTIPLIER;
        }
        BigDecimal newPrice = changeFactor.multiply(oldPrice).setScale(2, 4);
        try {
            quote.setPrice(newPrice);
            quote.setVolume(quote.getVolume() + sharesTraded);
            quote.setChange(newPrice.subtract(quote.getOpen()).doubleValue());
            entityManager.getTransaction().begin();
            entityManager.merge((Object)quote);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
        }
        finally {
            if (entityManager != null) {
                entityManager.close();
                entityManager = null;
            }
        }
        this.publishQuotePriceChange(quote, oldPrice, changeFactor, sharesTraded);
        return quote;
    }

    public Collection<HoldingDataBean> getHoldings(String userID) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:getHoldings - userID=" + userID));
        }
        EntityManager entityManager = emf.createEntityManager();
        entityManager.getTransaction().begin();
        Query query = entityManager.createNamedQuery("holdingejb.holdingsByUserID");
        query.setParameter("userID", (Object)userID);
        entityManager.getTransaction().commit();
        List holdings = query.getResultList();
        Iterator itr = holdings.iterator();
        while (itr.hasNext()) {
            ((HoldingDataBean)itr.next()).getQuote();
        }
        entityManager.close();
        entityManager = null;
        return holdings;
    }

    public HoldingDataBean getHolding(Integer holdingID) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:getHolding - holdingID=" + holdingID));
        }
        EntityManager entityManager = emf.createEntityManager();
        HoldingDataBean holding = (HoldingDataBean)entityManager.find(HoldingDataBean.class, (Object)holdingID);
        entityManager.close();
        return holding;
    }

    public AccountDataBean getAccountData(String userID) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:getAccountData - userID=" + userID));
        }
        EntityManager entityManager = emf.createEntityManager();
        AccountProfileDataBean profile = (AccountProfileDataBean)entityManager.find(AccountProfileDataBean.class, (Object)userID);
        AccountDataBean account = profile.getAccount();
        account.getProfile();
        account.setProfileID(profile.getUserID());
        entityManager.close();
        entityManager = null;
        return account;
    }

    public AccountProfileDataBean getAccountProfileData(String userID) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:getProfileData - userID=" + userID));
        }
        EntityManager entityManager = emf.createEntityManager();
        AccountProfileDataBean apb = (AccountProfileDataBean)entityManager.find(AccountProfileDataBean.class, (Object)userID);
        entityManager.close();
        entityManager = null;
        return apb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountProfileDataBean updateAccountProfile(AccountProfileDataBean profileData) {
        EntityManager entityManager = emf.createEntityManager();
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:updateAccountProfileData - profileData=" + profileData));
        }
        AccountProfileDataBean temp = (AccountProfileDataBean)entityManager.find(AccountProfileDataBean.class, (Object)profileData.getUserID());
        temp.setAddress(profileData.getAddress());
        temp.setPassword(profileData.getPassword());
        temp.setFullName(profileData.getFullName());
        temp.setCreditCard(profileData.getCreditCard());
        temp.setEmail(profileData.getEmail());
        try {
            entityManager.getTransaction().begin();
            entityManager.merge((Object)temp);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
        return temp;
    }

    public AccountDataBean login(String userID, String password) throws Exception {
        EntityManager entityManager = emf.createEntityManager();
        AccountProfileDataBean profile = (AccountProfileDataBean)entityManager.find(AccountProfileDataBean.class, (Object)userID);
        if (profile == null) {
            throw new RuntimeException("No such user: " + userID);
        }
        entityManager.getTransaction().begin();
        entityManager.merge((Object)profile);
        AccountDataBean account = profile.getAccount();
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:login - userID=" + userID + " password=" + password));
        }
        account.login(password);
        entityManager.getTransaction().commit();
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:login(" + userID + "," + password + ") success" + account));
        }
        entityManager.close();
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(String userID) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:logout - userID=" + userID));
        }
        EntityManager entityManager = emf.createEntityManager();
        AccountProfileDataBean profile = (AccountProfileDataBean)entityManager.find(AccountProfileDataBean.class, (Object)userID);
        AccountDataBean account = profile.getAccount();
        try {
            entityManager.getTransaction().begin();
            account.logout();
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:logout(" + userID + ") success"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountDataBean register(String userID, String password, String fullname, String address, String email, String creditcard, BigDecimal openBalance) {
        AccountDataBean account = null;
        AccountProfileDataBean profile = null;
        EntityManager entityManager = emf.createEntityManager();
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:register - userID=" + userID));
        }
        if ((profile = (AccountProfileDataBean)entityManager.find(AccountProfileDataBean.class, (Object)userID)) != null) {
            log.error((Object)("Failed to register new Account - AccountProfile with userID(" + userID + ") already exists"));
            return null;
        }
        profile = new AccountProfileDataBean(userID, password, fullname, address, email, creditcard);
        account = new AccountDataBean(0, 0, null, new Timestamp(System.currentTimeMillis()), openBalance, openBalance, userID);
        profile.setAccount(account);
        account.setProfile(profile);
        try {
            entityManager.getTransaction().begin();
            entityManager.persist((Object)profile);
            entityManager.persist((Object)account);
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            log.error((Object)("Failed to create account and profile for userId=" + userID), (Throwable)e);
            entityManager.getTransaction().rollback();
        }
        finally {
            entityManager.close();
        }
        return account;
    }

    public void resetTrade(boolean deleteAll) throws Exception {
        new RuntimeException("TradeJPADirect:resetTrade - not implemented in JPA mode");
    }

    private void publishQuotePriceChange(QuoteDataBean quote, BigDecimal oldPrice, BigDecimal changeFactor, double sharesTraded) {
        if (!TradeConfig.getPublishQuotePriceChange()) {
            return;
        }
        log.error((Object)"TradeJPADirect:publishQuotePriceChange - is not implemented for this runtime mode");
        throw new UnsupportedOperationException("TradeJPADirect:publishQuotePriceChange - is not implemented for this runtime mode");
    }

    private OrderDataBean createOrder(AccountDataBean account, QuoteDataBean quote, HoldingDataBean holding, String orderType, double quantity, EntityManager entityManager) {
        OrderDataBean order;
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeJPADirect:createOrder(orderID= account=" + (account == null ? null : account.getAccountID()) + " quote=" + (quote == null ? null : quote.getSymbol()) + " orderType=" + orderType + " quantity=" + quantity));
        }
        try {
            order = new OrderDataBean(orderType, "open", new Timestamp(System.currentTimeMillis()), null, quantity, quote.getPrice().setScale(2, 4), TradeConfig.getOrderFee(orderType), account, quote, holding);
            entityManager.persist((Object)order);
        }
        catch (Exception e) {
            log.error((Object)"TradeJPADirect:createOrder -- failed to create Order", (Throwable)e);
            throw new RuntimeException("TradeJPADirect:createOrder -- failed to create Order", e);
        }
        return order;
    }

    private HoldingDataBean createHolding(AccountDataBean account, QuoteDataBean quote, double quantity, BigDecimal purchasePrice, EntityManager entityManager) throws Exception {
        HoldingDataBean newHolding = new HoldingDataBean(quantity, purchasePrice, new Timestamp(System.currentTimeMillis()), account, quote);
        try {
            entityManager.getTransaction().begin();
            entityManager.persist((Object)newHolding);
            entityManager.getTransaction().commit();
            if (log.isTraceEnabled()) {
                log.trace((Object)("TradeJPADirect:createHolding(account=" + (account == null ? null : account.getAccountID()) + " quote=" + (quote == null ? null : quote.getSymbol()) + " quantity=" + quantity + " purchasePrice=" + purchasePrice + ")"));
            }
        }
        catch (Exception e) {
            log.error((Object)("createHolding() failed for newHolding=" + newHolding), (Throwable)e);
            entityManager.getTransaction().rollback();
        }
        return newHolding;
    }

    public double investmentReturn(double investment, double NetValue) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"TradeJPADirect:investmentReturn");
        }
        double diff = NetValue - investment;
        double ir = diff / investment;
        return ir;
    }

    public QuoteDataBean pingTwoPhase(String symbol) throws Exception {
        log.error((Object)"TradeJPADirect:pingTwoPhase - is not implemented for this runtime mode");
        throw new UnsupportedOperationException("TradeJPADirect:pingTwoPhase - is not implemented for this runtime mode");
    }

    public String checkDBProductName() throws Exception {
        log.error((Object)"TradeJPADirect:checkDBProductName - is not implemented in JPA mode");
        new RuntimeException("TradeJPADirect:checkDBProductName - is not implemented in JPA mode");
        return null;
    }

    public boolean recreateDBTables(Object[] sqlBuffer, PrintWriter out) throws Exception {
        log.error((Object)"TradeJPADirect:recreateDBTables - is not implemented in JPA mode");
        new RuntimeException("TradeJPADirect:recreateDBTables - is not implemented in JPA mode");
        return false;
    }

    public int getMode() {
        return 4;
    }

    static {
        ZERO = new BigDecimal(0.0);
        initialized = false;
        log = null;
    }

    class quotePriceComparator
    implements Comparator {
        quotePriceComparator() {
        }

        public int compare(Object quote1, Object quote2) {
            double change1 = ((QuoteDataBean)quote1).getChange();
            double change2 = ((QuoteDataBean)quote2).getChange();
            return new Double(change2).compareTo(change1);
        }
    }
}

