/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.integration.daytrader;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.apache.openjpa.lib.log.Log;

public class TradeConfig {
    public static Log log = null;
    public static final int UNKNOWN = -1;
    public static String[] runTimeModeNames = new String[]{"Full EJB3", "Direct (JDBC)", "Session (EJB3) To Direct", "Web JDBC", "Web JPA"};
    public static final int EJB3 = 0;
    public static final int DIRECT = 1;
    public static final int SESSION3 = 2;
    public static final int JDBC = 3;
    public static final int JPA = 4;
    public static int runTimeMode = 4;
    public static String[] jpaLayerNames = new String[]{"OpenJPA", "Hibernate"};
    public static final int OPENJPA = 0;
    public static final int HIBERNATE = 1;
    public static int jpaLayer = 0;
    public static String[] orderProcessingModeNames = new String[]{"Synchronous", "Asynchronous_2-Phase"};
    public static final int SYNCH = 0;
    public static final int ASYNCH_2PHASE = 1;
    public static int orderProcessingMode = 0;
    public static String[] accessModeNames = new String[]{"Standard", "WebServices"};
    public static final int STANDARD = 0;
    public static final int WEBSERVICES = 1;
    private static int accessMode = 0;
    public static String[] workloadMixNames = new String[]{"Standard", "High-Volume"};
    public static final int SCENARIOMIX_STANDARD = 0;
    public static final int SCENARIOMIX_HIGHVOLUME = 1;
    public static int workloadMix = 0;
    public static String[] webInterfaceNames = new String[]{"JSP", "JSP-Images"};
    public static final int JSP = 0;
    public static final int JSP_Images = 1;
    public static int webInterface = 0;
    public static String[] cachingTypeNames = new String[]{"DistributedMap", "Command Caching", "No Caching"};
    public static final int DISTRIBUTEDMAP = 0;
    public static final int COMMAND_CACHING = 1;
    public static final int NO_CACHING = 2;
    public static int cachingType = 2;
    private static int MAX_USERS = 500;
    private static int MAX_QUOTES = 1000;
    public static String JDBC_UID = null;
    public static String JDBC_PWD = null;
    public static String DS_NAME = "java:comp/env/jdbc/TradeDataSource";
    private static String SoapURL = "http://localhost:8080/daytrader/services/TradeWSServices";
    public static boolean JDBCDriverNeedsGlobalTransaction = false;
    public static String DATASOURCE = "java:comp/env/jdbc/TradeDataSource";
    public static int KEYBLOCKSIZE = 1000;
    public static int QUOTES_PER_PAGE = 10;
    public static boolean RND_USER = true;
    private static int MAX_HOLDINGS = 10;
    private static int count = 0;
    private static Object userID_count_semaphore = new Object();
    private static int userID_count = 0;
    private static String hostName = null;
    private static Random r0;
    private static Random randomNumberGenerator;
    public static final String newUserPrefix = "ru:";
    public static final int verifyPercent = 5;
    private static boolean trace;
    private static boolean actionTrace;
    private static boolean updateQuotePrices;
    private static int primIterations;
    private static boolean longRun;
    private static boolean publishQuotePriceChange;
    private static int marketSummaryInterval;
    public static BigDecimal PENNY_STOCK_PRICE;
    public static BigDecimal PENNY_STOCK_RECOVERY_MIRACLE_MULTIPLIER;
    public static BigDecimal MAXIMUM_STOCK_PRICE;
    public static BigDecimal MAXIMUM_STOCK_SPLIT_MULTIPLIER;
    public static final int HOME_OP = 0;
    public static final int QUOTE_OP = 1;
    public static final int LOGIN_OP = 2;
    public static final int LOGOUT_OP = 3;
    public static final int REGISTER_OP = 4;
    public static final int ACCOUNT_OP = 5;
    public static final int PORTFOLIO_OP = 6;
    public static final int BUY_OP = 7;
    public static final int SELL_OP = 8;
    public static final int UPDATEACCOUNT_OP = 9;
    private static int[][] scenarioMixes;
    private static char[] actions;
    private static int sellDeficit;
    public static final int WELCOME_PAGE = 0;
    public static final int REGISTER_PAGE = 1;
    public static final int PORTFOLIO_PAGE = 2;
    public static final int QUOTE_PAGE = 3;
    public static final int HOME_PAGE = 4;
    public static final int ACCOUNT_PAGE = 5;
    public static final int ORDER_PAGE = 6;
    public static final int CONFIG_PAGE = 7;
    public static final int STATS_PAGE = 8;
    public static String[][] webUI;
    private static final String NAMESERVICE_TYPE_PROPERTY = "java.naming.factory.initial";
    private static final String NAMESERVICE_PROVIDER_URL_PROPERTY = "java.naming.provider.url";
    private static int scenarioCount;
    private static final BigDecimal orderFee;
    private static final BigDecimal cashFee;
    private static final BigDecimal ONE;
    private static ArrayList deck;
    private static int card;

    private static String getHostname() {
        try {
            if (hostName == null) {
                hostName = InetAddress.getLocalHost().getHostName();
                try {
                    hostName = hostName.substring(0, hostName.indexOf(46));
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception getting local host name using 'localhost' - ", (Throwable)e);
            hostName = "localhost";
        }
        return hostName;
    }

    public static String getPage(int pageNumber) {
        return webUI[webInterface][pageNumber];
    }

    public static String[] getRunTimeModeNames() {
        return runTimeModeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static char getScenarioAction(boolean newUser) {
        int r = TradeConfig.rndInt(100);
        int i = 0;
        for (int sum = scenarioMixes[workloadMix][i]; sum <= r; sum += scenarioMixes[workloadMix][++i]) {
        }
        TradeConfig.incrementScenarioCount();
        if (newUser || actions[i] != 'b') return actions[i];
        Class<TradeConfig> clazz = TradeConfig.class;
        synchronized (TradeConfig.class) {
            if (sellDeficit <= 0) return actions[i];
            --sellDeficit;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return 's';
        }
    }

    public static String getUserID() {
        String userID = RND_USER ? TradeConfig.rndUserID() : TradeConfig.nextUserID();
        return userID;
    }

    public static BigDecimal getOrderFee(String orderType) {
        if (orderType.compareToIgnoreCase("BUY") == 0 || orderType.compareToIgnoreCase("SELL") == 0) {
            return orderFee;
        }
        return cashFee;
    }

    public static synchronized void incrementSellDeficit() {
        ++sellDeficit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String nextUserID() {
        String userID;
        Object object = userID_count_semaphore;
        synchronized (object) {
            userID = "uid:" + userID_count;
            if (++userID_count % MAX_USERS == 0) {
                userID_count = 0;
            }
        }
        return userID;
    }

    public static double random() {
        return randomNumberGenerator.nextDouble();
    }

    public static String rndAddress() {
        return TradeConfig.rndInt(1000) + " Oak St.";
    }

    public static String rndBalance() {
        return "1000000";
    }

    public static String rndCreditCard() {
        return TradeConfig.rndInt(100) + "-" + TradeConfig.rndInt(1000) + "-" + TradeConfig.rndInt(1000) + "-" + TradeConfig.rndInt(1000);
    }

    public static String rndEmail(String userID) {
        return userID + "@" + TradeConfig.rndInt(100) + ".com";
    }

    public static String rndFullName() {
        return "first:" + TradeConfig.rndInt(1000) + " last:" + TradeConfig.rndInt(5000);
    }

    public static int rndInt(int i) {
        return new Float(TradeConfig.random() * (double)i).intValue();
    }

    public static float rndFloat(int i) {
        return new Float(TradeConfig.random() * (double)i).floatValue();
    }

    public static BigDecimal rndBigDecimal(float f) {
        return new BigDecimal(TradeConfig.random() * (double)f).setScale(2, 4);
    }

    public static boolean rndBoolean() {
        return randomNumberGenerator.nextBoolean();
    }

    public static synchronized String rndNewUserID() {
        return newUserPrefix + TradeConfig.getHostname() + System.currentTimeMillis() + count++;
    }

    public static float rndPrice() {
        return new Integer(TradeConfig.rndInt(200)).floatValue() + 1.0f;
    }

    public static BigDecimal getRandomPriceChangeFactor() {
        BigDecimal percentGainBD;
        double percentGain = (double)TradeConfig.rndFloat(1) * 0.2;
        if (TradeConfig.random() < 0.5) {
            percentGain *= -1.0;
        }
        if ((percentGainBD = new BigDecimal(percentGain += 1.0).setScale(2, 4)).doubleValue() <= 0.0) {
            percentGainBD = ONE;
        }
        return percentGainBD;
    }

    public static float rndQuantity() {
        return new Integer(TradeConfig.rndInt(200)).floatValue() + 1.0f;
    }

    public static String rndSymbol() {
        return "s:" + TradeConfig.rndInt(MAX_QUOTES - 1);
    }

    public static String rndSymbols() {
        String symbols = "";
        int num_symbols = TradeConfig.rndInt(QUOTES_PER_PAGE);
        for (int i = 0; i <= num_symbols; ++i) {
            symbols = symbols + "s:" + TradeConfig.rndInt(MAX_QUOTES - 1);
            if (i >= num_symbols) continue;
            symbols = symbols + ",";
        }
        return symbols;
    }

    public static String rndUserID() {
        String nextUser = TradeConfig.getNextUserIDFromDeck();
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeConfig:rndUserID -- new trader = " + nextUser));
        }
        return nextUser;
    }

    private static synchronized String getNextUserIDFromDeck() {
        int numUsers = TradeConfig.getMAX_USERS();
        if (deck == null) {
            deck = new ArrayList(numUsers);
            for (int i = 0; i < numUsers; ++i) {
                deck.add(i, new Integer(i));
            }
            Collections.shuffle(deck, r0);
        }
        if (card >= numUsers) {
            card = 0;
        }
        return "uid:" + deck.get(card++);
    }

    public static void setRunTimeModeNames(String[] newRunTimeModeNames) {
        runTimeModeNames = newRunTimeModeNames;
    }

    public static void setConfigParam(String parm, String value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("TradeConfig setting parameter: " + parm + "=" + value));
        }
        if (parm == null) {
            return;
        }
        if ((parm = parm.trim()).length() <= 0) {
            return;
        }
        if (value == null) {
            return;
        }
        value = value.trim();
        if (parm.equalsIgnoreCase("runTimeMode")) {
            try {
                for (int i = 0; i < runTimeModeNames.length; ++i) {
                    if (!value.equalsIgnoreCase(runTimeModeNames[i])) continue;
                    TradeConfig.setRunTimeMode(i);
                }
            }
            catch (Exception e) {
                log.error((Object)("TradeConfig.setConfigParm(..): minor exception caughttrying to set runtimemode to " + value + "reverting to current value: " + runTimeModeNames[TradeConfig.getRunTimeMode()]), (Throwable)e);
            }
        } else if (parm.equalsIgnoreCase("orderProcessingMode")) {
            try {
                for (int i = 0; i < orderProcessingModeNames.length; ++i) {
                    if (!value.equalsIgnoreCase(orderProcessingModeNames[i])) continue;
                    orderProcessingMode = i;
                }
            }
            catch (Exception e) {
                log.error((Object)("TradeConfig.setConfigParm(..): minor exception caughttrying to set orderProcessingMode to " + value + "reverting to current value: " + orderProcessingModeNames[orderProcessingMode]), (Throwable)e);
            }
        } else if (parm.equalsIgnoreCase("accessMode")) {
            try {
                for (int i = 0; i < accessModeNames.length; ++i) {
                    if (!value.equalsIgnoreCase(accessModeNames[i])) continue;
                    accessMode = i;
                }
            }
            catch (Exception e) {
                log.error((Object)("TradeConfig.setConfigParm(..): minor exception caughttrying to set accessMode to " + value + "reverting to current value: " + accessModeNames[accessMode]), (Throwable)e);
            }
        } else if (parm.equalsIgnoreCase("webServicesEndpoint")) {
            try {
                TradeConfig.setSoapURL(value);
            }
            catch (Exception e) {
                log.error((Object)"TradeConfig.setConfigParm(..): minor exception caughtSetting web services endpoint", (Throwable)e);
            }
        } else if (parm.equalsIgnoreCase("workloadMix")) {
            try {
                for (int i = 0; i < workloadMixNames.length; ++i) {
                    if (!value.equalsIgnoreCase(workloadMixNames[i])) continue;
                    workloadMix = i;
                }
            }
            catch (Exception e) {
                log.error((Object)("TradeConfig.setConfigParm(..): minor exception caughttrying to set workloadMix to " + value + "reverting to current value: " + workloadMixNames[workloadMix]), (Throwable)e);
            }
        } else if (parm.equalsIgnoreCase("WebInterface")) {
            try {
                for (int i = 0; i < webInterfaceNames.length; ++i) {
                    if (!value.equalsIgnoreCase(webInterfaceNames[i])) continue;
                    webInterface = i;
                }
            }
            catch (Exception e) {
                log.error((Object)("TradeConfig.setConfigParm(..): minor exception caughttrying to set WebInterface to " + value + "reverting to current value: " + webInterfaceNames[webInterface]), (Throwable)e);
            }
        } else if (parm.equalsIgnoreCase("CachingType")) {
            try {
                for (int i = 0; i < cachingTypeNames.length; ++i) {
                    if (!value.equalsIgnoreCase(cachingTypeNames[i])) continue;
                    cachingType = i;
                }
            }
            catch (Exception e) {
                log.error((Object)("TradeConfig.setConfigParm(..): minor exception caughttrying to set CachingType to " + value + "reverting to current value: " + cachingTypeNames[cachingType]), (Throwable)e);
            }
        } else if (parm.equalsIgnoreCase("maxUsers")) {
            try {
                MAX_USERS = Integer.parseInt(value);
            }
            catch (Exception e) {
                log.error((Object)("TradeConfig.setConfigParm(..): minor exception caughtSetting maxusers, error parsing string to int:" + value + "revering to current value: " + MAX_USERS), (Throwable)e);
            }
        } else if (parm.equalsIgnoreCase("maxQuotes")) {
            try {
                MAX_QUOTES = Integer.parseInt(value);
            }
            catch (Exception e) {
                log.error((Object)("TradeConfig.setConfigParm(...) minor exception caughtSetting max_quotes, error parsing string to int " + value + "reverting to current value: " + MAX_QUOTES), (Throwable)e);
            }
        } else if (parm.equalsIgnoreCase("primIterations")) {
            try {
                primIterations = Integer.parseInt(value);
            }
            catch (Exception e) {
                log.error((Object)("TradeConfig.setConfigParm(..): minor exception caughtSetting primIterations, error parsing string to int:" + value + "revering to current value: " + primIterations), (Throwable)e);
            }
        }
    }

    public static String[] getOrderProcessingModeNames() {
        return orderProcessingModeNames;
    }

    public static String[] getWorkloadMixNames() {
        return workloadMixNames;
    }

    public static String[] getWebInterfaceNames() {
        return webInterfaceNames;
    }

    public static String[] getCachingTypeNames() {
        return cachingTypeNames;
    }

    public static int[][] getScenarioMixes() {
        return scenarioMixes;
    }

    public static boolean getTrace() {
        return trace;
    }

    public static void setTrace(boolean traceValue) {
        trace = traceValue;
    }

    public static int getMAX_USERS() {
        return MAX_USERS;
    }

    public static void setMAX_USERS(int mAX_USERS) {
        MAX_USERS = mAX_USERS;
        deck = null;
    }

    public static int getMAX_QUOTES() {
        return MAX_QUOTES;
    }

    public static void setMAX_QUOTES(int mAX_QUOTES) {
        MAX_QUOTES = mAX_QUOTES;
    }

    public static int getMAX_HOLDINGS() {
        return MAX_HOLDINGS;
    }

    public static void setMAX_HOLDINGS(int mAX_HOLDINGS) {
        MAX_HOLDINGS = mAX_HOLDINGS;
    }

    public static boolean getActionTrace() {
        return actionTrace;
    }

    public static void setActionTrace(boolean actionTrace) {
        TradeConfig.actionTrace = actionTrace;
    }

    public static int getScenarioCount() {
        return scenarioCount;
    }

    public static void setScenarioCount(int scenarioCount) {
        TradeConfig.scenarioCount = scenarioCount;
    }

    public static synchronized void incrementScenarioCount() {
        ++scenarioCount;
    }

    public static boolean getJDBCDriverNeedsGlobalTransaction() {
        return JDBCDriverNeedsGlobalTransaction;
    }

    public static void setJDBCDriverNeedsGlobalTransaction(boolean JDBCDriverNeedsGlobalTransactionVal) {
        JDBCDriverNeedsGlobalTransaction = JDBCDriverNeedsGlobalTransactionVal;
    }

    public static boolean getUpdateQuotePrices() {
        return updateQuotePrices;
    }

    public static void setUpdateQuotePrices(boolean updateQuotePrices) {
        TradeConfig.updateQuotePrices = updateQuotePrices;
    }

    public static String getSoapURL() {
        return SoapURL;
    }

    public static void setSoapURL(String value) {
        SoapURL = value;
    }

    public static int getAccessMode() {
        return accessMode;
    }

    public static void setAccessMode(int value) {
        accessMode = value;
    }

    public static int getRunTimeMode() {
        return runTimeMode;
    }

    public static void setRunTimeMode(int value) {
        runTimeMode = value;
    }

    public static int getPrimIterations() {
        return primIterations;
    }

    public static void setPrimIterations(int iter) {
        primIterations = iter;
    }

    public static boolean getLongRun() {
        return longRun;
    }

    public static void setLongRun(boolean longRun) {
        TradeConfig.longRun = longRun;
    }

    public static void setPublishQuotePriceChange(boolean publishQuotePriceChange) {
        TradeConfig.publishQuotePriceChange = publishQuotePriceChange;
    }

    public static boolean getPublishQuotePriceChange() {
        return publishQuotePriceChange;
    }

    public static void setMarketSummaryInterval(int seconds) {
        marketSummaryInterval = seconds;
    }

    public static int getMarketSummaryInterval() {
        return marketSummaryInterval;
    }

    public static String[] getJPALayerNames() {
        return jpaLayerNames;
    }

    public static void setLog(Log log) {
        TradeConfig.log = log;
    }

    static {
        randomNumberGenerator = r0 = new Random(System.currentTimeMillis());
        trace = false;
        actionTrace = false;
        updateQuotePrices = true;
        primIterations = 1;
        longRun = true;
        publishQuotePriceChange = false;
        marketSummaryInterval = 20;
        PENNY_STOCK_PRICE = new BigDecimal(0.01);
        PENNY_STOCK_PRICE = PENNY_STOCK_PRICE.setScale(2, 4);
        PENNY_STOCK_RECOVERY_MIRACLE_MULTIPLIER = new BigDecimal(600.0);
        PENNY_STOCK_RECOVERY_MIRACLE_MULTIPLIER.setScale(2, 4);
        MAXIMUM_STOCK_PRICE = new BigDecimal(400);
        MAXIMUM_STOCK_PRICE.setScale(2, 4);
        MAXIMUM_STOCK_SPLIT_MULTIPLIER = new BigDecimal(0.5);
        MAXIMUM_STOCK_SPLIT_MULTIPLIER.setScale(2, 4);
        scenarioMixes = new int[][]{{20, 40, 0, 4, 2, 10, 12, 4, 4, 4}, {20, 40, 0, 4, 2, 7, 7, 7, 7, 6}};
        actions = new char[]{'h', 'q', 'l', 'o', 'r', 'a', 'p', 'b', 's', 'u'};
        sellDeficit = 0;
        webUI = new String[][]{{"/welcome.jsp", "/register.jsp", "/portfolio.jsp", "/quote.jsp", "/tradehome.jsp", "/account.jsp", "/order.jsp", "/config.jsp", "/runStats.jsp"}, {"/welcomeImg.jsp", "/registerImg.jsp", "/portfolioImg.jsp", "/quoteImg.jsp", "/tradehomeImg.jsp", "/accountImg.jsp", "/orderImg.jsp", "/config.jsp", "/runStats.jsp"}};
        scenarioCount = 0;
        orderFee = new BigDecimal("24.95");
        cashFee = new BigDecimal("0.0");
        ONE = new BigDecimal(1.0);
        deck = null;
        card = 0;
    }
}

