/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.integration.daytrader;

import java.math.BigDecimal;
import org.apache.openjpa.integration.daytrader.AccountDataBean;
import org.apache.openjpa.integration.daytrader.OrderDataBean;
import org.apache.openjpa.integration.daytrader.QuoteDataBean;
import org.apache.openjpa.integration.daytrader.TradeAction;
import org.apache.openjpa.integration.daytrader.TradeConfig;
import org.apache.openjpa.lib.log.Log;

public class TradeBuildDB {
    private TradeAction trade = null;

    public TradeBuildDB(Log log, TradeAction trade) throws Exception {
        this.trade = trade;
    }

    public void setup(int quotes, int users) {
        this.createQuotes(quotes);
        this.createAccounts(users);
    }

    private void createQuotes(int quotes) {
        int errorCount = 0;
        TradeConfig.log.info((Object)("TradeBuildDB.createQuotes(" + quotes + ")"));
        for (int i = 0; i < quotes; ++i) {
            String symbol = "s:" + i;
            String companyName = "S" + i + " Incorporated";
            try {
                QuoteDataBean quoteData = this.trade.createQuote(symbol, companyName, new BigDecimal(TradeConfig.rndPrice()));
                continue;
            }
            catch (Exception e) {
                if (errorCount++ < 10) continue;
                TradeConfig.log.error((Object)"createQuotes - aborting after 10 create quote errors", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void createAccounts(int users) {
        TradeConfig.log.info((Object)("TradeBuildDB.createAccounts(" + users + ")"));
        for (int i = 0; i < users; ++i) {
            AccountDataBean accountData;
            String userID = "uid:" + i;
            String fullname = TradeConfig.rndFullName();
            String email = TradeConfig.rndEmail(userID);
            String address = TradeConfig.rndAddress();
            String creditcard = TradeConfig.rndCreditCard();
            double initialBalance = (double)TradeConfig.rndInt(100000) + 200000.0;
            if (i == 0) {
                initialBalance = 1000000.0;
            }
            if ((accountData = this.trade.register(userID, "xxx", fullname, address, email, creditcard, new BigDecimal(initialBalance))) != null) {
                int holdings = TradeConfig.getMAX_HOLDINGS();
                double quantity = 0.0;
                OrderDataBean orderData = null;
                for (int j = 0; j < holdings; ++j) {
                    String symbol = TradeConfig.rndSymbol();
                    quantity = TradeConfig.rndQuantity();
                    orderData = this.trade.buy(userID, symbol, quantity, TradeConfig.orderProcessingMode);
                }
                if (!TradeConfig.log.isTraceEnabled()) continue;
                TradeConfig.log.trace((Object)("createAccounts - created " + holdings + " for userID=" + userID + " order=" + orderData));
                continue;
            }
            TradeConfig.log.error((Object)("createAccounts - userID=" + userID + " already registered."));
            throw new RuntimeException("createAccounts - userID=" + userID + " already registered.");
        }
    }
}

