/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.integration.daytrader;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.integration.daytrader.AccountDataBean;
import org.apache.openjpa.integration.daytrader.AccountProfileDataBean;
import org.apache.openjpa.integration.daytrader.HoldingDataBean;
import org.apache.openjpa.integration.daytrader.MarketSummaryDataBean;
import org.apache.openjpa.integration.daytrader.OrderDataBean;
import org.apache.openjpa.integration.daytrader.QuoteDataBean;
import org.apache.openjpa.integration.daytrader.TradeConfig;
import org.apache.openjpa.integration.daytrader.TradeJPADirect;
import org.apache.openjpa.lib.log.Log;

public class TradeAction
extends TradeJPADirect {
    public TradeAction(Log log, EntityManagerFactory emf) {
        super(log, emf);
    }

    void doAccount(StringBuilder sb, String userID, String results) throws RuntimeException, IOException {
        this.setAttribute(sb, "Page", "Account");
        try {
            AccountDataBean accountData = this.getAccountData(userID);
            AccountProfileDataBean accountProfileData = this.getAccountProfileData(userID);
            ArrayList orderDataBeans = TradeConfig.getLongRun() ? new ArrayList() : (ArrayList)this.getOrders(userID);
            this.setAttribute(sb, "accountData", accountData);
            this.setAttribute(sb, "accountProfileData", accountProfileData);
            this.setAttribute(sb, "orderDataBeans", orderDataBeans);
            this.setAttribute(sb, "results", results);
        }
        catch (IllegalArgumentException e) {
            this.setAttribute(sb, "results", results + "could not find account for userID = " + userID);
            this.setAttribute(sb, "Exception", e);
        }
        catch (Exception e) {
            sb.append("TradeServletAction.doAccount(...) exception user =" + userID);
            this.setAttribute(sb, "Exception", e);
            throw new RuntimeException("TradeServletAction.doAccount(...) exception user =" + userID, e);
        }
    }

    void doAccountUpdate(StringBuilder sb, String userID, String password, String cpassword, String fullName, String address, String creditcard, String email) throws RuntimeException, IOException {
        String results = "";
        this.setAttribute(sb, "Page", "Account Update");
        boolean doUpdate = true;
        if (!password.equals(cpassword)) {
            results = "Update profile error: passwords do not match";
            doUpdate = false;
        } else if (password.length() <= 0 || fullName.length() <= 0 || address.length() <= 0 || creditcard.length() <= 0 || email.length() <= 0) {
            results = "Update profile error: please fill in all profile information fields";
            doUpdate = false;
        }
        AccountProfileDataBean accountProfileData = new AccountProfileDataBean(userID, password, fullName, address, email, creditcard);
        try {
            if (doUpdate) {
                accountProfileData = this.updateAccountProfile(accountProfileData);
                results = "Account profile update successful";
            }
        }
        catch (IllegalArgumentException e) {
            this.setAttribute(sb, "results", results + "invalid argument, check userID is correct, and the database is populated" + userID);
            this.setAttribute(sb, "Exception", e);
        }
        catch (Exception e) {
            this.setAttribute(sb, "results", "TradeServletAction.doAccountUpdate(...) exception user =" + userID);
            this.setAttribute(sb, "Exception", e);
            throw new RuntimeException("TradeServletAction.doAccountUpdate(...) exception user =" + userID, e);
        }
        finally {
            sb.append(results);
        }
        this.doAccount(sb, userID, results);
    }

    void doBuy(StringBuilder sb, String userID, String symbol, String quantity) throws RuntimeException, IOException {
        String results = "";
        this.setAttribute(sb, "Page", "Buy");
        try {
            OrderDataBean orderData = this.buy(userID, symbol, new Double(quantity), TradeConfig.orderProcessingMode);
            this.setAttribute(sb, "orderData", orderData);
            this.setAttribute(sb, "results", results);
        }
        catch (IllegalArgumentException e) {
            this.setAttribute(sb, "results", results + "illegal argument. userID=" + userID + ", symbol=" + symbol);
            this.setAttribute(sb, "Exception", e);
        }
        catch (Exception e) {
            this.setAttribute(sb, "Exception", e);
            throw new RuntimeException("TradeServletAction.buy(...) exception buying stock " + symbol + " for user " + userID, e);
        }
    }

    void doHome(StringBuilder sb, String userID, String results) throws RuntimeException, IOException {
        String result = "";
        this.setAttribute(sb, "Page", "Home");
        try {
            AccountDataBean accountData = this.getAccountData(userID);
            Collection<HoldingDataBean> holdingDataBeans = this.getHoldings(userID);
            MarketSummaryDataBean marketSummaryData = this.getMarketSummary();
            this.setAttribute(sb, "accountData", accountData);
            this.setAttribute(sb, "holdingDataBeans", holdingDataBeans);
            this.setAttribute(sb, "marketSummaryData", marketSummaryData);
            this.setAttribute(sb, "results", results);
        }
        catch (IllegalArgumentException e) {
            this.setAttribute(sb, "results", results + "check userID = " + userID + " and that the database is populated");
            this.setAttribute(sb, "Exception", e);
        }
        catch (RuntimeException e) {
            this.setAttribute(sb, "results", results + " Could not find account for + " + userID);
            this.setAttribute(sb, "Exception", e);
        }
        catch (Exception e) {
            this.setAttribute(sb, "Exception", e);
            throw new RuntimeException("TradeServletAction.doHome(...) exception user =" + userID, e);
        }
    }

    boolean doLogin(StringBuilder sb, String userID, String passwd) throws RuntimeException, IOException {
        String results = "";
        this.setAttribute(sb, "Page", "Login");
        try {
            AccountDataBean accountData = this.login(userID, passwd);
            if (accountData != null) {
                this.setAttribute(sb, "uidBean", userID);
                this.setAttribute(sb, "sessionCreationDate", new Date());
                results = "Ready to Trade";
                this.doHome(sb, userID, results);
                return true;
            }
            this.setAttribute(sb, "results", results + " Could not find account for + " + userID);
        }
        catch (IllegalArgumentException e) {
            this.setAttribute(sb, "results", results + "illegal argument.  userID=" + userID + ", passwd=" + passwd);
            this.setAttribute(sb, "Exception", e);
        }
        catch (Exception e) {
            this.setAttribute(sb, "Exception", e);
            throw new RuntimeException("TradeServletAction.doLogin(...)Exception logging in user " + userID + "with password" + passwd, e);
        }
        return false;
    }

    void doLogout(StringBuilder sb, String userID) throws RuntimeException, IOException {
        String results = "";
        this.setAttribute(sb, "Page", "Logout");
        try {
            this.logout(userID);
        }
        catch (IllegalArgumentException e) {
            this.setAttribute(sb, "results", results + "illegal argument:" + e.getMessage());
            this.setAttribute(sb, "Exception", e);
        }
        catch (Exception e) {
            this.setAttribute(sb, "Exception", e);
            throw new RuntimeException("TradeServletAction.doLogout(...)exception logging out user " + userID, e);
        }
    }

    void doPortfolio(StringBuilder sb, String userID, String results) throws RuntimeException, IOException {
        this.setAttribute(sb, "Page", "Portfolio");
        try {
            ArrayList<QuoteDataBean> quoteDataBeans = new ArrayList<QuoteDataBean>();
            Collection<HoldingDataBean> holdingDataBeans = this.getHoldings(userID);
            if (holdingDataBeans.size() > 0) {
                for (HoldingDataBean holdingData : holdingDataBeans) {
                    QuoteDataBean quoteData = this.getQuote(holdingData.getQuoteID());
                    quoteDataBeans.add(quoteData);
                }
            } else {
                results = results + ".  Your portfolio is empty.";
            }
            this.setAttribute(sb, "results", results);
            this.setAttribute(sb, "holdingDataBeans", holdingDataBeans);
            this.setAttribute(sb, "quoteDataBeans", quoteDataBeans);
        }
        catch (IllegalArgumentException e) {
            this.setAttribute(sb, "results", results + "illegal argument for userID=" + userID);
            this.setAttribute(sb, "Exception", e);
        }
        catch (Exception e) {
            this.setAttribute(sb, "Exception", e);
            throw new RuntimeException("TradeServletAction.doPortfolio(...) exception user =" + userID, e);
        }
    }

    void doQuotes(StringBuilder sb, String userID, String symbols) throws RuntimeException, IOException {
        String results = "";
        this.setAttribute(sb, "Page", "Quotes");
        try {
            Collection<OrderDataBean> closedOrders = this.getClosedOrders(userID);
            if (closedOrders.size() > 0) {
                this.setAttribute(sb, "closedOrders", closedOrders);
            } else {
                results = results + ".  You have no closed orders.";
            }
            this.setAttribute(sb, "symbols", symbols);
            QuoteDataBean quote = this.getQuote(symbols);
            this.setAttribute(sb, "quote", quote);
        }
        catch (Exception e) {
            this.setAttribute(sb, "Exception", e);
            throw new RuntimeException("TradeServletAction.doQuotes(...) exception user =" + userID + ", symbols=" + symbols, e);
        }
    }

    void doRegister(StringBuilder sb, String userID, String passwd, String cpasswd, String fullname, String ccn, String openBalanceString, String email, String address) throws RuntimeException, IOException {
        String results = "";
        this.setAttribute(sb, "Page", "Register");
        try {
            if (passwd.equals(cpasswd) && passwd.length() >= 1) {
                AccountDataBean accountData = this.register(userID, passwd, fullname, address, email, ccn, new BigDecimal(openBalanceString));
                if (accountData == null) {
                    results = "Registration operation failed;";
                    this.setAttribute(sb, "results", results);
                } else {
                    this.doLogin(sb, userID, passwd);
                    results = "Registration operation succeeded;  Account " + accountData.getAccountID() + " has been created.";
                    this.setAttribute(sb, "results", results);
                }
            } else {
                results = "Registration operation failed, your passwords did not match";
                System.out.println(results);
                this.setAttribute(sb, "results", results);
            }
        }
        catch (Exception e) {
            this.setAttribute(sb, "Exception", e);
            throw new RuntimeException("TradeServletAction.doRegister(...) exception user =" + userID, e);
        }
    }

    void doSell(StringBuilder sb, String userID, Integer holdingID) throws RuntimeException, IOException {
        String results = "";
        this.setAttribute(sb, "Page", "Sell");
        try {
            OrderDataBean orderData = this.sell(userID, holdingID, TradeConfig.orderProcessingMode);
            this.setAttribute(sb, "orderData", orderData);
            this.setAttribute(sb, "results", results);
        }
        catch (IllegalArgumentException e) {
            this.setAttribute(sb, "Exception", e);
        }
        catch (Exception e) {
            this.setAttribute(sb, "Exception", e);
            throw new RuntimeException("TradeServletAction.doSell(...) exception selling holding " + holdingID + " for user =" + userID, e);
        }
    }

    void doWelcome(StringBuilder sb, String status) throws RuntimeException, IOException {
        this.setAttribute(sb, "Page", "Welcome");
        this.setAttribute(sb, "results", status);
    }

    private void setAttribute(StringBuilder sb, String attribute, Object value) {
        if (log != null && log.isTraceEnabled()) {
            sb.append(attribute);
            sb.append(" = ");
            sb.append(value);
            sb.append(System.getProperty("line.separator"));
        }
    }
}

