/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.integration.daytrader;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.integration.daytrader.TradeAction;
import org.apache.openjpa.integration.daytrader.TradeBuildDB;
import org.apache.openjpa.integration.daytrader.TradeConfig;
import org.apache.openjpa.integration.daytrader.TradeScenario;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.test.AbstractPersistenceTestCase;

public class TestDaytrader
extends AbstractPersistenceTestCase {
    private static final int TEST_USERS = 50;
    OpenJPAEntityManagerFactorySPI emf = null;
    Log log = null;
    private TradeAction trade = null;

    public void setUp() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("openjpa.DynamicEnhancementAgent", "false");
        map.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true,SchemaAction='add,deleteTableContents')");
        this.emf = this.createNamedEMF("daytrader", map);
        TestDaytrader.assertNotNull((Object)this.emf);
        this.log = this.emf.getConfiguration().getLog("test");
        TradeConfig.setRunTimeMode(4);
        TradeConfig.setLog(this.log);
        this.trade = new TradeAction(this.emf.getConfiguration().getLog("test"), (EntityManagerFactory)this.emf);
    }

    @Override
    public void tearDown() throws Exception {
        this.trade = null;
        this.log = null;
        this.closeEMF((EntityManagerFactory)this.emf);
        this.emf = null;
        super.tearDown();
    }

    public void testTrade() throws Exception {
        this.log.info((Object)"TestDaytrader.testTrade() started");
        TradeBuildDB tradeDB = new TradeBuildDB(this.log, this.trade);
        tradeDB.setup(TradeConfig.getMAX_QUOTES(), TradeConfig.getMAX_USERS());
        TradeScenario scenario = new TradeScenario(this.trade);
        this.log.info((Object)"TestDaytrader.testTrade() calling TradeScenario.performUserTasks(50)");
        for (int i = 0; i < 50; ++i) {
            String userID = "uid:" + i;
            if (scenario.performUserTasks(userID)) continue;
            TestDaytrader.fail((String)("TestDaytrader.testTrade() call to TradeScenario.performUserTask(" + userID + ") failed"));
        }
        this.log.info((Object)"TestDaytrader.testTrade() completed");
    }
}

