/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.integration.daytrader;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.integration.daytrader.AccountDataBean;
import org.apache.openjpa.integration.daytrader.HoldingDataBean;
import org.apache.openjpa.integration.daytrader.QuoteDataBean;
import org.apache.openjpa.integration.daytrader.TradeConfig;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;

@Entity(name="orderejb")
@Table(name="orderejb")
@NamedQueries(value={@NamedQuery(name="orderejb.findByOrderfee", query="SELECT o FROM orderejb o WHERE o.orderFee = :orderfee"), @NamedQuery(name="orderejb.findByCompletiondate", query="SELECT o FROM orderejb o WHERE o.completionDate = :completiondate"), @NamedQuery(name="orderejb.findByOrdertype", query="SELECT o FROM orderejb o WHERE o.orderType = :ordertype"), @NamedQuery(name="orderejb.findByOrderstatus", query="SELECT o FROM orderejb o WHERE o.orderStatus = :orderstatus"), @NamedQuery(name="orderejb.findByPrice", query="SELECT o FROM orderejb o WHERE o.price = :price"), @NamedQuery(name="orderejb.findByQuantity", query="SELECT o FROM orderejb o WHERE o.quantity = :quantity"), @NamedQuery(name="orderejb.findByOpendate", query="SELECT o FROM orderejb o WHERE o.openDate = :opendate"), @NamedQuery(name="orderejb.findByOrderid", query="SELECT o FROM orderejb o WHERE o.orderID = :orderid"), @NamedQuery(name="orderejb.findByAccountAccountid", query="SELECT o FROM orderejb o WHERE o.account.accountID = :accountAccountid"), @NamedQuery(name="orderejb.findByQuoteSymbol", query="SELECT o FROM orderejb o WHERE o.quote.symbol = :quoteSymbol"), @NamedQuery(name="orderejb.closedOrders", query="SELECT o FROM orderejb o WHERE o.orderStatus = 'closed' AND o.account.profile.userID  = :userID"), @NamedQuery(name="orderejb.completeClosedOrders", query="UPDATE orderejb o SET o.orderStatus = 'completed' WHERE o.orderStatus = 'closed' AND o.account.profile.userID  = :userID")})
public class OrderDataBean
implements Serializable,
PersistenceCapable {
    private static final long serialVersionUID = 7374883697399608766L;
    @TableGenerator(name="orderIdGen", table="KEYGENEJB", pkColumnName="KEYNAME", valueColumnName="KEYVAL", pkColumnValue="order", allocationSize=1000)
    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="orderIdGen")
    @Column(name="ORDERID", nullable=false)
    private Integer orderID;
    @Column(name="ORDERTYPE")
    private String orderType;
    @Column(name="ORDERSTATUS")
    private String orderStatus;
    @Column(name="OPENDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date openDate;
    @Column(name="COMPLETIONDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date completionDate;
    @Column(name="QUANTITY", nullable=false)
    private double quantity;
    @Column(name="PRICE")
    private BigDecimal price;
    @Column(name="ORDERFEE")
    private BigDecimal orderFee;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ACCOUNT_ACCOUNTID")
    private AccountDataBean account;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="QUOTE_SYMBOL")
    private QuoteDataBean quote;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="HOLDING_HOLDINGID")
    private HoldingDataBean holding;
    @Transient
    private String symbol;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean;
    static /* synthetic */ Class class$Ljava$math$BigDecimal;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$openjpa$integration$daytrader$QuoteDataBean;
    static /* synthetic */ Class class$Lorg$apache$openjpa$integration$daytrader$OrderDataBean;
    private transient Object pcDetachedState;

    public OrderDataBean() {
    }

    public OrderDataBean(Integer orderID, String orderType, String orderStatus, Date openDate, Date completionDate, double quantity, BigDecimal price, BigDecimal orderFee, String symbol) {
        this.setOrderID(orderID);
        this.setOrderType(orderType);
        this.setOrderStatus(orderStatus);
        this.setOpenDate(openDate);
        this.setCompletionDate(completionDate);
        this.setQuantity(quantity);
        this.setPrice(price);
        this.setOrderFee(orderFee);
        this.setSymbol(symbol);
    }

    public OrderDataBean(String orderType, String orderStatus, Date openDate, Date completionDate, double quantity, BigDecimal price, BigDecimal orderFee, AccountDataBean account, QuoteDataBean quote, HoldingDataBean holding) {
        this.setOrderType(orderType);
        this.setOrderStatus(orderStatus);
        this.setOpenDate(openDate);
        this.setCompletionDate(completionDate);
        this.setQuantity(quantity);
        this.setPrice(price);
        this.setOrderFee(orderFee);
        this.setAccount(account);
        this.setQuote(quote);
        this.setHolding(holding);
    }

    public static OrderDataBean getRandomInstance() {
        return new OrderDataBean(new Integer(TradeConfig.rndInt(100000)), TradeConfig.rndBoolean() ? "buy" : "sell", "open", new Date(TradeConfig.rndInt(Integer.MAX_VALUE)), new Date(TradeConfig.rndInt(Integer.MAX_VALUE)), TradeConfig.rndQuantity(), TradeConfig.rndBigDecimal(1000.0f), TradeConfig.rndBigDecimal(1000.0f), TradeConfig.rndSymbol());
    }

    public String toString() {
        return "Order " + this.getOrderID() + "\n\t      orderType: " + this.getOrderType() + "\n\t    orderStatus: " + this.getOrderStatus() + "\n\t       openDate: " + this.getOpenDate() + "\n\t completionDate: " + this.getCompletionDate() + "\n\t       quantity: " + this.getQuantity() + "\n\t          price: " + this.getPrice() + "\n\t       orderFee: " + this.getOrderFee() + "\n\t         symbol: " + this.getSymbol();
    }

    public String toHTML() {
        return "<BR>Order <B>" + this.getOrderID() + "</B>" + "<LI>      orderType: " + this.getOrderType() + "</LI>" + "<LI>    orderStatus: " + this.getOrderStatus() + "</LI>" + "<LI>       openDate: " + this.getOpenDate() + "</LI>" + "<LI> completionDate: " + this.getCompletionDate() + "</LI>" + "<LI>       quantity: " + this.getQuantity() + "</LI>" + "<LI>          price: " + this.getPrice() + "</LI>" + "<LI>       orderFee: " + this.getOrderFee() + "</LI>" + "<LI>         symbol: " + this.getSymbol() + "</LI>";
    }

    public void print() {
    }

    public Integer getOrderID() {
        return OrderDataBean.pcGetorderID(this);
    }

    public void setOrderID(Integer orderID) {
        OrderDataBean.pcSetorderID(this, orderID);
    }

    public String getOrderType() {
        return OrderDataBean.pcGetorderType(this);
    }

    public void setOrderType(String orderType) {
        OrderDataBean.pcSetorderType(this, orderType);
    }

    public String getOrderStatus() {
        return OrderDataBean.pcGetorderStatus(this);
    }

    public void setOrderStatus(String orderStatus) {
        OrderDataBean.pcSetorderStatus(this, orderStatus);
    }

    public Date getOpenDate() {
        return OrderDataBean.pcGetopenDate(this);
    }

    public void setOpenDate(Date openDate) {
        OrderDataBean.pcSetopenDate(this, openDate);
    }

    public Date getCompletionDate() {
        return OrderDataBean.pcGetcompletionDate(this);
    }

    public void setCompletionDate(Date completionDate) {
        OrderDataBean.pcSetcompletionDate(this, completionDate);
    }

    public double getQuantity() {
        return OrderDataBean.pcGetquantity(this);
    }

    public void setQuantity(double quantity) {
        OrderDataBean.pcSetquantity(this, quantity);
    }

    public BigDecimal getPrice() {
        return OrderDataBean.pcGetprice(this);
    }

    public void setPrice(BigDecimal price) {
        OrderDataBean.pcSetprice(this, price);
    }

    public BigDecimal getOrderFee() {
        return OrderDataBean.pcGetorderFee(this);
    }

    public void setOrderFee(BigDecimal orderFee) {
        OrderDataBean.pcSetorderFee(this, orderFee);
    }

    public String getSymbol() {
        if (OrderDataBean.pcGetquote(this) != null) {
            return OrderDataBean.pcGetquote(this).getSymbol();
        }
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public AccountDataBean getAccount() {
        return OrderDataBean.pcGetaccount(this);
    }

    public void setAccount(AccountDataBean account) {
        OrderDataBean.pcSetaccount(this, account);
    }

    public QuoteDataBean getQuote() {
        return OrderDataBean.pcGetquote(this);
    }

    public void setQuote(QuoteDataBean quote) {
        OrderDataBean.pcSetquote(this, quote);
    }

    public HoldingDataBean getHolding() {
        return OrderDataBean.pcGetholding(this);
    }

    public void setHolding(HoldingDataBean holding) {
        OrderDataBean.pcSetholding(this, holding);
    }

    public boolean isBuy() {
        String orderType = this.getOrderType();
        return orderType.compareToIgnoreCase("buy") == 0;
    }

    public boolean isSell() {
        String orderType = this.getOrderType();
        return orderType.compareToIgnoreCase("sell") == 0;
    }

    public boolean isOpen() {
        String orderStatus = this.getOrderStatus();
        return orderStatus.compareToIgnoreCase("open") == 0 || orderStatus.compareToIgnoreCase("processing") == 0;
    }

    public boolean isCompleted() {
        String orderStatus = this.getOrderStatus();
        return orderStatus.compareToIgnoreCase("completed") == 0 || orderStatus.compareToIgnoreCase("alertcompleted") == 0 || orderStatus.compareToIgnoreCase("cancelled") == 0;
    }

    public boolean isCancelled() {
        String orderStatus = this.getOrderStatus();
        return orderStatus.compareToIgnoreCase("cancelled") == 0;
    }

    public void cancel() {
        this.setOrderStatus("cancelled");
    }

    public int hashCode() {
        int hash = 0;
        return hash += OrderDataBean.pcGetorderID(this) != null ? OrderDataBean.pcGetorderID(this).hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof OrderDataBean)) {
            return false;
        }
        OrderDataBean other = (OrderDataBean)object;
        return OrderDataBean.pcGetorderID(this) == OrderDataBean.pcGetorderID(other) || OrderDataBean.pcGetorderID(this) != null && OrderDataBean.pcGetorderID(this).equals(OrderDataBean.pcGetorderID(other));
    }

    public int pcGetEnhancementContractVersion() {
        return 1300381;
    }

    static {
        pcFieldNames = new String[]{"account", "completionDate", "holding", "openDate", "orderFee", "orderID", "orderStatus", "orderType", "price", "quantity", "quote"};
        Class[] classArray = new Class[11];
        Class clazz = class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean : (class$Lorg$apache$openjpa$integration$daytrader$AccountDataBean = OrderDataBean.class$("org.apache.openjpa.integration.daytrader.AccountDataBean"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = OrderDataBean.class$("java.util.Date"));
        classArray[1] = clazz2;
        Class clazz3 = class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean : (class$Lorg$apache$openjpa$integration$daytrader$HoldingDataBean = OrderDataBean.class$("org.apache.openjpa.integration.daytrader.HoldingDataBean"));
        classArray[2] = clazz3;
        classArray[3] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = OrderDataBean.class$("java.util.Date"));
        Class clazz4 = class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = OrderDataBean.class$("java.math.BigDecimal"));
        classArray[4] = clazz4;
        Class clazz5 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = OrderDataBean.class$("java.lang.Integer"));
        classArray[5] = clazz5;
        Class clazz6 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = OrderDataBean.class$("java.lang.String"));
        classArray[6] = clazz6;
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = OrderDataBean.class$("java.lang.String"));
        classArray[8] = class$Ljava$math$BigDecimal != null ? class$Ljava$math$BigDecimal : (class$Ljava$math$BigDecimal = OrderDataBean.class$("java.math.BigDecimal"));
        classArray[9] = Double.TYPE;
        Class clazz7 = class$Lorg$apache$openjpa$integration$daytrader$QuoteDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$QuoteDataBean : (class$Lorg$apache$openjpa$integration$daytrader$QuoteDataBean = OrderDataBean.class$("org.apache.openjpa.integration.daytrader.QuoteDataBean"));
        classArray[10] = clazz7;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{21, 26, 21, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz8 = class$Lorg$apache$openjpa$integration$daytrader$OrderDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$OrderDataBean : (class$Lorg$apache$openjpa$integration$daytrader$OrderDataBean = OrderDataBean.class$("org.apache.openjpa.integration.daytrader.OrderDataBean"));
        PCRegistry.register((Class)clazz8, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"orderejb", (PersistenceCapable)new OrderDataBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.account = null;
        this.completionDate = null;
        this.holding = null;
        this.openDate = null;
        this.orderFee = null;
        this.orderID = null;
        this.orderStatus = null;
        this.orderType = null;
        this.price = null;
        this.quantity = 0.0;
        this.quote = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        OrderDataBean orderDataBean = new OrderDataBean();
        if (bl) {
            orderDataBean.pcClearFields();
        }
        orderDataBean.pcStateManager = stateManager;
        orderDataBean.pcCopyKeyFieldsFromObjectId(object);
        return orderDataBean;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        OrderDataBean orderDataBean = new OrderDataBean();
        if (bl) {
            orderDataBean.pcClearFields();
        }
        orderDataBean.pcStateManager = stateManager;
        return orderDataBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 11;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.account = (AccountDataBean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.completionDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.holding = (HoldingDataBean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.openDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.orderFee = (BigDecimal)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.orderID = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.orderStatus = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.orderType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.price = (BigDecimal)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.quantity = this.pcStateManager.replaceDoubleField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.quote = (QuoteDataBean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.account);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.completionDate);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.holding);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.openDate);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.orderFee);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.orderID);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.orderStatus);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.orderType);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.price);
                return;
            }
            case 9: {
                this.pcStateManager.providedDoubleField((PersistenceCapable)this, n, this.quantity);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.quote);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(OrderDataBean orderDataBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.account = orderDataBean.account;
                return;
            }
            case 1: {
                this.completionDate = orderDataBean.completionDate;
                return;
            }
            case 2: {
                this.holding = orderDataBean.holding;
                return;
            }
            case 3: {
                this.openDate = orderDataBean.openDate;
                return;
            }
            case 4: {
                this.orderFee = orderDataBean.orderFee;
                return;
            }
            case 5: {
                this.orderID = orderDataBean.orderID;
                return;
            }
            case 6: {
                this.orderStatus = orderDataBean.orderStatus;
                return;
            }
            case 7: {
                this.orderType = orderDataBean.orderType;
                return;
            }
            case 8: {
                this.price = orderDataBean.price;
                return;
            }
            case 9: {
                this.quantity = orderDataBean.quantity;
                return;
            }
            case 10: {
                this.quote = orderDataBean.quote;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        OrderDataBean orderDataBean = (OrderDataBean)object;
        if (orderDataBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(orderDataBean, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public synchronized void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        IntId intId = (IntId)object;
        fieldConsumer.storeObjectField(5 + pcInheritedFieldCount, (Object)new Integer(intId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        IntId intId = (IntId)object;
        this.orderID = new Integer(intId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openjpa$integration$daytrader$OrderDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$OrderDataBean : (class$Lorg$apache$openjpa$integration$daytrader$OrderDataBean = OrderDataBean.class$("org.apache.openjpa.integration.daytrader.OrderDataBean"));
        return new IntId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openjpa$integration$daytrader$OrderDataBean != null ? class$Lorg$apache$openjpa$integration$daytrader$OrderDataBean : (class$Lorg$apache$openjpa$integration$daytrader$OrderDataBean = OrderDataBean.class$("org.apache.openjpa.integration.daytrader.OrderDataBean"));
        return new IntId(clazz, this.orderID);
    }

    private static final AccountDataBean pcGetaccount(OrderDataBean orderDataBean) {
        if (orderDataBean.pcStateManager == null) {
            return orderDataBean.account;
        }
        int n = pcInheritedFieldCount + 0;
        orderDataBean.pcStateManager.accessingField(n);
        return orderDataBean.account;
    }

    private static final void pcSetaccount(OrderDataBean orderDataBean, AccountDataBean accountDataBean) {
        if (orderDataBean.pcStateManager == null) {
            orderDataBean.account = accountDataBean;
            return;
        }
        orderDataBean.pcStateManager.settingObjectField((PersistenceCapable)orderDataBean, pcInheritedFieldCount + 0, (Object)orderDataBean.account, (Object)accountDataBean, 0);
    }

    private static final Date pcGetcompletionDate(OrderDataBean orderDataBean) {
        if (orderDataBean.pcStateManager == null) {
            return orderDataBean.completionDate;
        }
        int n = pcInheritedFieldCount + 1;
        orderDataBean.pcStateManager.accessingField(n);
        return orderDataBean.completionDate;
    }

    private static final void pcSetcompletionDate(OrderDataBean orderDataBean, Date date) {
        if (orderDataBean.pcStateManager == null) {
            orderDataBean.completionDate = date;
            return;
        }
        orderDataBean.pcStateManager.settingObjectField((PersistenceCapable)orderDataBean, pcInheritedFieldCount + 1, (Object)orderDataBean.completionDate, (Object)date, 0);
    }

    private static final HoldingDataBean pcGetholding(OrderDataBean orderDataBean) {
        if (orderDataBean.pcStateManager == null) {
            return orderDataBean.holding;
        }
        int n = pcInheritedFieldCount + 2;
        orderDataBean.pcStateManager.accessingField(n);
        return orderDataBean.holding;
    }

    private static final void pcSetholding(OrderDataBean orderDataBean, HoldingDataBean holdingDataBean) {
        if (orderDataBean.pcStateManager == null) {
            orderDataBean.holding = holdingDataBean;
            return;
        }
        orderDataBean.pcStateManager.settingObjectField((PersistenceCapable)orderDataBean, pcInheritedFieldCount + 2, (Object)orderDataBean.holding, (Object)holdingDataBean, 0);
    }

    private static final Date pcGetopenDate(OrderDataBean orderDataBean) {
        if (orderDataBean.pcStateManager == null) {
            return orderDataBean.openDate;
        }
        int n = pcInheritedFieldCount + 3;
        orderDataBean.pcStateManager.accessingField(n);
        return orderDataBean.openDate;
    }

    private static final void pcSetopenDate(OrderDataBean orderDataBean, Date date) {
        if (orderDataBean.pcStateManager == null) {
            orderDataBean.openDate = date;
            return;
        }
        orderDataBean.pcStateManager.settingObjectField((PersistenceCapable)orderDataBean, pcInheritedFieldCount + 3, (Object)orderDataBean.openDate, (Object)date, 0);
    }

    private static final BigDecimal pcGetorderFee(OrderDataBean orderDataBean) {
        if (orderDataBean.pcStateManager == null) {
            return orderDataBean.orderFee;
        }
        int n = pcInheritedFieldCount + 4;
        orderDataBean.pcStateManager.accessingField(n);
        return orderDataBean.orderFee;
    }

    private static final void pcSetorderFee(OrderDataBean orderDataBean, BigDecimal bigDecimal) {
        if (orderDataBean.pcStateManager == null) {
            orderDataBean.orderFee = bigDecimal;
            return;
        }
        orderDataBean.pcStateManager.settingObjectField((PersistenceCapable)orderDataBean, pcInheritedFieldCount + 4, (Object)orderDataBean.orderFee, (Object)bigDecimal, 0);
    }

    private static final Integer pcGetorderID(OrderDataBean orderDataBean) {
        if (orderDataBean.pcStateManager == null) {
            return orderDataBean.orderID;
        }
        int n = pcInheritedFieldCount + 5;
        orderDataBean.pcStateManager.accessingField(n);
        return orderDataBean.orderID;
    }

    private static final void pcSetorderID(OrderDataBean orderDataBean, Integer n) {
        if (orderDataBean.pcStateManager == null) {
            orderDataBean.orderID = n;
            return;
        }
        orderDataBean.pcStateManager.settingObjectField((PersistenceCapable)orderDataBean, pcInheritedFieldCount + 5, (Object)orderDataBean.orderID, (Object)n, 0);
    }

    private static final String pcGetorderStatus(OrderDataBean orderDataBean) {
        if (orderDataBean.pcStateManager == null) {
            return orderDataBean.orderStatus;
        }
        int n = pcInheritedFieldCount + 6;
        orderDataBean.pcStateManager.accessingField(n);
        return orderDataBean.orderStatus;
    }

    private static final void pcSetorderStatus(OrderDataBean orderDataBean, String string) {
        if (orderDataBean.pcStateManager == null) {
            orderDataBean.orderStatus = string;
            return;
        }
        orderDataBean.pcStateManager.settingStringField((PersistenceCapable)orderDataBean, pcInheritedFieldCount + 6, orderDataBean.orderStatus, string, 0);
    }

    private static final String pcGetorderType(OrderDataBean orderDataBean) {
        if (orderDataBean.pcStateManager == null) {
            return orderDataBean.orderType;
        }
        int n = pcInheritedFieldCount + 7;
        orderDataBean.pcStateManager.accessingField(n);
        return orderDataBean.orderType;
    }

    private static final void pcSetorderType(OrderDataBean orderDataBean, String string) {
        if (orderDataBean.pcStateManager == null) {
            orderDataBean.orderType = string;
            return;
        }
        orderDataBean.pcStateManager.settingStringField((PersistenceCapable)orderDataBean, pcInheritedFieldCount + 7, orderDataBean.orderType, string, 0);
    }

    private static final BigDecimal pcGetprice(OrderDataBean orderDataBean) {
        if (orderDataBean.pcStateManager == null) {
            return orderDataBean.price;
        }
        int n = pcInheritedFieldCount + 8;
        orderDataBean.pcStateManager.accessingField(n);
        return orderDataBean.price;
    }

    private static final void pcSetprice(OrderDataBean orderDataBean, BigDecimal bigDecimal) {
        if (orderDataBean.pcStateManager == null) {
            orderDataBean.price = bigDecimal;
            return;
        }
        orderDataBean.pcStateManager.settingObjectField((PersistenceCapable)orderDataBean, pcInheritedFieldCount + 8, (Object)orderDataBean.price, (Object)bigDecimal, 0);
    }

    private static final double pcGetquantity(OrderDataBean orderDataBean) {
        if (orderDataBean.pcStateManager == null) {
            return orderDataBean.quantity;
        }
        int n = pcInheritedFieldCount + 9;
        orderDataBean.pcStateManager.accessingField(n);
        return orderDataBean.quantity;
    }

    private static final void pcSetquantity(OrderDataBean orderDataBean, double d) {
        if (orderDataBean.pcStateManager == null) {
            orderDataBean.quantity = d;
            return;
        }
        orderDataBean.pcStateManager.settingDoubleField((PersistenceCapable)orderDataBean, pcInheritedFieldCount + 9, orderDataBean.quantity, d, 0);
    }

    private static final QuoteDataBean pcGetquote(OrderDataBean orderDataBean) {
        if (orderDataBean.pcStateManager == null) {
            return orderDataBean.quote;
        }
        int n = pcInheritedFieldCount + 10;
        orderDataBean.pcStateManager.accessingField(n);
        return orderDataBean.quote;
    }

    private static final void pcSetquote(OrderDataBean orderDataBean, QuoteDataBean quoteDataBean) {
        if (orderDataBean.pcStateManager == null) {
            orderDataBean.quote = quoteDataBean;
            return;
        }
        orderDataBean.pcStateManager.settingObjectField((PersistenceCapable)orderDataBean, pcInheritedFieldCount + 10, (Object)orderDataBean.quote, (Object)quoteDataBean, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.orderID != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

