/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.integration.daytrader;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.openjpa.integration.daytrader.QuoteDataBean;
import org.apache.openjpa.integration.daytrader.TradeConfig;

public class MarketSummaryDataBean
implements Serializable {
    private static final long serialVersionUID = -2753373502228082501L;
    private BigDecimal TSIA;
    private BigDecimal openTSIA;
    private double volume;
    private Collection topGainers;
    private Collection topLosers;
    private Date summaryDate;
    private BigDecimal gainPercent = null;

    public MarketSummaryDataBean() {
    }

    public MarketSummaryDataBean(BigDecimal TSIA, BigDecimal openTSIA, double volume, Collection topGainers, Collection topLosers) {
        this.setTSIA(TSIA);
        this.setOpenTSIA(openTSIA);
        this.setVolume(volume);
        this.setTopGainers(topGainers);
        this.setTopLosers(topLosers);
        this.setSummaryDate(new java.sql.Date(System.currentTimeMillis()));
        this.gainPercent = this.computeGainPercent(this.getTSIA(), this.getOpenTSIA());
    }

    public static MarketSummaryDataBean getRandomInstance() {
        ArrayList<QuoteDataBean> gain = new ArrayList<QuoteDataBean>();
        ArrayList<QuoteDataBean> lose = new ArrayList<QuoteDataBean>();
        for (int ii = 0; ii < 5; ++ii) {
            QuoteDataBean quote1 = QuoteDataBean.getRandomInstance();
            QuoteDataBean quote2 = QuoteDataBean.getRandomInstance();
            gain.add(quote1);
            lose.add(quote2);
        }
        return new MarketSummaryDataBean(TradeConfig.rndBigDecimal(1000000.0f), TradeConfig.rndBigDecimal(1000000.0f), TradeConfig.rndQuantity(), gain, lose);
    }

    public String toString() {
        String ret = "\n\tMarket Summary at: " + this.getSummaryDate() + "\n\t\t        TSIA:" + this.getTSIA() + "\n\t\t    openTSIA:" + this.getOpenTSIA() + "\n\t\t        gain:" + this.getGainPercent() + "\n\t\t      volume:" + this.getVolume();
        if (this.getTopGainers() == null || this.getTopLosers() == null) {
            return ret;
        }
        ret = ret + "\n\t\t   Current Top Gainers:";
        for (QuoteDataBean quoteData : this.getTopGainers()) {
            ret = ret + "\n\t\t\t" + quoteData.toString();
        }
        ret = ret + "\n\t\t   Current Top Losers:";
        for (QuoteDataBean quoteData : this.getTopLosers()) {
            ret = ret + "\n\t\t\t" + quoteData.toString();
        }
        return ret;
    }

    public String toHTML() {
        String ret = "<BR>Market Summary at: " + this.getSummaryDate() + "<LI>        TSIA:" + this.getTSIA() + "</LI>" + "<LI>    openTSIA:" + this.getOpenTSIA() + "</LI>" + "<LI>      volume:" + this.getVolume() + "</LI>";
        if (this.getTopGainers() == null || this.getTopLosers() == null) {
            return ret;
        }
        ret = ret + "<BR> Current Top Gainers:";
        for (QuoteDataBean quoteData : this.getTopGainers()) {
            ret = ret + "<LI>" + quoteData.toString() + "</LI>";
        }
        ret = ret + "<BR>   Current Top Losers:";
        for (QuoteDataBean quoteData : this.getTopLosers()) {
            ret = ret + "<LI>" + quoteData.toString() + "</LI>";
        }
        return ret;
    }

    public void print() {
    }

    public BigDecimal getGainPercent() {
        if (this.gainPercent == null) {
            this.gainPercent = this.computeGainPercent(this.getTSIA(), this.getOpenTSIA());
        }
        return this.gainPercent;
    }

    public BigDecimal getTSIA() {
        return this.TSIA;
    }

    public void setTSIA(BigDecimal tSIA) {
        this.TSIA = tSIA;
    }

    public BigDecimal getOpenTSIA() {
        return this.openTSIA;
    }

    public void setOpenTSIA(BigDecimal openTSIA) {
        this.openTSIA = openTSIA;
    }

    public double getVolume() {
        return this.volume;
    }

    public void setVolume(double volume) {
        this.volume = volume;
    }

    public Collection getTopGainers() {
        return this.topGainers;
    }

    public void setTopGainers(Collection topGainers) {
        this.topGainers = topGainers;
    }

    public Collection getTopLosers() {
        return this.topLosers;
    }

    public void setTopLosers(Collection topLosers) {
        this.topLosers = topLosers;
    }

    public Date getSummaryDate() {
        return this.summaryDate;
    }

    public void setSummaryDate(Date summaryDate) {
        this.summaryDate = summaryDate;
    }

    private BigDecimal computeGainPercent(BigDecimal currentBalance, BigDecimal openBalance) {
        if (openBalance.doubleValue() == 0.0) {
            return new BigDecimal(0.0).setScale(2);
        }
        BigDecimal gainPercent = currentBalance.divide(openBalance, 4).subtract(new BigDecimal(1.0).setScale(2)).multiply(new BigDecimal(100.0).setScale(2));
        return gainPercent;
    }
}

